/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls;

import eu.dnetlib.validator.engine.Validator;
import eu.dnetlib.validator.engine.ValidatorException;
import eu.dnetlib.validator.engine.data.Provider;
import eu.dnetlib.validator.engine.data.Rule;
import eu.dnetlib.validator.engine.execution.Executor;
import eu.dnetlib.validator.engine.execution.Job;
import eu.dnetlib.validator.engine.execution.JobListener;
import eu.dnetlib.validator.service.impls.MemoryThreadValidator;
import eu.dnetlib.validator.service.impls.executors.ThreadExecutorSubmitter;
import eu.dnetlib.validator.service.impls.listeners.CrisListener;
import eu.dnetlib.validator.service.impls.listeners.ListenersManager;
import eu.dnetlib.validator.service.impls.persistance.MemoryRegistry;
import eu.dnetlib.validator.service.impls.providers.CrisProvider;
import eu.dnetlib.validator.service.impls.providers.OAIPMHRecordProvider;
import eu.dnetlib.validator.service.impls.providers.ProvidersManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.apache.log4j.Logger;

@Deprecated
public class MemoryThreadValidator
implements Validator {
    private CacheManager cacheManager;
    private ProvidersManager providersManager;
    private ListenersManager listenersManager;
    private transient Logger log = Logger.getLogger(MemoryThreadValidator.class);
    private final ExecutorService executor;
    private final Executor taskExecutor;
    private final long timeout;
    private final long generalTimeout;
    private Boolean dnetWorkflow;
    private MemoryRegistry<Rule> rules;

    public MemoryThreadValidator(ExecutorService executor, Executor taskExecutor, long timeout, long generalTimeout) {
        this.log.info((Object)"Creating a new Validator");
        this.executor = executor;
        this.taskExecutor = taskExecutor;
        this.timeout = timeout;
        this.generalTimeout = generalTimeout;
        this.rules = new MemoryRegistry("RULES");
    }

    public void init() {
    }

    public <T extends Serializable> void addToRegistry(int objid, T obj, String registryName) {
        if (!registryName.equals("RULES")) {
            throw new UnsupportedOperationException("You may not add an object to a non-existing registry");
        }
        Rule rule = (Rule)obj;
        this.log.debug((Object)("Adding to registry rule " + rule.getId()));
        this.rules.addObject(rule.getId(), (Serializable)rule);
    }

    public Serializable getFromRegistry(int objid, String registryName) throws ValidatorException {
        if (registryName.equals("RULES")) {
            return this.rules.getObject(objid);
        }
        throw new ValidatorException("The registry " + registryName + " does not exist");
    }

    public <T extends Serializable> void addRegistry(String name) {
        throw new UnsupportedOperationException("You may not add new registries to this Validator implementation");
    }

    public void submitJob(Job job, int workers, JobListener ... listeners) throws ValidatorException {
        this.log.debug((Object)("Submitting job " + job.id));
        ArrayList<OAIPMHRecordProvider> providers = new ArrayList<OAIPMHRecordProvider>();
        try {
            this.log.debug((Object)"Creating a new provider instance");
            for (int i = 0; i < workers; ++i) {
                OAIPMHRecordProvider prv = null;
                if (job.providerId == 1) {
                    prv = this.providersManager.createOaipmhRecordProvider();
                } else if (job.providerId == 2) {
                    prv = this.providersManager.createOaipmhSinglePageVerbProvider();
                } else if (job.providerId == 3) {
                    prv = this.providersManager.createDnetProvider();
                }
                providers.add(prv);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error creating provider instance", (Throwable)e);
        }
        ValidatorJobMainListener mainListener = new ValidatorJobMainListener(this, null);
        Integer workerId = 0;
        for (Provider provider : providers) {
            Properties props = job.providerProps;
            if (job.providerProps.getProperty("MDSTORE_ID") != null) {
                props = new Properties();
                props.setProperty("WORKER_ID", Integer.toString(workerId));
                props.setProperty("WORKERS", Integer.toString(workers));
                props.setProperty("MDSTORE_ID", job.providerProps.getProperty("MDSTORE_ID"));
                props.setProperty("BATCH_SIZE", job.providerProps.getProperty("BATCH_SIZE"));
                props.setProperty("RECORDS", job.providerProps.getProperty("RECORDS"));
            }
            Integer n = workerId;
            Integer n2 = workerId = Integer.valueOf(workerId + 1);
            provider.setConfiguration(props);
            String set = props.getProperty("set");
            if (set == null) {
                set = "none";
            }
            ThreadExecutorSubmitter submitter = new ThreadExecutorSubmitter(job.id, job.rules, set, provider, (JobListener)mainListener, this.taskExecutor, this.timeout, this.generalTimeout, listeners);
            this.executor.submit((Runnable)submitter);
        }
    }

    public void shutdown() throws ValidatorException {
        this.log.info((Object)"Shutting down validator");
        this.executor.shutdownNow();
        this.rules = null;
    }

    public void submitJobForCris(Job job, Map<String, Set<Rule>> rulesPerEntity, Map<String, Set<Rule>> rulesPerEntityRef, JobListener ... listeners) throws ValidatorException {
        CrisProvider prv = this.providersManager.createCrisProvider();
        this.log.debug((Object)("creating cris  - timeout: " + prv.getTimeout()));
        String cacheName = UUID.randomUUID().toString();
        Properties props = job.providerProps;
        if (!rulesPerEntityRef.isEmpty()) {
            this.cacheManager.addCache(new Cache(cacheName, 20000, true, true, 10000L, 10000L));
            this.log.debug((Object)"caches: ");
            for (String cache : this.cacheManager.getCacheNames()) {
                this.log.debug((Object)("name: " + cache));
            }
            prv.setCache(this.cacheManager.getCache(cacheName));
        }
        prv.setEntities(rulesPerEntity.keySet());
        prv.setBaseUrl(props.getProperty("BASEURL"));
        prv.setMetadataPrefix(props.getProperty("metadataPrefix"));
        prv.setRecords(props.getProperty("records"));
        ValidatorJobMainListener mainListener = new ValidatorJobMainListener(this, null);
        CrisListener crisListener = this.listenersManager.createCrisListener();
        crisListener.setWorkersFirstPhase(rulesPerEntity.keySet().size());
        crisListener.setProvider(prv);
        crisListener.setWorkers(rulesPerEntity.keySet().size() + rulesPerEntityRef.keySet().size());
        if (!rulesPerEntityRef.isEmpty()) {
            crisListener.setCacheManager(this.cacheManager);
            crisListener.setCacheName(cacheName);
        }
        mainListener.setCrisListener(crisListener);
        for (Map.Entry<String, Set<Rule>> entry : rulesPerEntity.entrySet()) {
            this.log.debug((Object)("Cris# set: " + entry.getKey() + " - Rules size: " + entry.getValue().size()));
            prv.setSet(entry.getKey());
            props.setProperty("set", entry.getKey());
            prv.setConfiguration(props);
            ThreadExecutorSubmitter submitter = new ThreadExecutorSubmitter(job.id, entry.getValue(), entry.getKey(), (Provider)prv, (JobListener)mainListener, this.taskExecutor, this.timeout, this.generalTimeout, listeners);
            this.executor.submit((Runnable)submitter);
        }
        this.log.error((Object)"Creating Sumbitters for referential check..");
        ArrayList<ThreadExecutorSubmitter> submittersForReferential = new ArrayList<ThreadExecutorSubmitter>();
        for (Map.Entry<String, Set<Rule>> entry : rulesPerEntityRef.entrySet()) {
            this.log.error((Object)("Ref Submitter set: " + entry.getKey() + " and rules: " + entry.getValue() + " and new rule ids: " + entry.getValue().size()));
            prv.setSet(entry.getKey());
            props.setProperty("set", entry.getKey());
            prv.setConfiguration(props);
            submittersForReferential.add(new ThreadExecutorSubmitter(job.id, entry.getValue(), entry.getKey(), (Provider)prv, (JobListener)mainListener, this.taskExecutor, this.timeout, this.generalTimeout, listeners));
        }
        this.log.error((Object)("Sumbitters created for referential check: " + submittersForReferential.size()));
    }

    public void start() throws ValidatorException {
        this.log.debug((Object)"Starting validator");
    }

    public Boolean getDnetWorkflow() {
        return this.dnetWorkflow;
    }

    public void setDnetWorkflow(Boolean dnetWorkflow) {
        this.dnetWorkflow = dnetWorkflow;
    }

    public ProvidersManager getProvidersManager() {
        return this.providersManager;
    }

    public void setProvidersManager(ProvidersManager providersManager) {
        this.providersManager = providersManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public ListenersManager getListenersManager() {
        return this.listenersManager;
    }

    public void setListenersManager(ListenersManager listenersManager) {
        this.listenersManager = listenersManager;
    }

    static /* synthetic */ Logger access$100(MemoryThreadValidator x0) {
        return x0.log;
    }
}

