/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impl;

import eu.dnetlib.domain.functionality.validator.CustomProperties;
import eu.dnetlib.domain.functionality.validator.JobForValidation;
import eu.dnetlib.domain.functionality.validator.Rule;
import eu.dnetlib.domain.functionality.validator.RuleSet;
import eu.dnetlib.domain.functionality.validator.StoredJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardNotificationHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.validator.commons.dao.DaoException;
import eu.dnetlib.validator.commons.dao.jobs.JobsDAO;
import eu.dnetlib.validator.commons.dao.rules.RulesDAO;
import eu.dnetlib.validator.commons.dao.rules.RulesetsDAO;
import eu.dnetlib.validator.commons.email.Emailer;
import eu.dnetlib.validator.engine.Validator;
import eu.dnetlib.validator.engine.ValidatorException;
import eu.dnetlib.validator.engine.execution.Job;
import eu.dnetlib.validator.engine.execution.JobListener;
import eu.dnetlib.validator.service.impl.ValidatorManager;
import eu.dnetlib.validator.service.impls.ValidatorRestore;
import eu.dnetlib.validator.service.impls.listeners.CompatibilityTestListener;
import eu.dnetlib.validator.service.impls.listeners.DnetListener;
import eu.dnetlib.validator.service.impls.listeners.ListenersManager;
import eu.dnetlib.validator.service.impls.listeners.RegistrationListener;
import eu.dnetlib.validator.service.impls.listeners.ValidatorJobListener;
import eu.dnetlib.validator.service.impls.rules.ChainRule;
import eu.dnetlib.validator.service.impls.rules.RuleTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ValidatorManagerImpl
implements ValidatorManager {
    private Emailer emailer;
    private Validator validator;
    private JobsDAO jobsDao;
    private RulesetsDAO rulesetsDao;
    private RulesDAO rulesDao;
    private ValidatorRestore valRestore;
    private static Logger logger = Logger.getLogger(ValidatorManagerImpl.class);
    private ListenersManager listenersManager;

    public void start() {
        logger.info((Object)"Initializing Validator Manager module");
        if (this.valRestore.isAutoRestoreOnStartup()) {
            logger.info((Object)"auto-restoring OpenAire Validator is enabled..");
            List jobs = this.valRestore.deleteUncompleted();
            this.valRestore.restartJobs(jobs);
            logger.info((Object)"finished restoring OpenAire Validator..");
        } else {
            logger.info((Object)"auto-restoring OpenAire Validator is disabled..");
        }
    }

    public StoredJob getStoredJob(int jobId, String groupBy) throws ValidatorException {
        try {
            logger.info((Object)("Getting job summary for job " + jobId + " with groupBy: " + groupBy));
            return this.jobsDao.getJobSummary(jobId, groupBy);
        }
        catch (Exception e) {
            logger.error((Object)("error getting job summary for job " + jobId), (Throwable)e);
            throw new ValidatorException((Throwable)e);
        }
    }

    public List<StoredJob> getJobSummary(List<String> baseUrl, int limit) throws DaoException {
        return this.jobsDao.getJobSummary(baseUrl, limit);
    }

    public List<StoredJob> getStoredJobs(String userMail, String jobType, Integer offset, Integer limit, String dateFrom, String dateTo) throws ValidatorException {
        return this.getStoredJobs(userMail, jobType, offset, limit, dateFrom, dateTo, null);
    }

    public List<StoredJob> getStoredJobs(String userMail, String jobType, Integer offset, Integer limit, String dateFrom, String dateTo, String jobStatus) throws ValidatorException {
        try {
            logger.debug((Object)("Getting jobs of user " + userMail));
            return this.jobsDao.getJobs(userMail, jobType, offset, limit, dateFrom, dateTo, jobStatus);
        }
        catch (Exception e) {
            logger.error((Object)("error Getting jobs of user " + userMail), (Throwable)e);
            throw new ValidatorException((Throwable)e);
        }
    }

    public int getStoredJobsTotalNumber(String userMail, String jobType) throws ValidatorException {
        return this.getStoredJobsTotalNumber(userMail, jobType, null);
    }

    public int getStoredJobsTotalNumber(String userMail, String jobType, String jobStatus) throws ValidatorException {
        try {
            logger.debug((Object)("Getting jobs total sum of user " + userMail));
            return this.jobsDao.getJobsTotalNumber(userMail, jobType, jobStatus);
        }
        catch (Exception e) {
            logger.error((Object)("error Getting jobs sum of user " + userMail), (Throwable)e);
            throw new ValidatorException((Throwable)e);
        }
    }

    public List<RuleSet> getRuleSets() throws ValidatorException {
        try {
            logger.info((Object)"Getting rulesets");
            return this.rulesetsDao.getRuleSets();
        }
        catch (Exception e) {
            logger.error((Object)"error Getting rulesets ", (Throwable)e);
            throw new ValidatorException((Throwable)e);
        }
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRES_NEW)
    public StoredJob beginDataJobForWorkflow(String mdstoreId, String guidelines, String groupBy, int records, int workers, BlackboardJob bJob, BlackboardNotificationHandler<BlackboardServerHandler> blackboardHandler, int jobStatusUpdateInterval, boolean outputEpr, boolean blacklistedRecords, String blacklistGuidelines) throws ValidatorException {
        try {
            logger.info((Object)"Submitting data job for workflow");
            Set ruleIdsForBlacklist = new HashSet();
            Set ruleIdsContent = new HashSet();
            for (RuleSet ruleset : this.rulesetsDao.getRuleSets()) {
                if (ruleset.getGuidelinesAcronym().equals(guidelines)) {
                    ruleIdsContent = ruleset.getContentRulesIds();
                }
                if (!blacklistedRecords || !ruleset.getGuidelinesAcronym().equals(blacklistGuidelines)) continue;
                ruleIdsForBlacklist = ruleset.getContentRulesIds();
                ruleIdsContent.addAll(ruleIdsForBlacklist);
            }
            Properties props = new Properties();
            props.setProperty("MDSTORE_ID", mdstoreId);
            props.setProperty("BATCH_SIZE", "50");
            if (bJob.getParameters().get("batchSize") != null) {
                props.setProperty("BATCH_SIZE", (String)bJob.getParameters().get("batchSize"));
            }
            props.setProperty("RECORDS", Integer.toString(records));
            StoredJob newJob = new StoredJob();
            newJob.setUserEmail("Workflow Service");
            newJob.setValidationType("C");
            newJob.setDesiredCompatibilityLevel(guidelines);
            newJob.setContentJobStatus("ongoing");
            newJob.setUsageJobStatus("none");
            newJob.setJobType("Workflow Request");
            newJob.setDuration("--");
            newJob.setBaseUrl(mdstoreId);
            newJob.setRules(ruleIdsContent);
            newJob.setRecords(records);
            newJob.setValidationSet("dnet-workflow");
            newJob.setGroupByXpath(groupBy);
            newJob.setMetadataPrefix("oai_dc");
            newJob.setId(-1);
            int jobIdStored = this.jobsDao.save((Object)newJob);
            HashSet<Object> rulesContent = new HashSet<Object>();
            logger.debug((Object)("Selected content rules number: " + ruleIdsContent.size()));
            for (Integer ruleId : ruleIdsContent) {
                Rule tempRule = (Rule)this.rulesDao.get(ruleId.intValue());
                if (tempRule.getType().equals("ChainRule")) {
                    ChainRule chainRule = this.handleChain(tempRule);
                    rulesContent.add(chainRule);
                    continue;
                }
                rulesContent.add(this.getRuleClassInstanceByType(tempRule.getType(), tempRule.getConfiguration(), tempRule.getId()));
            }
            Job jobContent = new Job(jobIdStored, 3, rulesContent, props);
            ValidatorJobListener listenerContent = this.listenersManager.createListener();
            listenerContent.setJobSubmittedId(Integer.valueOf(jobIdStored));
            listenerContent.setJobSubmittedUser("Workflow Service");
            listenerContent.setGroupBy_xpath(groupBy);
            listenerContent.setValidationType("content");
            listenerContent.setInternalJobsSum(workers);
            listenerContent.setBlacklistRuleIds(ruleIdsForBlacklist);
            DnetListener dnetListener = this.listenersManager.createDnetListener();
            dnetListener.setJob(bJob);
            dnetListener.setBlackboardHandler(blackboardHandler);
            dnetListener.setInternalJobsSum(workers);
            dnetListener.setValidationJobId(jobIdStored);
            dnetListener.setJobStatusUpdateInterval(jobStatusUpdateInterval);
            dnetListener.setValidatorManager((ValidatorManager)this);
            dnetListener.setGroupBy(groupBy);
            if (blacklistedRecords) {
                dnetListener.setEnableOutputToDisk(true);
            }
            if (outputEpr) {
                dnetListener.setEnableOutputToRS(true);
            }
            dnetListener.initOutputs();
            this.validator.submitJob(jobContent, workers, new JobListener[]{listenerContent, dnetListener});
            return newJob;
        }
        catch (Exception e) {
            logger.error((Object)"Error Submitting content job", (Throwable)e);
            throw new ValidatorException((Throwable)e);
        }
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void submitJob(JobForValidation job) throws ValidatorException {
        try {
            logger.info((Object)("Submiting validation job requested by user: " + job.getUserEmail()));
            if (job.isRegistration() || job.isUpdateExisting()) {
                logger.debug((Object)("initiating preregistration validations on repo " + job.getBaseUrl() + " for user " + job.getUserEmail() + "and desired compatibility: " + job.getDesiredCompatibilityLevel()));
                for (RuleSet ruleset : this.rulesetsDao.getRuleSets(job.getDesiredCompatibilityLevel())) {
                    job.setSelectedContentRules(ruleset.getContentRulesIds());
                    job.setSelectedUsageRules(ruleset.getUsageRulesIds());
                }
            }
            if (job.getMetadataPrefix() == null || job.getMetadataPrefix().equals("")) {
                if (job.getDesiredCompatibilityLevel().toLowerCase().matches("^openaire4.0$")) {
                    logger.debug((Object)"Chosen set: OpenAIRE For Thematic + Institutional Repositories");
                    logger.debug((Object)"Setting METADATA_PREFIX to: oai_openaire");
                    job.setMetadataPrefix("oai_openaire");
                } else if (job.getDesiredCompatibilityLevel().toLowerCase().matches("^openaire\\d.\\d$") || job.getDesiredCompatibilityLevel().equalsIgnoreCase("driver")) {
                    logger.debug((Object)"Chosen set: OpenAIRE For Literature Repositories");
                    logger.debug((Object)"Setting METADATA_PREFIX to: oai_dc");
                    job.setMetadataPrefix("oai_dc");
                } else if (job.getDesiredCompatibilityLevel().toLowerCase().matches("^openaire\\d.\\d_data$")) {
                    logger.debug((Object)"Chosen set: OpenAIRE For Data Archives");
                    logger.debug((Object)"Setting METADATA_PREFIX to: oai_datacite");
                    job.setMetadataPrefix("oai_datacite");
                } else if (job.getDesiredCompatibilityLevel().toLowerCase().matches("^openaire\\d.\\d(.\\d)?_cris$")) {
                    logger.debug((Object)"Chosen set: OpenAIRE For Cris");
                    logger.debug((Object)"Setting METADATA_PREFIX to: oai_CERIF_openaire");
                    job.setMetadataPrefix("oai_CERIF_openaire");
                } else {
                    logger.error((Object)("Cannot set metadata prefx for " + job.getDesiredCompatibilityLevel() + " guidelines"));
                }
            }
            StoredJob newJob = new StoredJob(job);
            int usageJobs = 0;
            int contentJobs = 0;
            HashSet totalRules = new HashSet();
            HashMap verbRuleMap = null;
            String validationType = "";
            if (job.getSelectedContentRules() != null) {
                contentJobs = 1;
                validationType = validationType + "C";
                totalRules.addAll(job.getSelectedContentRules());
                newJob.setContentJobStatus("ongoing");
            } else {
                newJob.setContentJobStatus("none");
            }
            if (job.getSelectedUsageRules() != null) {
                logger.debug((Object)"Creating map for provider information");
                verbRuleMap = new HashMap();
                HashSet<Integer> temp = null;
                for (Integer id : job.getSelectedUsageRules()) {
                    Rule ruleStored = (Rule)this.rulesDao.get(id.intValue());
                    logger.debug((Object)("Checking for verb : " + ruleStored.getProvider_information()));
                    Set old = (Set)verbRuleMap.get(ruleStored.getProvider_information());
                    if (old == null) {
                        logger.debug((Object)"Verb doesn't exist");
                        temp = new HashSet<Integer>();
                        temp.add(ruleStored.getId());
                        verbRuleMap.put(ruleStored.getProvider_information(), temp);
                        continue;
                    }
                    logger.debug((Object)"Verb exists");
                    old.add(ruleStored.getId());
                }
                usageJobs = verbRuleMap.size();
                validationType = validationType + "U";
                totalRules.addAll(job.getSelectedUsageRules());
                newJob.setUsageJobStatus("ongoing");
            } else {
                newJob.setUsageJobStatus("none");
            }
            HashMap entityChosenRulesMap = null;
            HashMap entityChosenRulesMapReferential = null;
            if (job.isCris()) {
                entityChosenRulesMap = new HashMap();
                entityChosenRulesMapReferential = new HashMap();
                this.prepareCrisJobs(job, entityChosenRulesMap, entityChosenRulesMapReferential);
                newJob.setGroupByXpath("//header/setSpec");
                contentJobs = entityChosenRulesMap.keySet().size() + entityChosenRulesMapReferential.keySet().size();
                newJob.setCris(true);
                newJob.setSelectedCrisEntities(job.getSelectedCrisEntities());
                newJob.setCrisReferentialChecks(job.isCrisReferentialChecks());
            }
            newJob.setValidationType(validationType);
            if (job.isRegistration() || job.isUpdateExisting()) {
                newJob.setJobType("Registration Request");
                newJob.setActivationId(job.getActivationId());
                newJob.setRegistration(true);
                newJob.setUpdateExisting(job.isUpdateExisting());
                newJob.setOfficialName(job.getOfficialName());
                newJob.setAdminEmails(job.getAdminEmails());
                newJob.setDatasourceId(job.getDatasourceId());
                newJob.setInterfaceId(job.getInterfaceId());
                newJob.setInterfaceIdOld(job.getInterfaceIdOld());
                newJob.setRepoType(job.getRepoType());
            } else {
                newJob.setJobType("Compatibility Test");
            }
            newJob.setDuration("--");
            newJob.setRules(totalRules);
            newJob.setId(-1);
            int jobIdStored = this.jobsDao.save((Object)newJob);
            RegistrationListener regListener = null;
            if (job.isRegistration() || job.isUpdateExisting()) {
                regListener = this.listenersManager.createRegListener();
                regListener.setUserMail(job.getUserEmail());
                regListener.setDatasourceId(job.getDatasourceId());
                regListener.setInterfaceId(job.getInterfaceId());
                regListener.setUpdateExisting(job.isUpdateExisting());
                regListener.setTotalJobs(usageJobs + contentJobs);
            }
            CompatibilityTestListener compTestListener = this.listenersManager.createCompTestListener();
            compTestListener.setValidationSet(job.getValidationSet());
            compTestListener.setGuidelines(job.getDesiredCompatibilityLevel());
            compTestListener.setTotalJobs(usageJobs + contentJobs);
            if (job.getSelectedContentRules() != null) {
                HashSet<Object> rulesContent = new HashSet<Object>();
                Properties props = new Properties();
                props.setProperty("BASEURL", job.getBaseUrl());
                props.setProperty("metadataPrefix", newJob.getMetadataPrefix());
                props.setProperty("records", Integer.toString(job.getRecords()));
                props.setProperty("set", job.getValidationSet());
                Job jobContent = null;
                ValidatorJobListener listenerContent = this.listenersManager.createListener();
                listenerContent.setJobSubmittedId(Integer.valueOf(jobIdStored));
                listenerContent.setJobSubmittedUser(job.getUserEmail());
                listenerContent.setGroupBy_xpath(newJob.getGroupByXpath());
                listenerContent.setValidationType("content");
                listenerContent.setInternalJobsSum(contentJobs);
                if (job.isCris()) {
                    logger.debug((Object)"Submiting job for cris.");
                    logger.debug((Object)("Total content jobs: " + contentJobs));
                    jobContent = new Job(jobIdStored, 4, rulesContent, props);
                    ArrayList recipientsMailAddr = new ArrayList();
                    recipientsMailAddr.add("andreas.czerniak@uni-bielefeld.de");
                    this.emailer.sendMail((List)recipientsMailAddr, "CrisJob submitting", "baseUrl: " + job.getBaseUrl(), false, (List)recipientsMailAddr);
                } else {
                    logger.debug((Object)("Selected content rules number: " + job.getSelectedContentRules().size()));
                    for (Integer ruleId : job.getSelectedContentRules()) {
                        Rule tempRule = (Rule)this.rulesDao.get(ruleId.intValue());
                        if (tempRule.getType().equals("ChainRule")) {
                            ChainRule chainRule = this.handleChain(tempRule);
                            rulesContent.add(chainRule);
                            continue;
                        }
                        rulesContent.add(this.getRuleClassInstanceByType(tempRule.getType(), tempRule.getConfiguration(), tempRule.getId()));
                    }
                    jobContent = new Job(jobIdStored, 1, rulesContent, props);
                    if (job.isRegistration() || job.isUpdateExisting()) {
                        this.validator.submitJob(jobContent, 1, new JobListener[]{listenerContent, regListener});
                    } else {
                        this.validator.submitJob(jobContent, 1, new JobListener[]{listenerContent, compTestListener});
                    }
                }
            }
            if (job.getSelectedUsageRules() != null) {
                ValidatorJobListener listenerUsage = this.listenersManager.createListener();
                listenerUsage.setJobSubmittedId(Integer.valueOf(jobIdStored));
                listenerUsage.setValidationType("usage");
                listenerUsage.setJobSubmittedUser(job.getUserEmail());
                listenerUsage.setInternalJobsSum(usageJobs);
                ArrayList<Job> jobsUsage = new ArrayList<Job>();
                for (Map.Entry entry : verbRuleMap.entrySet()) {
                    Properties pros = new Properties();
                    pros.setProperty("VERB", (String)entry.getKey());
                    pros.setProperty("BASEURL", job.getBaseUrl());
                    HashSet<eu.dnetlib.validator.engine.data.Rule> rulesUsage = new HashSet<eu.dnetlib.validator.engine.data.Rule>();
                    for (Integer ruleId : (Set)entry.getValue()) {
                        Rule tempRule = (Rule)this.rulesDao.get(ruleId.intValue());
                        logger.debug((Object)("prepare to add rule to registry with regexp: " + tempRule.getConfiguration().getProperty("regexp")));
                        rulesUsage.add(this.getRuleClassInstanceByType(tempRule.getType(), tempRule.getConfiguration(), tempRule.getId()));
                    }
                    jobsUsage.add(new Job(jobIdStored, 2, rulesUsage, pros));
                }
                for (Job jobUsage : jobsUsage) {
                    if (job.isRegistration() || job.isUpdateExisting()) {
                        this.validator.submitJob(jobUsage, 1, new JobListener[]{listenerUsage, regListener});
                        continue;
                    }
                    this.validator.submitJob(jobUsage, 1, new JobListener[]{listenerUsage, compTestListener});
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"error submitting job ", (Throwable)e);
            throw new ValidatorException((Throwable)e);
        }
    }

    private void prepareCrisJobs(JobForValidation job, Map<String, Set<eu.dnetlib.validator.engine.data.Rule>> entityChosenRulesMap, Map<String, Set<eu.dnetlib.validator.engine.data.Rule>> entityChosenRulesMapReferential) throws ValidatorException, DaoException {
        logger.debug((Object)("Selected Entities: " + job.getSelectedCrisEntities()));
        for (String entity : RuleTypes.getEntities().keySet()) {
            logger.debug((Object)("checking entity: " + entity));
            HashSet<eu.dnetlib.validator.engine.data.Rule> rulesBasic = new HashSet<eu.dnetlib.validator.engine.data.Rule>();
            HashSet<eu.dnetlib.validator.engine.data.Rule> rulesReferential = new HashSet<eu.dnetlib.validator.engine.data.Rule>();
            if (job.getSelectedCrisEntities().contains(entity)) {
                logger.debug((Object)("entity: " + entity + " is selected"));
                for (Rule rule : this.rulesDao.getAllRulesByJobTypeEntityType("content", entity)) {
                    if (!job.getSelectedContentRules().contains(rule.getId())) continue;
                    Rule tempRule = (Rule)this.rulesDao.get(rule.getId());
                    if (rule.getName().contains("Relationship")) {
                        if (!job.isCrisReferentialChecks()) continue;
                        rulesReferential.add(this.getRuleClassInstanceByType(tempRule.getType(), tempRule.getConfiguration(), tempRule.getId()));
                        continue;
                    }
                    rulesBasic.add(this.getRuleClassInstanceByType(tempRule.getType(), tempRule.getConfiguration(), tempRule.getId()));
                }
                logger.debug((Object)("Basic rules: " + rulesBasic.size()));
                logger.debug((Object)("Referential rules: " + rulesReferential.size()));
                entityChosenRulesMap.put(RuleTypes.getSetOfEntity((String)entity), rulesBasic);
                if (!job.isCrisReferentialChecks() || rulesReferential.isEmpty()) continue;
                entityChosenRulesMapReferential.put(RuleTypes.getSetOfEntity((String)entity), rulesReferential);
                continue;
            }
            logger.debug((Object)("entity: " + entity + " is not selected"));
        }
        logger.debug((Object)("Return entities: " + entityChosenRulesMap.keySet()));
    }

    public eu.dnetlib.validator.engine.data.Rule getRuleClassInstanceByType(String type, CustomProperties pros, int id) throws ValidatorException {
        logger.debug((Object)("getting rule object of type " + type));
        String classname = RuleTypes.getClassOfType((String)type);
        if (classname == null) {
            logger.debug((Object)("error getting rule object of type " + type + " classname=null"));
            return null;
        }
        try {
            Class<?> clazz = Class.forName(classname);
            logger.debug((Object)("classname: " + clazz.getName()));
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)pros.getProperties());
            return (eu.dnetlib.validator.engine.data.Rule)clazz.getConstructor(Properties.class, Integer.TYPE).newInstance(properties, id);
        }
        catch (Exception e) {
            logger.debug((Object)("error getting rule object: " + e));
            return null;
        }
    }

    private ChainRule<eu.dnetlib.validator.engine.data.Rule> handleChain(Rule tempRule) throws ValidatorException, DaoException {
        logger.debug((Object)"chain rule found");
        ArrayList<Object> rules_chain = new ArrayList<Object>();
        Rule tempRuleChain1 = (Rule)this.rulesDao.get(Integer.parseInt(tempRule.getConfiguration().getProperty("rule_1")));
        if (tempRuleChain1.getType().equals("ChainRule")) {
            ChainRule chainRule1 = this.handleChain(tempRuleChain1);
            rules_chain.add(chainRule1);
        } else {
            rules_chain.add(this.getRuleClassInstanceByType(tempRuleChain1.getType(), tempRuleChain1.getConfiguration(), tempRuleChain1.getId()));
        }
        Rule tempRuleChain2 = (Rule)this.rulesDao.get(Integer.parseInt(tempRule.getConfiguration().getProperty("rule_2")));
        if (tempRuleChain2.getType().equals("ChainRule")) {
            ChainRule chainRule2 = this.handleChain(tempRuleChain2);
            rules_chain.add(chainRule2);
        } else {
            rules_chain.add(this.getRuleClassInstanceByType(tempRuleChain2.getType(), tempRuleChain2.getConfiguration(), tempRuleChain2.getId()));
        }
        Properties chainPros = new Properties();
        chainPros.setProperty("type", tempRule.getConfiguration().getProperty("type"));
        ChainRule chainRule = new ChainRule(chainPros, tempRule.getId(), rules_chain);
        return chainRule;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public ListenersManager getListenersManager() {
        return this.listenersManager;
    }

    public void setListenersManager(ListenersManager listenersManager) {
        this.listenersManager = listenersManager;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public JobsDAO getJobsDao() {
        return this.jobsDao;
    }

    public void setJobsDao(JobsDAO jobsDao) {
        this.jobsDao = jobsDao;
    }

    public RulesetsDAO getRulesetsDao() {
        return this.rulesetsDao;
    }

    public void setRulesetsDao(RulesetsDAO rulesetsDao) {
        this.rulesetsDao = rulesetsDao;
    }

    public RulesDAO getRulesDao() {
        return this.rulesDao;
    }

    public void setRulesDao(RulesDAO rulesDao) {
        this.rulesDao = rulesDao;
    }

    public ValidatorRestore getValRestore() {
        return this.valRestore;
    }

    public void setValRestore(ValidatorRestore valRestore) {
        this.valRestore = valRestore;
    }
}

