/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.listeners;

import eu.dnetlib.validator.service.impls.listeners.AbstractValidatorListener;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RegistrationListener
extends AbstractValidatorListener {
    private String datasourceId;
    private String interfaceId;
    private String providerUrl = null;
    private String userMail;
    private static Logger logger = Logger.getLogger(RegistrationListener.class);

    public RegistrationListener() {
        logger.error((Object)"Creating new registration listener");
    }

    public synchronized void jobSuccess(int jobId, Map<String, Object> jobContext) {
        logger.info((Object)("Preregistration job " + jobId + " finished"));
        try {
            logger.debug((Object)("Sending results to provide @ " + this.providerUrl + "/validator/complete"));
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            map.add((Object)"interfaceId", (Object)this.interfaceId);
            map.add((Object)"repoId", (Object)this.datasourceId);
            map.add((Object)"jobId", (Object)Integer.toString(jobId));
            map.add((Object)"issuerEmail", (Object)this.userMail);
            map.add((Object)"isUpdate", (Object)Boolean.toString(this.updateExisting));
            map.add((Object)"isSuccess", (Object)"true");
            map.add((Object)"scoreUsage", (Object)Integer.toString(this.score_usage));
            map.add((Object)"scoreContent", (Object)Integer.toString(this.score_content));
            HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity responseEntity = restTemplate.postForEntity(this.providerUrl + "/validator/complete", (Object)request, String.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public synchronized void jobFailure(int jobId, Map<String, Object> jobContext, Throwable t) {
        logger.info((Object)("Pregistration job " + jobId + " failed with exception: " + t.getMessage()));
        try {
            logger.debug((Object)("Sending results to provide @ " + this.providerUrl + "/validator/complete"));
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            map.add((Object)"interfaceId", (Object)this.interfaceId);
            map.add((Object)"repoId", (Object)this.datasourceId);
            map.add((Object)"jobId", (Object)(this.jobId + ""));
            map.add((Object)"issuerEmail", (Object)this.userMail);
            map.add((Object)"isUpdate", (Object)(this.updateExisting + ""));
            map.add((Object)"isSuccess", (Object)"false");
            map.add((Object)"scoreUsage", (Object)(this.score_usage + ""));
            map.add((Object)"scoreContent", (Object)(this.score_content + ""));
            HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity responseEntity = restTemplate.postForEntity(this.providerUrl + "/validator/complete", (Object)request, String.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public String getProviderUrl() {
        return this.providerUrl;
    }

    public void setProviderUrl(String providerUrl) {
        this.providerUrl = providerUrl;
    }

    public int getJobId() {
        return this.jobId;
    }

    public void setJobId(int jobId) {
        this.jobId = jobId;
    }

    public String getUserMail() {
        return this.userMail;
    }

    public void setUserMail(String userMail) {
        this.userMail = userMail;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getInterfaceId() {
        return this.interfaceId;
    }

    public void setInterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
    }

    public boolean isUpdateExisting() {
        return this.updateExisting;
    }

    public void setUpdateExisting(boolean updateExisting) {
        this.updateExisting = updateExisting;
    }
}

