/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.listeners;

import eu.dnetlib.validator.commons.dao.jobs.JobsDAO;
import eu.dnetlib.validator.engine.execution.CompletedTask;
import eu.dnetlib.validator.engine.execution.JobListener;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractValidatorListener
implements JobListener {
    private static Logger logger = Logger.getLogger(AbstractValidatorListener.class);
    private JobsDAO jobsDao;
    protected int jobId;
    protected boolean updateExisting;
    private int totalJobs;
    private int jobsFinished = 0;
    protected int score_content = 0;
    protected int score_usage = 0;

    public AbstractValidatorListener() {
        logger.error((Object)"Creating new validator listener");
    }

    protected abstract void jobSuccess(int var1, Map<String, Object> var2);

    protected abstract void jobFailure(int var1, Map<String, Object> var2, Throwable var3);

    @Transactional(propagation=Propagation.REQUIRED)
    public synchronized void finished(int jobId, Map<String, Object> jobContext) {
        try {
            ++this.jobsFinished;
            if (jobContext.containsKey("score_content")) {
                this.score_content = (Integer)jobContext.get("score_content");
            } else if (jobContext.containsKey("score_usage")) {
                this.score_usage = (Integer)jobContext.get("score_usage");
            }
            if (this.jobsFinished == this.totalJobs) {
                logger.debug((Object)"all jobs for registration finished");
                this.jobsDao.setTotalJobFinished(jobId, null, Boolean.valueOf(false));
                logger.debug((Object)("id:" + jobId + "c: " + this.score_content + " u:" + this.score_usage));
                this.jobSuccess(((Integer)jobContext.get("jobSubmittedId")).intValue(), jobContext);
            } else {
                logger.debug((Object)("not all jobs finished yet. Waiting " + (this.totalJobs - this.jobsFinished) + " job(s) to finish"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while finalizing successfull registration job");
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public synchronized void failed(int jobId, Map<String, Object> jobContext, Throwable t) {
        try {
            this.jobsDao.setTotalJobFinished(jobId, t.getMessage(), Boolean.valueOf(true));
            this.jobFailure(((Integer)jobContext.get("jobSubmittedId")).intValue(), jobContext, t);
        }
        catch (Exception e) {
            logger.error((Object)"Error while finalizing failed registration job");
        }
    }

    public synchronized void currentResults(List<CompletedTask> tasks, int jobId, Object object, Map<String, Object> recordContext, Throwable t) {
    }

    public synchronized void currentResults(List<CompletedTask> tasks, int jobId, Object object, Map<String, Object> recordContext) {
    }

    public JobsDAO getJobsDao() {
        return this.jobsDao;
    }

    public void setJobsDao(JobsDAO jobsDao) {
        this.jobsDao = jobsDao;
    }

    public int getJobId() {
        return this.jobId;
    }

    public void setJobId(int jobId) {
        this.jobId = jobId;
    }

    public boolean isUpdateExisting() {
        return this.updateExisting;
    }

    public void setUpdateExisting(boolean updateExisting) {
        this.updateExisting = updateExisting;
    }

    public int getTotalJobs() {
        return this.totalJobs;
    }

    public void setTotalJobs(int totalJobs) {
        this.totalJobs = totalJobs;
    }

    public int getJobsFinished() {
        return this.jobsFinished;
    }

    public void setJobsFinished(int jobsFinished) {
        this.jobsFinished = jobsFinished;
    }

    public int getScore_content() {
        return this.score_content;
    }

    public void setScore_content(int score_content) {
        this.score_content = score_content;
    }

    public int getScore_usage() {
        return this.score_usage;
    }

    public void setScore_usage(int score_usage) {
        this.score_usage = score_usage;
    }
}

