/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.providers;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class URLStreamer {
    private transient Logger logger = Logger.getLogger(URLStreamer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponse(URL url, int timeout, int delay, int retryDelay, int retryEfforts) throws IOException {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e1) {
            this.logger.error((Object)"", (Throwable)e1);
            throw new IOException();
        }
        InputStream inStream = null;
        String ret = null;
        for (int i = 1; i <= retryEfforts; ++i) {
            try {
                HttpURLConnection huc;
                int code;
                URLConnection urlConn = url.openConnection();
                urlConn.setConnectTimeout(timeout);
                urlConn.setReadTimeout(timeout);
                urlConn.setAllowUserInteraction(false);
                urlConn.setDoOutput(true);
                if (urlConn instanceof HttpURLConnection && ((code = (huc = (HttpURLConnection)urlConn).getResponseCode()) < 200 || code >= 300)) {
                    this.logger.error((Object)("Status code: " + code + ". Retry effort: " + i));
                    try {
                        this.logger.debug((Object)("Sleeping for " + retryDelay + " millis before retrying"));
                        Thread.sleep(retryDelay);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        this.logger.error((Object)"", (Throwable)ex);
                        throw new IOException();
                    }
                }
                inStream = urlConn.getInputStream();
                ret = IOUtils.toString((InputStream)inStream, (String)"UTF-8");
            }
            catch (Exception e) {
                this.logger.error((Object)("Exception raised. Retry effort: " + i), (Throwable)e);
                try {
                    this.logger.debug((Object)("Sleeping for " + retryDelay + " millis before retrying"));
                    Thread.sleep(retryDelay);
                    continue;
                }
                catch (InterruptedException ex) {
                    this.logger.error((Object)"", (Throwable)ex);
                    throw new IOException();
                }
            }
            finally {
                if (inStream != null) {
                    inStream.close();
                }
            }
            return ret;
        }
        return null;
    }
}

