/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.rules.oaipmh;

import eu.dnetlib.validator.engine.data.DataException;
import eu.dnetlib.validator.engine.data.Rule;
import eu.dnetlib.validator.engine.data.RuleException;
import eu.dnetlib.validator.engine.execution.ValidationObject;
import eu.dnetlib.validator.service.impls.valobjs.XMLTextValidationObject;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import org.w3c.dom.NodeList;

public class OAIPMHIncrementalRecordDeliveryRule
extends Rule {
    private static final long serialVersionUID = -5193298020858675978L;
    public static final String FROM = "from";
    public static final String UNTIL = "until";

    public OAIPMHIncrementalRecordDeliveryRule(Properties pros, int id) {
        super(pros, id);
    }

    public boolean apply(ValidationObject obj) throws RuleException {
        NodeList nodes;
        XMLTextValidationObject tobj = (XMLTextValidationObject)obj;
        try {
            nodes = tobj.getNodes("/OAI-PMH/ListIdentifiers/header/datestamp/text()");
        }
        catch (DataException e) {
            this.log.error((Object)"", (Throwable)e);
            return false;
        }
        try {
            String from = this.pros.getProperty(FROM);
            String until = this.pros.getProperty(UNTIL);
            for (int i = 0; i < nodes.getLength(); ++i) {
                String datestamp = nodes.item(i).getNodeValue();
                this.log.debug((Object)("Incremental Record Delivery Rule. Datestamp: " + datestamp));
                SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
                Date dateFrom = null;
                Date dateUntil = null;
                Date dateCurrent = null;
                dateFrom = df2.parse(from);
                dateUntil = df2.parse(until);
                try {
                    dateCurrent = df1.parse(datestamp);
                }
                catch (Exception ex) {
                    try {
                        dateCurrent = df2.parse(datestamp);
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                Calendar fromCal = Calendar.getInstance();
                Calendar untilCal = Calendar.getInstance();
                Calendar currentCal = Calendar.getInstance();
                fromCal.setTime(dateFrom);
                untilCal.setTime(dateUntil);
                currentCal.setTime(dateCurrent);
                long millsLeast = fromCal.getTimeInMillis();
                long millsMost = untilCal.getTimeInMillis();
                long millsCurrent = currentCal.getTimeInMillis();
                if (millsCurrent >= millsLeast && millsCurrent <= millsMost) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)"", (Throwable)e);
            throw new RuleException(e.getMessage());
        }
    }
}

