/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls;

import eu.dnetlib.validator.engine.Validator;
import eu.dnetlib.validator.engine.ValidatorException;
import eu.dnetlib.validator.engine.data.Provider;
import eu.dnetlib.validator.engine.data.Rule;
import eu.dnetlib.validator.engine.execution.Job;
import eu.dnetlib.validator.engine.execution.JobListener;
import eu.dnetlib.validator.service.impls.SpringValidator;
import eu.dnetlib.validator.service.impls.executors.JobWorker;
import eu.dnetlib.validator.service.impls.listeners.CrisListener;
import eu.dnetlib.validator.service.impls.listeners.ListenersManager;
import eu.dnetlib.validator.service.impls.providers.CrisProvider;
import eu.dnetlib.validator.service.impls.providers.OAIPMHRecordProvider;
import eu.dnetlib.validator.service.impls.providers.ProvidersManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.apache.log4j.Logger;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;

public class SpringValidator
implements Validator {
    private CacheManager cacheManager;
    private ProvidersManager providersManager;
    private ListenersManager listenersManager;
    private transient Logger log = Logger.getLogger(SpringValidator.class);
    private final TaskExecutor jobExecutor;
    private final SyncTaskExecutor taskExecutor;
    private final long generalTimeout;
    private Boolean dnetWorkflow;

    public SpringValidator(TaskExecutor jobExecutor, SyncTaskExecutor taskExecutor, long generalTimeout) {
        this.log.info((Object)"Creating a new Validator");
        this.generalTimeout = generalTimeout;
        this.taskExecutor = taskExecutor;
        this.jobExecutor = jobExecutor;
    }

    public <T extends Serializable> void addToRegistry(int objid, T obj, String registryName) {
        throw new UnsupportedOperationException("You may not add new registries to this Validator implementation");
    }

    public Serializable getFromRegistry(int objid, String registryName) throws ValidatorException {
        throw new UnsupportedOperationException("You may not add new registries to this Validator implementation");
    }

    public <T extends Serializable> void addRegistry(String name) {
        throw new UnsupportedOperationException("You may not add new registries to this Validator implementation");
    }

    public void submitJob(Job job, int workers, JobListener ... listeners) throws ValidatorException {
        this.log.debug((Object)("Submitting job " + job.id));
        ArrayList<OAIPMHRecordProvider> providers = new ArrayList<OAIPMHRecordProvider>();
        try {
            this.log.debug((Object)"Creating a new provider instance");
            for (int i = 0; i < workers; ++i) {
                OAIPMHRecordProvider prv = null;
                if (job.providerId == 1) {
                    prv = this.providersManager.createOaipmhRecordProvider();
                } else if (job.providerId == 2) {
                    prv = this.providersManager.createOaipmhSinglePageVerbProvider();
                } else if (job.providerId == 3) {
                    prv = this.providersManager.createDnetProvider();
                }
                providers.add(prv);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error creating provider instance", (Throwable)e);
        }
        ValidatorJobMainListener mainListener = new ValidatorJobMainListener(this, null);
        Integer workerId = 0;
        for (Provider provider : providers) {
            Properties props = job.providerProps;
            if (job.providerProps.getProperty("MDSTORE_ID") != null) {
                props = new Properties();
                props.setProperty("WORKER_ID", Integer.toString(workerId));
                props.setProperty("WORKERS", Integer.toString(workers));
                props.setProperty("MDSTORE_ID", job.providerProps.getProperty("MDSTORE_ID"));
                props.setProperty("BATCH_SIZE", job.providerProps.getProperty("BATCH_SIZE"));
                props.setProperty("RECORDS", job.providerProps.getProperty("RECORDS"));
            }
            Integer n = workerId;
            Integer n2 = workerId = Integer.valueOf(workerId + 1);
            provider.setConfiguration(props);
            String set = props.getProperty("set");
            if (set == null) {
                set = "none";
            }
            JobWorker jobWorker = new JobWorker(job.id, job.rules, set, provider, (JobListener)mainListener, this.taskExecutor, this.generalTimeout, listeners);
            this.jobExecutor.execute((Runnable)jobWorker);
        }
    }

    public void submitJobForCris(Job job, Map<String, Set<Rule>> rulesPerEntity, Map<String, Set<Rule>> rulesPerEntityRef, JobListener ... listeners) throws ValidatorException {
        CrisProvider prv = this.providersManager.createCrisProvider();
        this.log.debug((Object)("creating cris  - timeout: " + prv.getTimeout()));
        String cacheName = UUID.randomUUID().toString();
        Properties props = job.providerProps;
        if (!rulesPerEntityRef.isEmpty()) {
            this.cacheManager.addCache(new Cache(cacheName, 20000, true, true, 10000L, 10000L));
            this.log.debug((Object)"caches: ");
            for (String cache : this.cacheManager.getCacheNames()) {
                this.log.debug((Object)("name: " + cache));
            }
            prv.setCache(this.cacheManager.getCache(cacheName));
        }
        prv.setEntities(rulesPerEntity.keySet());
        prv.setBaseUrl(props.getProperty("BASEURL"));
        prv.setMetadataPrefix(props.getProperty("metadataPrefix"));
        prv.setRecords(props.getProperty("records"));
        ValidatorJobMainListener mainListener = new ValidatorJobMainListener(this, null);
        CrisListener crisListener = this.listenersManager.createCrisListener();
        crisListener.setWorkersFirstPhase(rulesPerEntity.keySet().size());
        crisListener.setExecutor(this.jobExecutor);
        crisListener.setProvider(prv);
        crisListener.setWorkers(rulesPerEntity.keySet().size() + rulesPerEntityRef.keySet().size());
        if (!rulesPerEntityRef.isEmpty()) {
            crisListener.setCacheManager(this.cacheManager);
            crisListener.setCacheName(cacheName);
        }
        mainListener.setCrisListener(crisListener);
        for (Map.Entry<String, Set<Rule>> entry : rulesPerEntity.entrySet()) {
            this.log.debug((Object)("Cris# set: " + entry.getKey() + " - Rules size: " + entry.getValue().size()));
            prv.setSet(entry.getKey());
            props.setProperty("set", entry.getKey());
            prv.setConfiguration(props);
            JobWorker jobWorker = new JobWorker(job.id, entry.getValue(), entry.getKey(), (Provider)prv, (JobListener)mainListener, this.taskExecutor, this.generalTimeout, listeners);
            this.jobExecutor.execute((Runnable)jobWorker);
        }
        this.log.error((Object)"Creating Sumbitters for referential check..");
        ArrayList<JobWorker> submittersForReferential = new ArrayList<JobWorker>();
        for (Map.Entry<String, Set<Rule>> entry : rulesPerEntityRef.entrySet()) {
            this.log.error((Object)("Ref Submitter set: " + entry.getKey() + " and rules: " + entry.getValue() + " and new rule ids: " + entry.getValue().size()));
            prv.setSet(entry.getKey());
            props.setProperty("set", entry.getKey());
            prv.setConfiguration(props);
            submittersForReferential.add(new JobWorker(job.id, entry.getValue(), entry.getKey(), (Provider)prv, (JobListener)mainListener, this.taskExecutor, this.generalTimeout, listeners));
        }
        crisListener.setSubmittersForReferential(submittersForReferential);
        this.log.error((Object)("Sumbitters created for referential check: " + submittersForReferential.size()));
    }

    public void start() throws ValidatorException {
        this.log.debug((Object)"Starting validator");
    }

    public Boolean getDnetWorkflow() {
        return this.dnetWorkflow;
    }

    public void setDnetWorkflow(Boolean dnetWorkflow) {
        this.dnetWorkflow = dnetWorkflow;
    }

    public ProvidersManager getProvidersManager() {
        return this.providersManager;
    }

    public void setProvidersManager(ProvidersManager providersManager) {
        this.providersManager = providersManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public ListenersManager getListenersManager() {
        return this.listenersManager;
    }

    public void setListenersManager(ListenersManager listenersManager) {
        this.listenersManager = listenersManager;
    }

    public void shutdown() throws ValidatorException {
    }

    static /* synthetic */ Logger access$100(SpringValidator x0) {
        return x0.log;
    }
}

