/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.rules.oaipmh;

import eu.dnetlib.validator.engine.data.DataException;
import eu.dnetlib.validator.engine.data.Rule;
import eu.dnetlib.validator.engine.data.RuleException;
import eu.dnetlib.validator.engine.execution.ValidationObject;
import eu.dnetlib.validator.service.impls.valobjs.XMLTextValidationObject;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import org.w3c.dom.NodeList;

public class OAIPMHResumptionTokenDurationRule
extends Rule {
    private static final long serialVersionUID = 1409872914282475394L;
    public static final String DURATION = "duration";

    public OAIPMHResumptionTokenDurationRule(Properties pros, int id) {
        super(pros, id);
    }

    public boolean apply(ValidationObject obj) throws RuleException {
        NodeList nodes1;
        NodeList nodes;
        XMLTextValidationObject tobj = (XMLTextValidationObject)obj;
        try {
            nodes = tobj.getNodes("/OAI-PMH/ListRecords/resumptionToken/@expirationDate");
            nodes1 = tobj.getNodes("/OAI-PMH/responseDate/text()");
        }
        catch (DataException e) {
            this.log.error((Object)"", (Throwable)e);
            return false;
        }
        try {
            if (nodes.getLength() == 0) {
                return true;
            }
            String expirationDateS = nodes.item(0).getNodeValue();
            String responseDateS = nodes1.item(0).getNodeValue();
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
            Date expirationDate = null;
            Date responseDate = null;
            try {
                expirationDate = df1.parse(expirationDateS);
            }
            catch (Exception ex) {
                try {
                    expirationDate = df2.parse(expirationDateS);
                }
                catch (Exception e) {
                    return false;
                }
            }
            try {
                responseDate = df1.parse(responseDateS);
            }
            catch (Exception ex) {
                try {
                    responseDate = df2.parse(responseDateS);
                }
                catch (Exception e) {
                    return false;
                }
            }
            this.log.debug((Object)("Resumption Token Duration. Response date: " + responseDate + ", expiration date: " + expirationDate));
            Calendar responseCal = Calendar.getInstance();
            Calendar expiryCal = Calendar.getInstance();
            responseCal.setTime(responseDate);
            expiryCal.setTime(expirationDate);
            long response = responseCal.getTimeInMillis();
            long expiry = expiryCal.getTimeInMillis();
            long duration = Long.parseLong(this.pros.getProperty(DURATION));
            return expiry - response >= duration;
        }
        catch (Exception e) {
            this.log.error((Object)"", (Throwable)e);
            throw new RuleException(e.getMessage());
        }
    }
}

