/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.listeners;

import eu.dnetlib.validator.commons.email.Emailer;
import eu.dnetlib.validator.service.impls.listeners.AbstractValidatorListener;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class CompatibilityTestListener
extends AbstractValidatorListener {
    private static Logger logger = Logger.getLogger(CompatibilityTestListener.class);
    private Emailer emailer = null;
    private String valBaseUrl = null;
    private String validationSet = null;
    private String guidelines = null;

    protected void jobSuccess(int jobId, Map<String, Object> jobContext) {
        this.sendMail(jobId, (String)jobContext.get("jobSubmittedUser"));
    }

    protected void jobFailure(int jobId, Map<String, Object> jobContext, Throwable t) {
        this.sendMail(jobId, (String)jobContext.get("jobSubmittedUser"));
    }

    private void sendMail(int jobSubmittedId, String jobSubmittedUser) {
        logger.debug((Object)("JOBID:" + jobSubmittedId + "# Sending email for finished job"));
        String mailTo = jobSubmittedUser;
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add(mailTo);
        String msgUpgrade = "";
        if (this.guidelines.equalsIgnoreCase("openaire2.0") || this.guidelines.equalsIgnoreCase("driver")) {
            msgUpgrade = "\n\n Please consider to upgrade to OpenAIRE Guidelines v3. Link: https://guidelines.openaire.eu/wiki/OpenAIRE_Guidelines:_For_Literature_repositories";
        }
        String message = "The compatibility test you have submitted has finished. You can retrieve the results by following this url: " + this.valBaseUrl + "/compatibility/browseHistory/" + jobSubmittedId + msgUpgrade;
        String subject = "OpenAIRE compatibility Test Results";
        try {
            this.emailer.sendMail(recipients, subject, message, false, null);
        }
        catch (Exception e) {
            logger.error((Object)("JOBID:" + jobSubmittedId + "# Error sending email for finished job"), (Throwable)e);
        }
    }

    public String getValBaseUrl() {
        return this.valBaseUrl;
    }

    public void setValBaseUrl(String valBaseUrl) {
        this.valBaseUrl = valBaseUrl;
    }

    public String getValidationSet() {
        return this.validationSet;
    }

    public void setValidationSet(String validationSet) {
        this.validationSet = validationSet;
    }

    public Emailer getEmailer() {
        return this.emailer;
    }

    public void setEmailer(Emailer emailer) {
        this.emailer = emailer;
    }

    public String getGuidelines() {
        return this.guidelines;
    }

    public void setGuidelines(String guidelines) {
        this.guidelines = guidelines;
    }
}

