/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.rules.xml;

import eu.dnetlib.validator.engine.data.DataException;
import eu.dnetlib.validator.engine.data.Provider;
import eu.dnetlib.validator.engine.data.RuleException;
import eu.dnetlib.validator.engine.execution.ValidationObject;
import eu.dnetlib.validator.service.impls.rules.VocabularyRule;
import eu.dnetlib.validator.service.impls.rules.xml.CrisRefClass;
import eu.dnetlib.validator.service.impls.rules.xml.XMLRule;
import eu.dnetlib.validator.service.impls.valobjs.XMLTextValidationObject;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class XMLCrisReferentialIntegrityRule
extends VocabularyRule
implements XMLRule {
    private static final long serialVersionUID = 6697956781771512326L;
    public static final String SCHEME_ID = "scheme_id";
    public static final String ENTITY_ACRONYM = "entity_acronym";
    public static final String RELATED_ENTITY_ACRONYM = "related_entity_acronym";
    public static final String RELATED_ENTITY_XPATH = "related_entity_xpath";

    public XMLCrisReferentialIntegrityRule(Properties pros, int id) {
        super(pros, id);
    }

    public boolean apply(ValidationObject obj) throws RuleException {
        NodeList nodes;
        String[] aterms = this.pros.getProperty("terms").split(",");
        XMLTextValidationObject tobj = (XMLTextValidationObject)obj;
        try {
            nodes = tobj.getNodes(this.pros.getProperty("xpath"));
        }
        catch (DataException e) {
            this.log.error((Object)"", (Throwable)e);
            return false;
        }
        this.log.debug((Object)("XML CRIS Class Vocabulary Rule. Class Nodes Found: " + nodes.getLength()));
        this.log.debug((Object)("XML CRIS Class Vocabulary Rule. Scheme_id to match: " + this.pros.getProperty(SCHEME_ID)));
        int success = 0;
        int all = nodes.getLength();
        boolean firstCheck = false;
        boolean secondCheck = false;
        for (int i = 0; i < nodes.getLength(); ++i) {
            firstCheck = true;
            secondCheck = true;
            try {
                CrisRefClass crisRefClass = this.getCrisRefClass(nodes.item(i), this.pros.getProperty(RELATED_ENTITY_ACRONYM));
                this.log.debug((Object)("XML CRIS Class Vocabulary Rule. Internal Node Class ID Value: " + crisRefClass.getClassId()));
                this.log.debug((Object)("XML CRIS Class Vocabulary Rule. Internal Node Class Related ID Value: " + crisRefClass.getRelClassId()));
                this.log.debug((Object)("XML CRIS Class Vocabulary Rule. Internal Node Class Scheme ID Value: " + crisRefClass.getClassSchemeId()));
                this.log.debug((Object)("XML CRIS Class Vocabulary Rule. Internal Node Class Related  full ID Value: " + crisRefClass.getRelClassFullId()));
                if (crisRefClass.getClassSchemeId().equalsIgnoreCase(this.pros.getProperty(SCHEME_ID))) {
                    Boolean termSuccess = false;
                    for (String term : aterms) {
                        if (!term.trim().equals(crisRefClass.getClassId().trim())) continue;
                        this.log.debug((Object)("XML CRIS Class Vocabulary Rule. Node: " + crisRefClass.getClassId().trim() + " matches with " + term));
                        ++success;
                        termSuccess = true;
                        break;
                    }
                    if (!termSuccess.booleanValue()) {
                        this.log.debug((Object)"Wrong Value ID");
                        this.getErrors().add("Wrong Value ID");
                        firstCheck = false;
                    }
                } else {
                    this.log.debug((Object)"Wrong Scheme ID");
                    this.getErrors().add("Wrong Scheme ID");
                    firstCheck = false;
                }
                secondCheck = this.checkRefIntegrity(crisRefClass, this.getErrors());
            }
            catch (DataException e) {
                this.log.error((Object)("error getting cris class" + (Object)((Object)e)));
            }
            this.log.debug((Object)("FirstCheck: " + firstCheck));
            this.log.debug((Object)("SecondCheck: " + secondCheck));
            if (!firstCheck || secondCheck) continue;
            --success;
        }
        String successConditions = this.pros.getProperty("success");
        return XMLRule.Utils.success((String)successConditions, (int)success, (int)all);
    }

    private Boolean checkRefIntegrity(CrisRefClass internalNode, List<String> errors) {
        try {
            NodeList nodes;
            String error = "";
            this.log.debug((Object)("Checking ref integrity with relClass: " + internalNode.getRelClassFullId()));
            ValidationObject relObj = this.getProvider().getValidationObject(internalNode.getRelClassFullId());
            XMLTextValidationObject tobj = (XMLTextValidationObject)relObj;
            try {
                nodes = tobj.getNodes(this.pros.getProperty(RELATED_ENTITY_XPATH));
            }
            catch (DataException e) {
                this.log.error((Object)"", (Throwable)e);
                return false;
            }
            this.log.debug((Object)("XML CRIS Class Vocabulary Rule. Related Class Nodes Found: " + nodes.getLength()));
            if (nodes.getLength() == 0) {
                error = "The referenced element doesn't exist";
                errors.add(error);
                return false;
            }
            int passed = 0;
            for (int i = 0; i < nodes.getLength(); ++i) {
                passed = 5;
                error = "none";
                try {
                    CrisRefClass crisRefClass = this.getCrisRefClass(nodes.item(i), this.pros.getProperty(ENTITY_ACRONYM));
                    this.log.debug((Object)("XML CRIS Class Vocabulary Rule. Related Node Class ID Value: " + crisRefClass.getClassId()));
                    this.log.debug((Object)("must match with: " + internalNode.getClassId()));
                    if (!crisRefClass.getClassId().equals(internalNode.getClassId())) {
                        error = "ClassId values do not match!";
                        errors.add(error);
                        this.log.debug((Object)("error: " + error));
                        --passed;
                    }
                    this.log.debug((Object)("XML CRIS Class Vocabulary Rule. Related Node Class Scheme ID Value: " + crisRefClass.getClassSchemeId()));
                    this.log.debug((Object)("must match with: " + internalNode.getClassSchemeId()));
                    if (!crisRefClass.getClassSchemeId().equals(internalNode.getClassSchemeId())) {
                        error = "ClassSchemeId values do not match!";
                        errors.add(error);
                        this.log.debug((Object)("error: " + error));
                        --passed;
                    }
                    this.log.debug((Object)("XML CRIS Class Vocabulary Rule. Related Node Class Related  full ID Value: " + crisRefClass.getRelClassFullId()));
                    this.log.debug((Object)("must match with: " + this.getValObjId()));
                    if (!crisRefClass.getRelClassFullId().equals(this.getValObjId())) {
                        error = "Related ID value does not match the record's one!";
                        errors.add(error);
                        this.log.debug((Object)("error: " + error));
                        --passed;
                    }
                    this.log.debug((Object)("XML CRIS Class Vocabulary Rule. Related Node Class Start Date: " + crisRefClass.getStartDate()));
                    this.log.debug((Object)("must match with: " + internalNode.getStartDate()));
                    if (!crisRefClass.getStartDate().equals(internalNode.getStartDate())) {
                        error = "Start Date values do not match!";
                        errors.add(error);
                        this.log.debug((Object)("error: " + error));
                        --passed;
                    }
                    this.log.debug((Object)("XML CRIS Class Vocabulary Rule. Related Node Class End Date: " + crisRefClass.getStartDate()));
                    this.log.debug((Object)("must match with: " + internalNode.getEndDate()));
                    if (!crisRefClass.getEndDate().equals(internalNode.getEndDate())) {
                        error = "End Date values do not match!";
                        errors.add(error);
                        this.log.debug((Object)("error: " + error));
                        --passed;
                    }
                }
                catch (DataException e) {
                    this.log.error((Object)("error getting cris class" + (Object)((Object)e)));
                }
                if (passed == 5) break;
            }
            if (passed != 5) {
                return false;
            }
        }
        catch (Provider.ProviderException e) {
            this.log.error((Object)("error getting record" + (Object)((Object)e)));
        }
        catch (UnsupportedOperationException e) {
            this.log.error((Object)("error getting record" + e));
        }
        return true;
    }

    private CrisRefClass getCrisRefClass(Node node, String entity_acronym) throws DataException {
        CrisRefClass retClass = new CrisRefClass();
        try {
            this.log.debug((Object)("XML CRIS Class Vocabulary Rule. ref Record ID: " + this.getValObjId().substring(0, this.getValObjId().indexOf(":cf") + 1).concat(entity_acronym.substring(0, entity_acronym.indexOf("Id")))));
            Document newXmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = newXmlDocument.createElement("root");
            newXmlDocument.appendChild(root);
            Node copyNode = newXmlDocument.importNode(node, true);
            root.appendChild(copyNode);
            this.printXmlDocument(newXmlDocument);
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            retClass.setRelClassId((String)xPath.evaluate("//" + entity_acronym + "/text()", newXmlDocument, XPathConstants.STRING));
            retClass.setClassId((String)xPath.evaluate("//cfClassId/text()", newXmlDocument, XPathConstants.STRING));
            retClass.setClassSchemeId((String)xPath.evaluate("//cfClassSchemeId/text()", newXmlDocument, XPathConstants.STRING));
            retClass.setStartDate((String)xPath.evaluate("//cfStartDate/text()", newXmlDocument, XPathConstants.STRING));
            retClass.setEndDate((String)xPath.evaluate("//cfEndDate/text()", newXmlDocument, XPathConstants.STRING));
            retClass.setRelClassFullId(this.getValObjId().substring(0, this.getValObjId().indexOf(":cf") + 1).concat(entity_acronym.substring(0, entity_acronym.indexOf("Id"))).concat("/").concat(retClass.getRelClassId()));
        }
        catch (ParserConfigurationException e) {
            this.log.error((Object)("error getting cris class" + e));
        }
        catch (XPathExpressionException e) {
            this.log.error((Object)("error getting cris class" + e));
        }
        return retClass;
    }

    private void printXmlDocument(Document document) {
        DOMImplementationLS domImplementationLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer lsSerializer = domImplementationLS.createLSSerializer();
        String string = lsSerializer.writeToString(document);
        this.log.debug((Object)string);
    }
}

