/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.providers;

import gr.uoa.di.driver.enabling.resultset.ResultSet;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;

public class DnetProviderHarvester
implements Runnable {
    private transient Logger log = Logger.getLogger(DnetProviderHarvester.class);
    private BlockingQueue<String> queue;
    private ResultSet<String> rs;
    private int beginRecord;
    private int endRecord;
    private int batchSize;
    private int workerId;
    private long elapsed;

    public DnetProviderHarvester(BlockingQueue<String> q, ResultSet<String> rs, int beginRecord, int endRecord, int batchSize, int workerId) {
        this.log.debug((Object)("Harvester for worker " + workerId + " created"));
        this.queue = q;
        this.rs = rs;
        this.beginRecord = beginRecord;
        this.endRecord = endRecord;
        this.batchSize = batchSize;
        this.workerId = workerId;
    }

    @Override
    public void run() {
        int recordsFetched = 0;
        this.log.debug((Object)("Harvester for worker " + this.workerId + " started"));
        long timeBegin = Calendar.getInstance().getTimeInMillis();
        for (int pointer = this.beginRecord; pointer <= this.endRecord; pointer += this.batchSize) {
            int to = pointer + this.batchSize - 1;
            if (pointer + this.batchSize - 1 < this.endRecord) {
                to = pointer + this.batchSize - 1;
            } else if (pointer <= this.endRecord) {
                to = this.endRecord;
            }
            this.log.error((Object)("to : " + to + " and limit: " + this.endRecord));
            this.log.error((Object)("PH" + this.workerId + "# Issuing request for records. From : " + pointer + " to : " + to));
            long time1 = Calendar.getInstance().getTimeInMillis();
            List tempRecords = this.rs.get(pointer, to);
            recordsFetched += tempRecords.size();
            long time2 = Calendar.getInstance().getTimeInMillis();
            try {
                for (String record : tempRecords) {
                    this.queue.put(record);
                }
            }
            catch (InterruptedException e) {
                this.log.error((Object)"Error fetching records", (Throwable)e);
            }
            this.log.debug((Object)("PH" + this.workerId + "#records fetching from is took " + (time2 - time1) + " milliseconds"));
            this.elapsed += time2 - time1;
            this.log.debug((Object)("PH" + this.workerId + "#Elapsed time till now for rules fetching is " + this.elapsed / 1000L + " seconds"));
        }
        long timeEnd = Calendar.getInstance().getTimeInMillis();
        try {
            this.queue.put("finished");
            this.log.debug((Object)("PH" + this.workerId + "# Fetching records finished."));
            this.log.debug((Object)("PH" + this.workerId + "# Records fetched: " + recordsFetched));
            this.log.debug((Object)("PH" + this.workerId + "# Total time in seconds: " + (timeEnd - timeBegin) / 1000L));
        }
        catch (InterruptedException e) {
            this.log.error((Object)("PH" + this.workerId + "# Error finalizing queue"), (Throwable)e);
        }
    }
}

