/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.listeners;

import eu.dnetlib.api.enabling.ResultSetService;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.functionality.validator.StoredJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardNotificationHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.utils.EPRUtils;
import eu.dnetlib.validator.engine.ValidatorException;
import eu.dnetlib.validator.engine.execution.CompletedTask;
import eu.dnetlib.validator.engine.execution.JobListener;
import eu.dnetlib.validator.service.impl.ValidatorManager;
import eu.dnetlib.validator.service.impls.listeners.RSTask;
import eu.dnetlib.validator.service.impls.listeners.RecordXMLBuilder;
import gr.uoa.di.driver.util.ServiceLocator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.springframework.core.task.TaskExecutor;

public class DnetListener
implements JobListener {
    private static Logger logger = Logger.getLogger(DnetListener.class);
    private final AtomicInteger activeThreads = new AtomicInteger(0);
    private Object allThreadsFinished = new Object();
    private RecordXMLBuilder xmlBuilder;
    private BlackboardJob job;
    private BlackboardNotificationHandler<BlackboardServerHandler> blackboardHandler;
    private TaskExecutor rsExecutor;
    private ServiceLocator<ResultSetService> resultSetServiceLocator = null;
    private ResultSetService resultSetService;
    private String outputResultSetID;
    private List<String> outputDiskBuffer;
    private EPR outputEpr;
    private int internalJobsFinished = 0;
    private int internalJobsSum = 1;
    private int objsValidated = 0;
    private int jobStatusUpdateInterval;
    private boolean enableOutputToRS = false;
    private boolean enableOutputToDisk = false;
    private BufferedWriter bw = null;
    private BlockingQueue<String> queue;
    private int validationJobId;
    private ValidatorManager validatorManager;
    private String groupBy;

    public void initOutputs() {
        logger.debug((Object)"initializing outputs");
        if (this.enableOutputToRS) {
            this.initEprOutput();
            this.job.getParameters().put("outputResultSetEpr", EPRUtils.eprToXml((EPR)this.outputEpr));
            logger.debug((Object)("output epr id successfully set: " + EPRUtils.eprToXml((EPR)this.outputEpr)));
        }
        if (this.enableOutputToDisk) {
            this.initDiskOutput();
            logger.debug((Object)"disk output ok");
        } else {
            logger.debug((Object)"initializing disk disabled");
        }
    }

    public synchronized void currentResults(List<CompletedTask> tasks, int jobId, Object record, Map<String, Object> recordContext, Throwable t) throws ValidatorException {
        try {
            ((BlackboardServerHandler)this.blackboardHandler.getBlackboardHandler()).failed(this.job, t);
        }
        catch (Exception e) {
            logger.error((Object)"Error while proccessing record results");
            throw new ValidatorException("Error while proccessing record results", (Throwable)e);
        }
    }

    public synchronized void currentResults(List<CompletedTask> tasks, int jobId, Object record, Map<String, Object> recordContext) throws ValidatorException {
        try {
            if (this.enableOutputToRS) {
                String xmlString = this.xmlBuilder.buildXml((List)recordContext.get("veloList"), record, (Map)recordContext.get("recordValidationResult"));
                this.sendToQueue(xmlString);
            }
            if (this.enableOutputToDisk && (Integer)recordContext.get("recordBlacklistScore") < 100) {
                this.bw.write(tasks.get((int)0).valobjId);
                this.bw.newLine();
            }
            ++this.objsValidated;
            if (this.objsValidated % this.jobStatusUpdateInterval == 0) {
                this.job.getParameters().put("recordsTested", Integer.toString(this.objsValidated));
                ((BlackboardServerHandler)this.blackboardHandler.getBlackboardHandler()).ongoing(this.job);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while proccessing record results");
            throw new ValidatorException("Error while proccessing record results", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finished(int jobId, Map<String, Object> jobContext) {
        block12: {
            try {
                logger.debug((Object)("Job " + jobId + " finished"));
                ++this.internalJobsFinished;
                if (this.internalJobsFinished == this.internalJobsSum) {
                    logger.debug((Object)"internalJobsFinished == internalJobsSum");
                    if (this.enableOutputToRS) {
                        try {
                            this.queue.put("finished");
                        }
                        catch (InterruptedException e) {
                            logger.error((Object)"Error finalizing queue", (Throwable)e);
                        }
                        if (this.queue.size() > 0) {
                            long time1 = Calendar.getInstance().getTimeInMillis();
                            this.activeThreads.getAndIncrement();
                            RSTask task = new RSTask(this.resultSetService, this.outputResultSetID, this.queue, this.activeThreads, this.allThreadsFinished);
                            this.rsExecutor.execute((Runnable)task);
                            long time2 = Calendar.getInstance().getTimeInMillis();
                            logger.debug((Object)("Populating RS took " + (time2 - time1) + " milli seconds"));
                        }
                        logger.debug((Object)("active threads to finish: " + this.activeThreads.get()));
                        logger.debug((Object)"trying to close result set");
                        while (this.activeThreads.get() > 0) {
                            logger.debug((Object)("waiting active threads to finish. Remaining: " + this.activeThreads.get()));
                            Object time1 = this.allThreadsFinished;
                            synchronized (time1) {
                                this.allThreadsFinished.wait();
                            }
                            logger.debug((Object)("retrying to finish. Remaining: " + this.activeThreads.get()));
                        }
                        logger.debug((Object)"closing result set");
                        this.resultSetService.closeRS(this.outputResultSetID);
                    }
                    if (this.enableOutputToDisk) {
                        this.bw.write("FINISHED");
                        this.bw.close();
                    }
                    this.job.getParameters().put("jobId", Integer.toString(this.validationJobId));
                    this.job.getParameters().put("recordsTested", Integer.toString(this.objsValidated));
                    logger.info((Object)"Getting stored job");
                    StoredJob storedJob = this.validatorManager.getStoredJob(jobId, this.groupBy);
                    logger.info((Object)("Score: " + storedJob.getContentJobScore()));
                    this.job.getParameters().put("score", storedJob.getContentJobScore() + "");
                    ((BlackboardServerHandler)this.blackboardHandler.getBlackboardHandler()).done(this.job);
                    break block12;
                }
                logger.debug((Object)("Waiting " + (this.internalJobsSum - this.internalJobsFinished) + " job(s) to finish"));
            }
            catch (Exception e) {
                logger.error((Object)"Error while finalizing successfull workflow job", (Throwable)e);
            }
        }
    }

    public synchronized void failed(int jobId, Map<String, Object> jobContext, Throwable t) {
        try {
            ++this.internalJobsFinished;
            if (this.internalJobsFinished == this.internalJobsSum) {
                if (this.enableOutputToRS) {
                    this.resultSetService.closeRS(this.outputResultSetID);
                }
                if (this.enableOutputToDisk) {
                    this.outputDiskBuffer.clear();
                    this.bw.close();
                    File file = new File("/tmp/validator-wf/" + this.validationJobId);
                    if (file.exists()) {
                        file.delete();
                    }
                }
                this.job.getParameters().put("jobId", Integer.toString(this.validationJobId));
                ((BlackboardServerHandler)this.blackboardHandler.getBlackboardHandler()).failed(this.job, t);
            } else {
                logger.debug((Object)("Waiting " + (this.internalJobsSum - this.internalJobsFinished) + " job(s) to finish"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while finalizing failed workflow job", (Throwable)e);
        }
    }

    private void sendToQueue(String xmlString) {
        logger.debug((Object)"received passed XMLresult");
        try {
            this.queue.put(xmlString);
        }
        catch (InterruptedException e1) {
            logger.error((Object)"Error putting in queue.", (Throwable)e1);
        }
        if (this.queue.size() > 50) {
            long time1 = Calendar.getInstance().getTimeInMillis();
            RSTask task = new RSTask(this.resultSetService, this.outputResultSetID, this.queue, this.activeThreads, this.allThreadsFinished);
            this.activeThreads.getAndIncrement();
            this.rsExecutor.execute((Runnable)task);
            long time2 = Calendar.getInstance().getTimeInMillis();
            logger.debug((Object)("Populating RS took " + (time2 - time1) + " milli seconds"));
        }
    }

    private void initEprOutput() {
        try {
            logger.debug((Object)"Initializing ResultSetService.");
            this.resultSetService = (ResultSetService)this.resultSetServiceLocator.getService();
            this.outputEpr = this.resultSetService.createPushRS(86400, 0);
            this.outputResultSetID = this.outputEpr.getParameter("ResourceIdentifier");
            this.queue = new LinkedBlockingQueue();
        }
        catch (Exception e) {
            logger.error((Object)"Error initializing ResultSetService.", (Throwable)e);
            ((BlackboardServerHandler)this.blackboardHandler.getBlackboardHandler()).failed(this.job, (Throwable)e);
        }
    }

    private void initDiskOutput() {
        try {
            logger.debug((Object)"Initializing FileOutputStream.");
            String datasourceId = this.job.getParameters().get("datasourceId") != null ? (String)this.job.getParameters().get("datasourceId") : (this.job.getParameters().get("datasourceID") != null ? (String)this.job.getParameters().get("datasourceID") : "unknownId");
            File file = new File("/var/lib/dnet/validator/workflow_blacklists/" + datasourceId);
            logger.debug((Object)("File: + /var/lib/dnet/validator/workflow_blacklists/" + datasourceId));
            if (file.exists()) {
                logger.debug((Object)"File will be replaced");
                file.delete();
            }
            file.createNewFile();
            this.bw = new BufferedWriter(new FileWriter(file.getAbsoluteFile()));
            this.outputDiskBuffer = new ArrayList();
        }
        catch (IOException e) {
            logger.error((Object)"Error initializing FileOutputStream.", (Throwable)e);
            ((BlackboardServerHandler)this.blackboardHandler.getBlackboardHandler()).failed(this.job, (Throwable)e);
        }
    }

    public RecordXMLBuilder getXmlBuilder() {
        return this.xmlBuilder;
    }

    public void setXmlBuilder(RecordXMLBuilder xmlBuilder) {
        this.xmlBuilder = xmlBuilder;
    }

    public BlackboardJob getJob() {
        return this.job;
    }

    public void setJob(BlackboardJob job) {
        this.job = job;
    }

    public ServiceLocator<ResultSetService> getResultSetServiceLocator() {
        return this.resultSetServiceLocator;
    }

    public void setResultSetServiceLocator(ServiceLocator<ResultSetService> resultSetServiceLocator) {
        this.resultSetServiceLocator = resultSetServiceLocator;
    }

    public BlackboardNotificationHandler<BlackboardServerHandler> getBlackboardHandler() {
        return this.blackboardHandler;
    }

    public void setBlackboardHandler(BlackboardNotificationHandler<BlackboardServerHandler> blackboardHandler) {
        this.blackboardHandler = blackboardHandler;
    }

    public TaskExecutor getRsExecutor() {
        return this.rsExecutor;
    }

    public void setRsExecutor(TaskExecutor rsExecutor) {
        this.rsExecutor = rsExecutor;
    }

    public int getInternalJobsSum() {
        return this.internalJobsSum;
    }

    public void setInternalJobsSum(int internalJobsSum) {
        this.internalJobsSum = internalJobsSum;
    }

    public int getValidationJobId() {
        return this.validationJobId;
    }

    public void setValidationJobId(int validationJobId) {
        this.validationJobId = validationJobId;
    }

    public int getJobStatusUpdateInterval() {
        return this.jobStatusUpdateInterval;
    }

    public void setJobStatusUpdateInterval(int jobStatusUpdateInterval) {
        this.jobStatusUpdateInterval = jobStatusUpdateInterval;
    }

    public boolean isEnableOutputToDisk() {
        return this.enableOutputToDisk;
    }

    public void setEnableOutputToDisk(boolean enableOutputToDisk) {
        this.enableOutputToDisk = enableOutputToDisk;
    }

    public boolean isEnableOutputToRS() {
        return this.enableOutputToRS;
    }

    public void setEnableOutputToRS(boolean enableOutputToRS) {
        this.enableOutputToRS = enableOutputToRS;
    }

    public ValidatorManager getValidatorManager() {
        return this.validatorManager;
    }

    public void setValidatorManager(ValidatorManager validatorManager) {
        this.validatorManager = validatorManager;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }
}

