/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.rules;

import eu.dnetlib.validator.engine.data.Rule;
import eu.dnetlib.validator.engine.data.RuleException;
import eu.dnetlib.validator.engine.execution.ValidationObject;
import java.util.List;
import java.util.Properties;

public class ChainRule<T extends Rule>
extends Rule {
    private static final long serialVersionUID = -6422953546341833949L;
    protected final List<T> rules;
    public static final String TYPE = "type";

    public ChainRule(Properties pros, int id, List<T> rules) {
        super(pros, id);
        this.rules = rules;
        this.log.debug((Object)("Chain Rule. Rules: " + rules));
    }

    public boolean apply(ValidationObject obj) throws RuleException {
        if (this.rules.size() == 0) {
            return true;
        }
        String condition = this.pros.getProperty(TYPE).trim();
        if (condition.equalsIgnoreCase("AND")) {
            for (Rule rule : this.rules) {
                if (rule.apply(obj)) continue;
                return false;
            }
            return true;
        }
        if (condition.equalsIgnoreCase("OR")) {
            for (Rule rule : this.rules) {
                if (!rule.apply(obj)) continue;
                return true;
            }
            return false;
        }
        if (condition.equalsIgnoreCase("HORN")) {
            if (!((Rule)this.rules.get(0)).apply(obj)) {
                return true;
            }
            for (int i = 1; i < this.rules.size(); ++i) {
                Rule rule = (Rule)this.rules.get(i);
                if (rule.apply(obj)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

