/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.sax.extension;

import crawlercommons.sitemaps.SiteMap;
import crawlercommons.sitemaps.SiteMapParser;
import crawlercommons.sitemaps.extension.Extension;
import crawlercommons.sitemaps.extension.ExtensionMetadata;
import crawlercommons.sitemaps.sax.extension.ImageHandler;
import crawlercommons.sitemaps.sax.extension.LinksHandler;
import crawlercommons.sitemaps.sax.extension.MobileHandler;
import crawlercommons.sitemaps.sax.extension.NewsHandler;
import crawlercommons.sitemaps.sax.extension.PageMapsHandler;
import crawlercommons.sitemaps.sax.extension.VideoHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.xml.sax.helpers.DefaultHandler;

public abstract class ExtensionHandler
extends DefaultHandler {
    protected static Pattern commaSeparated = Pattern.compile("\\s*,\\s*");
    protected List<ExtensionMetadata> attributes = new ArrayList<ExtensionMetadata>();

    public static ExtensionHandler create(Extension extension) {
        switch (extension) {
            case NEWS: {
                return new NewsHandler();
            }
            case VIDEO: {
                return new VideoHandler();
            }
            case IMAGE: {
                return new ImageHandler();
            }
            case LINKS: {
                return new LinksHandler();
            }
            case MOBILE: {
                return new MobileHandler();
            }
            case PAGEMAPS: {
                return new PageMapsHandler();
            }
        }
        return null;
    }

    public ExtensionMetadata[] getAttributes() {
        return this.attributes.toArray(new ExtensionMetadata[0]);
    }

    public void reset() {
        this.attributes.clear();
    }

    protected static ZonedDateTime getDateValue(String value) {
        return SiteMap.convertToZonedDateTime(value);
    }

    protected static URL getURLValue(String value) {
        if (value != null) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException e) {
                SiteMapParser.LOG.debug("Invalid URL value: {}", (Object)value);
            }
        }
        return null;
    }

    protected static Integer getIntegerValue(String value) {
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                SiteMapParser.LOG.debug("Invalid integer value: {}", (Object)value);
            }
        }
        return null;
    }

    protected static Float getFloatValue(String value) {
        if (value != null) {
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException e) {
                SiteMapParser.LOG.debug("Invalid float value: {}", (Object)value);
            }
        }
        return null;
    }

    protected static Boolean getYesNoBooleanValue(String value, String elemName) {
        if ("no".equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        if ("yes".equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        SiteMapParser.LOG.debug("Unexpected value for {} node: {}", (Object)elemName, (Object)value);
        return null;
    }
}

