/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.publications_retriever.util.url;

import eu.openaire.publications_retriever.util.args.ArgsUtils;
import eu.openaire.publications_retriever.util.url.LoaderAndChecker;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.Strings;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataForOutput {
    private String urlId;
    private String sourceUrl;
    private String pageUrl;
    private String docOrDatasetUrl;
    private String wasUrlChecked;
    private String wasUrlValid;
    private String wasDocumentOrDatasetAccessible;
    private String wasDirectLink;
    private String couldRetry;
    private String hash;
    private Long size;
    private String mimeType;
    private String filePath;
    private String error;
    private static final Logger logger = LoggerFactory.getLogger(DataForOutput.class);

    public DataForOutput(String urlId, String sourceUrl, String pageUrl, String docOrDatasetUrl, String wasUrlChecked, String wasUrlValid, String wasDocumentOrDatasetAccessible, String wasDirectLink, String couldRetry, String hash, Long size, String mimeType, String filePath, String error) {
        if (urlId == null) {
            urlId = "unretrievable";
        }
        this.urlId = urlId;
        this.sourceUrl = DataForOutput.escapeUrl(sourceUrl);
        this.pageUrl = DataForOutput.escapeUrl(pageUrl);
        this.docOrDatasetUrl = docOrDatasetUrl;
        this.wasUrlChecked = wasUrlChecked;
        this.wasUrlValid = wasUrlValid;
        this.wasDocumentOrDatasetAccessible = wasDocumentOrDatasetAccessible;
        this.wasDirectLink = wasDirectLink;
        this.couldRetry = couldRetry;
        this.hash = hash;
        this.size = size;
        this.mimeType = mimeType;
        this.filePath = filePath;
        this.error = error;
    }

    public static String escapeUrl(String url) {
        url = Strings.CS.replace(url, "\\", "\\\\", -1);
        return Strings.CS.replace(url, "\"", "\\\"", -1);
    }

    public String toJsonString() {
        JSONObject jsonObject = new JSONObject();
        try {
            Field changeMap = jsonObject.getClass().getDeclaredField("map");
            changeMap.setAccessible(true);
            changeMap.set(jsonObject, new LinkedHashMap());
            changeMap.setAccessible(false);
        }
        catch (Exception e) {
            logger.warn("Could not create an ordered JSONObject, so continuing with an unordered one. Exception msg: " + e.getMessage());
            jsonObject = new JSONObject();
        }
        try {
            if (LoaderAndChecker.useIdUrlPairs) {
                jsonObject.put("id", this.urlId);
            }
            jsonObject.put("sourceUrl", this.sourceUrl);
            jsonObject.put("pageUrl", this.pageUrl);
            jsonObject.put(ArgsUtils.targetUrlType, this.docOrDatasetUrl);
            jsonObject.put("wasUrlChecked", this.wasUrlChecked);
            jsonObject.put("wasUrlValid", this.wasUrlValid);
            jsonObject.put("wasDocumentOrDatasetAccessible", this.wasDocumentOrDatasetAccessible);
            jsonObject.put("wasDirectLink", this.wasDirectLink);
            jsonObject.put("couldRetry", this.couldRetry);
            jsonObject.put("fileHash", String.valueOf(this.hash));
            jsonObject.put("fileSize", String.valueOf(this.size));
            jsonObject.put("mimeType", this.mimeType);
            jsonObject.put("filePath", this.filePath);
            jsonObject.put("error", this.error);
        }
        catch (JSONException je) {
            jsonObject.put("comment", "There was a problem creating this JSON with the right values.");
            logger.warn("Invalid JsonOutput will be written as: " + jsonObject);
        }
        return jsonObject.toString();
    }

    public String getUrlId() {
        return this.urlId;
    }

    public void setUrlId(String urlId) {
        this.urlId = urlId;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public String getPageUrl() {
        return this.pageUrl;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public String getDocOrDatasetUrl() {
        return this.docOrDatasetUrl;
    }

    public void setDocOrDatasetUrl(String docOrDatasetUrl) {
        this.docOrDatasetUrl = docOrDatasetUrl;
    }

    public String getWasUrlChecked() {
        return this.wasUrlChecked;
    }

    public void setWasUrlChecked(String wasUrlChecked) {
        this.wasUrlChecked = wasUrlChecked;
    }

    public String getWasUrlValid() {
        return this.wasUrlValid;
    }

    public void setWasUrlValid(String wasUrlValid) {
        this.wasUrlValid = wasUrlValid;
    }

    public String getWasDocumentOrDatasetAccessible() {
        return this.wasDocumentOrDatasetAccessible;
    }

    public void setWasDocumentOrDatasetAccessible(String wasDocumentOrDatasetAccessible) {
        this.wasDocumentOrDatasetAccessible = wasDocumentOrDatasetAccessible;
    }

    public String getWasDirectLink() {
        return this.wasDirectLink;
    }

    public void setWasDirectLink(String wasDirectLink) {
        this.wasDirectLink = wasDirectLink;
    }

    public String getCouldRetry() {
        return this.couldRetry;
    }

    public void setCouldRetry(String couldRetry) {
        this.couldRetry = couldRetry;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }
}

