/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.publications_retriever.util.http;

import eu.openaire.publications_retriever.crawler.PageCrawler;
import eu.openaire.publications_retriever.crawler.SpecialUrlsHandler;
import eu.openaire.publications_retriever.exceptions.AlreadyFoundDocUrlException;
import eu.openaire.publications_retriever.exceptions.ConnTimeoutException;
import eu.openaire.publications_retriever.exceptions.DomainBlockedException;
import eu.openaire.publications_retriever.exceptions.DomainWithUnsupportedHEADmethodException;
import eu.openaire.publications_retriever.exceptions.FileNotRetrievedException;
import eu.openaire.publications_retriever.models.IdUrlMimeTypeTriple;
import eu.openaire.publications_retriever.util.args.ArgsUtils;
import eu.openaire.publications_retriever.util.http.ConnSupportUtils;
import eu.openaire.publications_retriever.util.url.LoaderAndChecker;
import eu.openaire.publications_retriever.util.url.UrlTypeChecker;
import eu.openaire.publications_retriever.util.url.UrlUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.ConnectException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpConnUtils.class);
    public static final Set<String> domainsWithUnsupportedHeadMethod = Collections.newSetFromMap(new ConcurrentHashMap());
    public static final Set<String> domainsWithUnsupportedAcceptLanguageParameter;
    public static final Set<String> blacklistedDomains;
    public static final ConcurrentHashMap<String, Integer> timesDomainsHadInputNotBeingDocNorPage;
    public static final ConcurrentHashMap<String, Integer> timesDomainsReturnedNoType;
    public static AtomicInteger numOfDomainsBlockedDueToSSLException;
    public static final int maxConnGETWaitingTime = 15000;
    public static final int maxConnHEADWaitingTime = 10000;
    private static final int maxRedirectsForPageUrls = 7;
    private static final int maxRedirectsForInternalLinks = 2;
    private static final int timesToHaveNoDocNorPageInputBeforeBlocked = 10;
    public static int maxAllowedContentSize;
    private static final boolean shouldNOTacceptGETmethodForUncategorizedInternalLinks = true;
    public static final Set<String> domainsSupportingHTTPS;
    public static final Set<String> domainsWithSlashRedirect;
    public static final Pattern ENDING_WITH_SLASH_OR_EXTENSION_FILTER;
    public static final Pattern PAGE_MIMETYPE_RULES;
    public static AtomicInteger timesDidOfflineHTTPSredirect;
    public static AtomicInteger timesDidOfflineSlashRedirect;
    public static ThreadLocal<Boolean> isSpecialUrl;
    public static final String docFileNotRetrievedMessage;
    public static final CookieManager cookieManager;

    /*
     * Unable to fully structure code
     */
    public static boolean connectAndCheckMimeType(String urlId, String sourceUrl, String pageUrl, String resourceURL, String domainStr, boolean calledForPageUrl, boolean calledForPossibleDocOrDatasetUrl) throws RuntimeException, ConnTimeoutException, DomainBlockedException, DomainWithUnsupportedHEADmethodException {
        conn = null;
        try {
            block40: {
                block41: {
                    block42: {
                        if (domainStr == null && (domainStr = UrlUtils.getDomainStr(resourceURL, null)) == null) {
                            throw new RuntimeException("Unable to obtain the domain!");
                        }
                        conn = HttpConnUtils.handleConnection(urlId, sourceUrl, pageUrl, resourceURL, domainStr, calledForPageUrl, calledForPossibleDocOrDatasetUrl);
                        finalUrlStr = conn.getURL().toString();
                        if (!finalUrlStr.contains(domainStr) && (domainStr = UrlUtils.getDomainStr(finalUrlStr, null)) == null) {
                            throw new RuntimeException("Unable to obtain the domain!");
                        }
                        foundDetectedContentType = false;
                        firstHtmlLine = null;
                        bufferedReader = null;
                        contentDisposition = null;
                        mimeType = conn.getContentType();
                        if (mimeType == null) {
                            contentDisposition = conn.getHeaderField("Content-Disposition");
                            if (contentDisposition == null) {
                                detectionList = ConnSupportUtils.detectContentTypeFromResponseBody(finalUrlStr, domainStr, conn, calledForPageUrl);
                                mimeType = (String)detectionList.get(0);
                                foundDetectedContentType = (Boolean)detectionList.get(1);
                                firstHtmlLine = (String)detectionList.get(2);
                                bufferedReader = (BufferedReader)detectionList.get(3);
                                calledForPossibleDocOrDatasetUrl = (Boolean)detectionList.get(4);
                            } else {
                                contentDisposition = contentDisposition.toLowerCase();
                            }
                        }
                        lowerCaseMimeType = mimeType;
                        if (mimeType != null && !foundDetectedContentType) {
                            lowerCaseMimeType = mimeType.toLowerCase();
                        }
                        if ((mimeTypeResult = ConnSupportUtils.hasDocOrDatasetMimeType(finalUrlStr, lowerCaseMimeType, contentDisposition, conn, calledForPageUrl, calledForPossibleDocOrDatasetUrl)) == null) break block40;
                        finalMimeType = mimeTypeResult.getMimeType();
                        category = mimeTypeResult.getCategory();
                        if (!ArgsUtils.retrieveDocuments || !category.equals("document")) break block41;
                        HttpConnUtils.logger.info("docUrl found: < " + finalUrlStr + " >");
                        error = "null";
                        fullPathFileName = category;
                        wasDirectLink = ConnSupportUtils.getWasDirectLink(sourceUrl, pageUrl, calledForPageUrl, finalUrlStr);
                        if (!ArgsUtils.shouldDownloadDocFiles) break block42;
                        try {
                            if (foundDetectedContentType) {
                                conn = HttpConnUtils.handleConnection(urlId, sourceUrl, pageUrl, finalUrlStr, domainStr, calledForPageUrl, calledForPossibleDocOrDatasetUrl);
                            }
                            fileData = ConnSupportUtils.downloadAndStoreDocFile(conn, urlId, domainStr, finalUrlStr);
                            fullPathFileName = fileData.getLocation();
                            HttpConnUtils.logger.info("DocFile: \"" + fullPathFileName + "\" has been downloaded.");
                            UrlUtils.addOutputData(urlId, sourceUrl, pageUrl, finalUrlStr, "null", fullPathFileName, null, true, "true", "true", "true", wasDirectLink, "true", fileData.getSize(), fileData.getHash(), finalMimeType);
                            var22_32 = true;
                            return var22_32;
                        }
                        catch (Exception e) {
                            error = HttpConnUtils.docFileNotRetrievedMessage + e.getMessage();
                            fullPathFileName = "null";
                            ** break block43
                        }
                    }
                    if (!ArgsUtils.shouldJustDownloadHtmlFiles) ** GOTO lbl-1000
                    fullPathFileName = "null";
lbl-1000:
                    // 3 sources

                    {
                        UrlUtils.addOutputData(urlId, sourceUrl, pageUrl, finalUrlStr, (String)error, fullPathFileName, null, true, "true", "true", "true", wasDirectLink, "true", null, "null", finalMimeType);
                        var22_34 = true;
                    }
                    return var22_34;
                }
                if (ArgsUtils.retrieveDatasets && category.equals("dataset")) {
                    HttpConnUtils.logger.info("datasetUrl found: < " + finalUrlStr + " >");
                    fullPathFileName = ArgsUtils.shouldDownloadDocFiles != false ? "It's a dataset-url. The download is not supported." : category;
                    wasDirectLink = ConnSupportUtils.getWasDirectLink(sourceUrl, pageUrl, calledForPageUrl, finalUrlStr);
                    UrlUtils.addOutputData(urlId, sourceUrl, pageUrl, finalUrlStr, "null", fullPathFileName, null, true, "true", "true", "true", wasDirectLink, "true", null, "null", finalMimeType);
                    var20_30 = true;
                    return var20_30;
                }
                if (calledForPageUrl) {
                    UrlUtils.addOutputData(urlId, sourceUrl, pageUrl, "unreachable", "It was discarded in 'HttpConnUtils.connectAndCheckMimeType()', after matching to an unwanted mimeType: " + finalMimeType, "null", null, true, "true", "true", "false", "false", "true", null, "null", finalMimeType);
                }
                var18_26 = false;
                return var18_26;
            }
            if (calledForPageUrl) {
                if (finalUrlStr.contains("viewcontent.cgi")) {
                    HttpConnUtils.logger.warn("Unwanted pageUrl: \"" + finalUrlStr + "\" will not be visited!");
                    UrlUtils.addOutputData(urlId, sourceUrl, pageUrl, "unreachable", "It was discarded in 'HttpConnUtils.connectAndCheckMimeType()', after matching to a non-" + ArgsUtils.targetUrlType + " with 'viewcontent.cgi'.", "null", null, true, "true", "true", "false", "false", "false", null, "null", "null");
                    UrlTypeChecker.pagesNotProvidingDocUrls.incrementAndGet();
                    var16_22 = false;
                    return var16_22;
                }
                if (lowerCaseMimeType != null && lowerCaseMimeType.length() <= 255 && HttpConnUtils.PAGE_MIMETYPE_RULES.matcher(lowerCaseMimeType).matches()) {
                    conn = ConnSupportUtils.checkForHEADConnectionAndReconnectIfNeededWithGET(conn, finalUrlStr, domainStr, true, false);
                    PageCrawler.visit(urlId, sourceUrl, finalUrlStr, mimeType, conn, firstHtmlLine, bufferedReader);
                } else {
                    HttpConnUtils.logger.warn("Non-pageUrl: \"" + finalUrlStr + "\" with mimeType: \"" + mimeType + "\" will not be visited!");
                    UrlUtils.addOutputData(urlId, sourceUrl, pageUrl, "unreachable", "It was discarded in 'HttpConnUtils.connectAndCheckMimeType()', after not matching to a " + ArgsUtils.targetUrlType + " nor to an htm/text-like page.", "null", null, true, "true", "true", "false", "false", "false", null, "null", "null");
                    if (ConnSupportUtils.countAndBlockDomainAfterTimes(HttpConnUtils.blacklistedDomains, HttpConnUtils.timesDomainsHadInputNotBeingDocNorPage, domainStr, 10, true)) {
                        HttpConnUtils.logger.warn("Domain: \"" + domainStr + "\" was blocked after having no Doc nor Pages in the input more than 10 times.");
                    }
                }
            }
        }
        catch (AlreadyFoundDocUrlException afdue) {
            var9_14 = true;
            return var9_14;
        }
        catch (RuntimeException re) {
            if (re instanceof NullPointerException) {
                HttpConnUtils.logger.error("", re);
            }
            if (calledForPageUrl) {
                LoaderAndChecker.connProblematicUrls.incrementAndGet();
                ConnSupportUtils.printEmbeddedExceptionMessage(re, resourceURL);
            } else if (calledForPossibleDocOrDatasetUrl) {
                ConnSupportUtils.printEmbeddedExceptionMessage(re, resourceURL);
            }
            throw re;
        }
        catch (ConnTimeoutException cte) {
            if (calledForPageUrl) {
                UrlTypeChecker.longToRespondUrls.incrementAndGet();
            }
            throw cte;
        }
        catch (DomainBlockedException | DomainWithUnsupportedHEADmethodException e) {
            if (calledForPageUrl) {
                LoaderAndChecker.connProblematicUrls.incrementAndGet();
            }
            throw e;
        }
        catch (Exception e) {
            if (calledForPageUrl) {
                HttpConnUtils.logger.warn("Could not handle connection for \"" + resourceURL + "\"!");
                LoaderAndChecker.connProblematicUrls.incrementAndGet();
            }
            throw new RuntimeException(e.getMessage());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return false;
    }

    public static HttpURLConnection handleConnection(String urlId, String sourceUrl, String pageUrl, String resourceURL, String domainStr, boolean calledForPageUrl, boolean calledForPossibleDocUrl) throws AlreadyFoundDocUrlException, RuntimeException, ConnTimeoutException, DomainBlockedException, DomainWithUnsupportedHEADmethodException, IOException {
        if (domainStr == null && (domainStr = UrlUtils.getDomainStr(resourceURL, null)) == null) {
            throw new RuntimeException("Unable to obtain the domain!");
        }
        HttpURLConnection conn = HttpConnUtils.openHttpConnection(resourceURL, domainStr, calledForPageUrl, calledForPossibleDocUrl);
        int responseCode = conn.getResponseCode();
        if (responseCode >= 300 && responseCode <= 399 && responseCode != 304) {
            conn = HttpConnUtils.handleRedirects(urlId, sourceUrl, pageUrl, resourceURL, conn, responseCode, domainStr, calledForPageUrl, calledForPossibleDocUrl);
        } else if (responseCode < 200 || responseCode >= 400) {
            String errorMessage = ConnSupportUtils.onErrorStatusCode(conn.getURL().toString(), domainStr, responseCode, calledForPageUrl, conn);
            throw new RuntimeException(errorMessage);
        }
        return conn;
    }

    public static HttpURLConnection openHttpConnection(String resourceURL, String domainStr, boolean calledForPageUrl, boolean calledForPossibleDocUrl) throws RuntimeException, ConnTimeoutException, DomainBlockedException, DomainWithUnsupportedHEADmethodException {
        HttpURLConnection conn = null;
        try {
            boolean useHttpGetMethod;
            String changedUrl;
            if (blacklistedDomains.contains(domainStr)) {
                throw new RuntimeException("Avoid connecting to blacklisted domain: \"" + domainStr + "\" with url: " + (String)resourceURL);
            }
            if (!calledForPageUrl && !calledForPossibleDocUrl && domainsWithUnsupportedHeadMethod.contains(domainStr)) {
                throw new DomainWithUnsupportedHEADmethodException();
            }
            if (ConnSupportUtils.checkIfPathIs403BlackListed((String)resourceURL, domainStr)) {
                throw new RuntimeException("Avoid reaching 403ErrorCode with url: \"" + (String)resourceURL + "\"!");
            }
            if (!((String)resourceURL).startsWith("https:", 0) && domainsSupportingHTTPS.contains(domainStr)) {
                resourceURL = Strings.CS.replace((String)resourceURL, "http:", "https:", 1);
                timesDidOfflineHTTPSredirect.incrementAndGet();
            }
            if (!ENDING_WITH_SLASH_OR_EXTENSION_FILTER.matcher((CharSequence)resourceURL).matches() && domainsWithSlashRedirect.contains(domainStr)) {
                resourceURL = (String)resourceURL + "/";
                timesDidOfflineSlashRedirect.incrementAndGet();
            }
            boolean weirdMetaDocUrlWhichNeedsGET = false;
            if (calledForPossibleDocUrl && ((String)resourceURL).contains("amp%3B")) {
                resourceURL = Strings.CS.replace((String)resourceURL, "amp%3B", "", -1);
                weirdMetaDocUrlWhichNeedsGET = true;
            }
            isSpecialUrl.set(false);
            if ((calledForPageUrl || calledForPossibleDocUrl) && !(changedUrl = SpecialUrlsHandler.checkAndHandleSpecialUrls((String)resourceURL)).equals(resourceURL)) {
                isSpecialUrl.set(true);
                resourceURL = changedUrl;
            }
            URL url = URI.create((String)resourceURL).toURL();
            conn = (HttpURLConnection)url.openConnection();
            ConnSupportUtils.setHttpHeaders(conn, domainStr);
            conn.setInstanceFollowRedirects(false);
            boolean bl = useHttpGetMethod = calledForPageUrl && !calledForPossibleDocUrl || calledForPossibleDocUrl && ArgsUtils.shouldDownloadDocFiles || weirdMetaDocUrlWhichNeedsGET || domainsWithUnsupportedHeadMethod.contains(domainStr) || domainStr.contains("meetingorganizer.copernicus.org");
            if (useHttpGetMethod) {
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(15000);
                conn.setReadTimeout(15000);
            } else {
                conn.setRequestMethod("HEAD");
                conn.setConnectTimeout(10000);
                conn.setReadTimeout(10000);
            }
            ConnSupportUtils.applyPolitenessDelay(domainStr);
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode == -1) {
                throw new RuntimeException("Invalid HTTP response for \"" + (String)resourceURL + "\"");
            }
            if (responseCode == 406) {
                logger.warn("The server \"" + domainStr + "\" probably does not support the \"Accept-Language\" parameter. Going to reconnect without it");
                domainsWithUnsupportedAcceptLanguageParameter.add(domainStr);
                conn = (HttpURLConnection)url.openConnection();
                ConnSupportUtils.setHttpHeaders(conn, domainStr);
                conn.setInstanceFollowRedirects(false);
                if (useHttpGetMethod) {
                    conn.setRequestMethod("GET");
                    conn.setConnectTimeout(15000);
                    conn.setReadTimeout(15000);
                } else {
                    conn.setRequestMethod("HEAD");
                    conn.setConnectTimeout(10000);
                    conn.setReadTimeout(10000);
                }
                ConnSupportUtils.applyPolitenessDelay(domainStr);
                conn.connect();
                if (conn.getResponseCode() == -1) {
                    throw new RuntimeException("Invalid HTTP response for \"" + (String)resourceURL + "\"");
                }
            } else if ((responseCode == 405 || responseCode == 501) && conn.getRequestMethod().equals("HEAD")) {
                domainsWithUnsupportedHeadMethod.add(domainStr);
                if (!calledForPageUrl && !calledForPossibleDocUrl) {
                    throw new DomainWithUnsupportedHEADmethodException();
                }
                conn = (HttpURLConnection)url.openConnection();
                ConnSupportUtils.setHttpHeaders(conn, domainStr);
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(15000);
                conn.setReadTimeout(15000);
                conn.setInstanceFollowRedirects(false);
                ConnSupportUtils.applyPolitenessDelay(domainStr);
                conn.connect();
                responseCode = conn.getResponseCode();
                if (responseCode == -1) {
                    throw new RuntimeException("Invalid HTTP response for \"" + (String)resourceURL + "\"");
                }
                if (responseCode == 406) {
                    logger.warn("The server \"" + domainStr + "\" probably does not support the \"Accept-Language\" parameter. Going to reconnect without it");
                    domainsWithUnsupportedAcceptLanguageParameter.add(domainStr);
                    conn = (HttpURLConnection)url.openConnection();
                    ConnSupportUtils.setHttpHeaders(conn, domainStr);
                    conn.setRequestMethod("GET");
                    conn.setConnectTimeout(15000);
                    conn.setReadTimeout(15000);
                    conn.setInstanceFollowRedirects(false);
                    ConnSupportUtils.applyPolitenessDelay(domainStr);
                    conn.connect();
                    if (conn.getResponseCode() == -1) {
                        throw new RuntimeException("Invalid HTTP response for \"" + (String)resourceURL + "\"");
                    }
                }
            }
        }
        catch (DomainWithUnsupportedHEADmethodException | RuntimeException redwuhme) {
            if (conn != null) {
                conn.disconnect();
            }
            throw redwuhme;
        }
        catch (Exception e) {
            if (conn != null) {
                conn.disconnect();
            }
            Exception exception = e;
            Objects.requireNonNull(exception);
            Exception exception2 = exception;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UnknownHostException.class, SocketTimeoutException.class, ConnectException.class, SSLException.class, SocketException.class}, (Exception)exception2, n)) {
                case 0: {
                    logger.warn("A new \"Unknown Network\" Host was found and blacklisted: \"" + domainStr + "\"");
                    blacklistedDomains.add(domainStr);
                    throw new DomainBlockedException(domainStr);
                }
                case 1: {
                    logger.warn("Url: \"" + (String)resourceURL + "\" failed to respond on time!");
                    ConnSupportUtils.onTimeoutException(domainStr);
                    throw new ConnTimeoutException();
                }
                case 2: {
                    String eMsg = e.getMessage();
                    if (eMsg != null && eMsg.toLowerCase().contains("timeout")) {
                        ConnSupportUtils.onTimeoutException(domainStr);
                        throw new ConnTimeoutException();
                    }
                    throw new RuntimeException(eMsg);
                }
                case 3: {
                    blacklistedDomains.add(domainStr);
                    numOfDomainsBlockedDueToSSLException.incrementAndGet();
                    logger.warn("No Secure connection was able to be negotiated with the domain: \"" + domainStr + "\", so it was blocked. Exception message: " + e.getMessage());
                    throw new DomainBlockedException(domainStr);
                }
                case 4: {
                    Object errorMsg = e.getMessage();
                    if (errorMsg != null) {
                        errorMsg = "\"" + (String)errorMsg + "\". This SocketException was received after trying to connect with the domain: \"" + domainStr + "\"";
                    }
                    throw new RuntimeException((String)errorMsg);
                }
            }
            logger.error("", e);
            throw new RuntimeException(e.getMessage());
        }
        return conn;
    }

    public static HttpURLConnection handleRedirects(String urlId, String sourceUrl, String pageUrl, String internalLink, HttpURLConnection conn, int responseCode, String domainStr, boolean calledForPageUrl, boolean calledForPossibleDocUrl) throws AlreadyFoundDocUrlException, RuntimeException, ConnTimeoutException, DomainBlockedException, DomainWithUnsupportedHEADmethodException {
        String urlType;
        String initialUrl;
        int curRedirectsNum = 0;
        int maxRedirects = 0;
        if (calledForPageUrl) {
            maxRedirects = 7;
            initialUrl = sourceUrl;
            urlType = "pageUrl";
        } else {
            maxRedirects = 2;
            initialUrl = internalLink;
            urlType = "internalLink";
        }
        try {
            String targetDomainStr;
            String currentUrl;
            do {
                String targetUrl;
                if (++curRedirectsNum > maxRedirects) {
                    throw new RuntimeException("Redirects exceeded their limit (" + maxRedirects + ") for " + urlType + ": \"" + initialUrl + "\"");
                }
                URL currentUrlObject = conn.getURL();
                currentUrl = currentUrlObject.toString();
                String location = conn.getHeaderField("Location");
                if (location == null) {
                    if (responseCode == 300) {
                        location = ConnSupportUtils.getInternalLinkFromHTTP300Page(currentUrl, conn);
                        if (location == null) {
                            throw new RuntimeException("No \"link\" was retrieved from the HTTP-300-page: \"" + currentUrl + "\".");
                        }
                    } else {
                        throw new RuntimeException("No \"Location\" field was found in the HTTP Header of \"" + currentUrl + "\", after receiving an \"HTTP " + responseCode + "\" Redirect Code.");
                    }
                }
                if ((targetUrl = ConnSupportUtils.getFullyFormedUrl(pageUrl, location, currentUrlObject)) == null) {
                    throw new RuntimeException("Could not create target url for resourceUrl: " + currentUrl + " having location: " + location);
                }
                String lowerCaseTargetUrl = targetUrl.toLowerCase();
                if (calledForPageUrl && UrlTypeChecker.shouldNotAcceptPageUrl(urlId, sourceUrl, targetUrl, lowerCaseTargetUrl, calledForPageUrl) || !calledForPageUrl && UrlTypeChecker.shouldNotAcceptInternalLink(targetUrl, lowerCaseTargetUrl)) {
                    throw new RuntimeException("Url: \"" + initialUrl + "\" was prevented to redirect to the unwanted location: \"" + targetUrl + "\", after receiving an \"HTTP " + responseCode + "\" Redirect Code, in redirection-number: " + curRedirectsNum + (calledForPageUrl ? " | __LOGGED__" : ""));
                }
                if (lowerCaseTargetUrl.contains("sharedsitesession")) {
                    logger.warn("Initial-url: \"" + initialUrl + "\" tried to cause a \"sharedSiteSession-redirectionPack\" by redirecting to \"" + targetUrl + "\"!");
                    List<String> blockedDomains = ConnSupportUtils.blockSharedSiteSessionDomains(targetUrl, currentUrl);
                    throw new DomainBlockedException(blockedDomains);
                }
                String tempTargetUrl = targetUrl;
                if ((targetUrl = LoaderAndChecker.basicURLNormalizer.filter(targetUrl)) == null) {
                    throw new RuntimeException("Could not normalize target url: " + tempTargetUrl);
                }
                IdUrlMimeTypeTriple originalIdUrlMimeTypeTriple = UrlUtils.resultUrlsWithIDs.get(targetUrl);
                if (originalIdUrlMimeTypeTriple != null) {
                    ConnSupportUtils.handleReCrossedTargetUrl(urlId, sourceUrl, pageUrl, targetUrl, originalIdUrlMimeTypeTriple, calledForPageUrl);
                    throw new AlreadyFoundDocUrlException();
                }
                targetDomainStr = UrlUtils.getDomainStr(targetUrl, null);
                if (targetDomainStr == null) {
                    throw new RuntimeException("Unable to obtain the domain!");
                }
                if (!targetDomainStr.contains(domainStr)) {
                    conn.disconnect();
                }
                if (ConnSupportUtils.isJustAnHTTPSredirect(currentUrl, targetUrl)) {
                    domainsSupportingHTTPS.add(targetDomainStr);
                }
                if (ConnSupportUtils.isJustASlashRedirect(currentUrl, targetUrl)) {
                    domainsWithSlashRedirect.add(targetDomainStr);
                }
                if (((responseCode = (conn = HttpConnUtils.openHttpConnection(targetUrl, targetDomainStr, calledForPageUrl, calledForPossibleDocUrl)).getResponseCode()) < 200 || responseCode > 299) && responseCode != 304) continue;
                return conn;
            } while (responseCode >= 300 && responseCode <= 399);
            String errorMessage = ConnSupportUtils.onErrorStatusCode(currentUrl, targetDomainStr, responseCode, calledForPageUrl, conn);
            throw new RuntimeException(errorMessage);
        }
        catch (AlreadyFoundDocUrlException | ConnTimeoutException | DomainBlockedException | DomainWithUnsupportedHEADmethodException | RuntimeException e) {
            conn.disconnect();
            throw e;
        }
        catch (Exception e) {
            logger.warn("", e);
            conn.disconnect();
            throw new RuntimeException(e.getMessage());
        }
    }

    static {
        domainsWithUnsupportedHeadMethod.add("os.zhdk.cloud.switch.ch");
        domainsWithUnsupportedAcceptLanguageParameter = Collections.newSetFromMap(new ConcurrentHashMap());
        blacklistedDomains = Collections.newSetFromMap(new ConcurrentHashMap());
        timesDomainsHadInputNotBeingDocNorPage = new ConcurrentHashMap();
        timesDomainsReturnedNoType = new ConcurrentHashMap();
        numOfDomainsBlockedDueToSSLException = new AtomicInteger(0);
        maxAllowedContentSize = 0x20000000;
        domainsSupportingHTTPS = Collections.newSetFromMap(new ConcurrentHashMap());
        domainsWithSlashRedirect = Collections.newSetFromMap(new ConcurrentHashMap());
        ENDING_WITH_SLASH_OR_EXTENSION_FILTER = Pattern.compile(".*(?:(?:/|\\.[^.?&/_-]{1,7})(?:\\?.+)?|\\?.+)$");
        PAGE_MIMETYPE_RULES = Pattern.compile(".*(?:htm|text(?!.*(?:xls[xbm]?|xlt[x]?|[ct]sv|tab|(?:(?:geo)?j|b)son|(?:x|k|g|nmr|sb|wiley|y[a]?)ml|xsd|o[dt]s|ddi|rdf|[g]?zip|zipx|[rt]ar|[7x]z|[t]?gz|[gb]z[\\d]*|smi[l]?|por|ascii|dta|sav|dat|txt|ti[f]{1,2}|tfw|dwg|nt|fits|feather|svg|sas7b(?:dat|ve)|spss|sas|stata|(?:my|postgre)?sql(?:ite)?|bigquery|sh[px]|sb[xn]|prj|dbf|(?:m|acc)db|mif|mat|pcd|bt|n[sc]?[\\d]*|h[\\d]+|hdf[\\d]*|trs|opj|jcamp|fcs|fas(?:ta)?|keys|values|las|rdata|parquet|avro|sql|dcm|gr[i]?b]|rds|[p]?cap|dmp|vcf|cbor|biosample|hic|warc|ig[e]?s|sla|dxf|pdb|[sc]df|cif|f(?:ast)?[qa]|apng|sra|vtp|gltf|[sm]tl|ply|abc|md|rtf|ttl|shp|shx|exr|cdf|glb|mtl|kmz|textFile))).*");
        timesDidOfflineHTTPSredirect = new AtomicInteger(0);
        timesDidOfflineSlashRedirect = new AtomicInteger(0);
        isSpecialUrl = new ThreadLocal();
        docFileNotRetrievedMessage = FileNotRetrievedException.class.getSimpleName() + " was thrown before the docFile could be stored. ";
        cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ORIGINAL_SERVER);
        CookieHandler.setDefault(cookieManager);
    }
}

