/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.sax.extension;

import crawlercommons.sitemaps.extension.ExtensionMetadata;
import crawlercommons.sitemaps.extension.ImageAttributes;
import crawlercommons.sitemaps.sax.extension.ExtensionHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ImageHandler
extends ExtensionHandler {
    private ImageAttributes currAttr;
    private StringBuilder currVal;

    public ImageHandler() {
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.resetCurrent();
    }

    private void resetCurrent() {
        this.currAttr = null;
        this.currVal = new StringBuilder();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("image".equals(localName)) {
            if (this.currAttr != null) {
                this.attributes.add(this.currAttr);
            }
            this.resetCurrent();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String value = this.currVal.toString().trim();
        if ("image".equals(localName)) {
            if (this.currAttr != null) {
                this.attributes.add(this.currAttr);
            }
            this.resetCurrent();
            return;
        }
        if (this.currAttr == null) {
            this.currAttr = new ImageAttributes();
        }
        if (!value.isEmpty()) {
            if ("loc".equals(localName)) {
                this.currAttr.setLoc(ImageHandler.getURLValue(value));
            } else if ("caption".equals(localName)) {
                this.currAttr.setCaption(value);
            } else if ("title".equals(localName)) {
                this.currAttr.setTitle(value);
            } else if ("geo_location".equals(localName)) {
                this.currAttr.setGeoLocation(value);
            } else if ("license".equals(localName)) {
                this.currAttr.setLicense(ImageHandler.getURLValue(value));
            }
        }
        this.currVal = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currVal.append(String.valueOf(ch, start, length));
    }

    @Override
    public ExtensionMetadata[] getAttributes() {
        if (this.currAttr != null) {
            this.attributes.add(this.currAttr);
        }
        return super.getAttributes();
    }
}

