/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.sax;

import crawlercommons.sitemaps.AbstractSiteMap;
import crawlercommons.sitemaps.SiteMap;
import crawlercommons.sitemaps.SiteMapIndex;
import crawlercommons.sitemaps.SiteMapParser;
import crawlercommons.sitemaps.sax.DelegatorHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XMLIndexHandler
extends DelegatorHandler {
    private SiteMapIndex sitemap;
    private String loc;
    private boolean locClosed;
    private Date lastMod;
    private int i = 0;

    XMLIndexHandler(URL url, LinkedList<String> elementStack, boolean strict) {
        super(elementStack, strict);
        this.sitemap = new SiteMapIndex(url);
        this.sitemap.setType(AbstractSiteMap.SitemapType.INDEX);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.loc != null && this.loc.length() > 0 && ("loc".equals(localName) || "sitemap".equals(localName))) {
            if (!XMLIndexHandler.isAllBlank(this.loc)) {
                this.maybeAddSiteMap();
                return;
            }
            this.loc = null;
            if ("sitemap".equals(localName)) {
                this.locClosed = false;
                this.lastMod = null;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.isStrictNamespace() && !this.isAcceptedNamespace(uri)) {
            return;
        }
        if ("sitemap".equals(localName)) {
            if (!this.locClosed) {
                this.loc = this.getAndResetCharacterBuffer();
            }
            this.maybeAddSiteMap();
        } else if ("sitemapindex".equals(localName)) {
            this.sitemap.setProcessed(true);
        } else if ("lastmod".equals(localName)) {
            String value = this.getAndResetCharacterBuffer();
            if (value != null) {
                this.lastMod = SiteMap.convertToDate(value);
            }
        } else if ("loc".equals(localName)) {
            this.loc = this.getAndResetCharacterBuffer();
            this.locClosed = true;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String value;
        String localName = super.currentElement();
        if ("loc".equals(localName) || "lastmod".equals(localName)) {
            this.appendCharacterBuffer(ch, start, length);
        } else if (!this.locClosed && !(value = XMLIndexHandler.stripAllBlank(String.valueOf(ch, start, length))).isEmpty()) {
            this.appendCharacterBuffer(value);
        }
    }

    @Override
    public AbstractSiteMap getSiteMap() {
        return this.sitemap;
    }

    private void maybeAddSiteMap() {
        if (this.loc == null) {
            return;
        }
        String value = XMLIndexHandler.stripAllBlank(this.loc);
        String urlFiltered = (String)this.urlFilter.apply(value);
        if (urlFiltered == null) {
            SiteMapParser.LOG.debug("Filtered URL {}", (Object)value);
            return;
        }
        try {
            URL locURL = new URL(urlFiltered);
            SiteMap s = new SiteMap(locURL, this.lastMod);
            this.sitemap.addSitemap(s);
            SiteMapParser.LOG.debug("  {}. {}", (Object)(this.i + 1), (Object)s);
        }
        catch (MalformedURLException e) {
            SiteMapParser.LOG.trace("Don't create an entry with a bad URL", e);
            SiteMapParser.LOG.debug("Bad url: [{}]", (Object)value);
        }
        this.loc = null;
        this.locClosed = false;
        this.lastMod = null;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.maybeAddSiteMap();
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.maybeAddSiteMap();
    }
}

