/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.publications_retriever.util.file;

import com.google.common.hash.Hashing;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileData {
    private static final Logger logger = LoggerFactory.getLogger(FileData.class);
    private File file;
    private String hash;
    private Long size;
    private String location;
    private FileOutputStream fileOutputStream;

    public FileData(File file, String hash, Long size, String location, FileOutputStream fileOutputStream) {
        this.file = file;
        this.hash = hash;
        this.size = size;
        this.location = location;
        this.fileOutputStream = fileOutputStream;
    }

    public FileData(File file, String hash, Long size, String location) {
        this.file = file;
        this.hash = hash;
        this.size = size;
        this.location = location;
    }

    public FileData(File file, String location, FileOutputStream fileOutputStream) {
        this.file = file;
        this.location = location;
        this.fileOutputStream = fileOutputStream;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public boolean calculateAndSetHashAndSize() {
        if (this.file == null) {
            logger.warn("The \"file\" was not previously set!");
            return false;
        }
        try {
            this.size = Files.size(Paths.get(this.location, new String[0]));
            if (this.size == 0L) {
                logger.warn("The file \"" + this.file.getName() + "\" was empty when calculating its size!");
                return false;
            }
            this.hash = com.google.common.io.Files.asByteSource(this.file).hash(Hashing.md5()).toString();
            return true;
        }
        catch (Exception e) {
            logger.error("Could not retrieve the size " + (this.hash == null ? "and the MD5-hash " : "") + "of the file: " + this.location, e);
            return false;
        }
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public FileOutputStream getFileOutputStream() {
        return this.fileOutputStream;
    }

    public void setFileOutputStream(FileOutputStream fileOutputStream) {
        this.fileOutputStream = fileOutputStream;
    }

    public String toString() {
        return "FileData{file=" + String.valueOf(this.file) + ", hash='" + this.hash + "', size=" + this.size + ", location='" + this.location + "', fileOutputStream=" + String.valueOf(this.fileOutputStream) + "}";
    }
}

