/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.publications_retriever.util.http;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import eu.openaire.publications_retriever.PublicationsRetriever;
import eu.openaire.publications_retriever.crawler.PageCrawler;
import eu.openaire.publications_retriever.exceptions.DocLinkFoundException;
import eu.openaire.publications_retriever.exceptions.DomainBlockedException;
import eu.openaire.publications_retriever.exceptions.FileNotRetrievedException;
import eu.openaire.publications_retriever.models.IdUrlMimeTypeTriple;
import eu.openaire.publications_retriever.models.MimeTypeResult;
import eu.openaire.publications_retriever.util.args.ArgsUtils;
import eu.openaire.publications_retriever.util.file.FileData;
import eu.openaire.publications_retriever.util.file.FileUtils;
import eu.openaire.publications_retriever.util.file.HtmlFileUtils;
import eu.openaire.publications_retriever.util.http.DetectedContentType;
import eu.openaire.publications_retriever.util.http.DomainConnectionData;
import eu.openaire.publications_retriever.util.http.HttpConnUtils;
import eu.openaire.publications_retriever.util.url.LoaderAndChecker;
import eu.openaire.publications_retriever.util.url.UrlUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.brotli.BrotliCompressorInputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.lang3.Strings;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnSupportUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConnSupportUtils.class);
    public static final Pattern MIME_TYPE_FILTER = Pattern.compile("(?:\\([']?)?([\\w]+/[\\w+.-]+).*");
    public static final Pattern POSSIBLE_DOC_OR_DATASET_MIME_TYPE = Pattern.compile("(?:(?:application|binary)/(?:(?:x-)?octet(?:-stream)?|save|force-download))|unknown");
    public static final Pattern DATASET_MIME_TYPE = Pattern.compile("(?:application|binary)/(?:xls[xbm]?|xlt[x]?|[ct]sv|tab|(?:(?:geo)?j|b)son|(?:x|k|g|nmr|sb|wiley|y[a]?)ml|xsd|o[dt]s|ddi|rdf|[g]?zip|zipx|[rt]ar|[7x]z|[t]?gz|[gb]z[\\d]*|smi[l]?|por|ascii|dta|sav|dat|txt|ti[f]{1,2}|tfw|dwg|nt|fits|feather|svg|sas7b(?:dat|ve)|spss|sas|stata|(?:my|postgre)?sql(?:ite)?|bigquery|sh[px]|sb[xn]|prj|dbf|(?:m|acc)db|mif|mat|pcd|bt|n[sc]?[\\d]*|h[\\d]+|hdf[\\d]*|trs|opj|jcamp|fcs|fas(?:ta)?|keys|values|las|rdata|parquet|avro|sql|dcm|gr[i]?b]|rds|[p]?cap|dmp|vcf|cbor|biosample|hic|warc|ig[e]?s|sla|dxf|pdb|[sc]df|cif|f(?:ast)?[qa]|apng|sra|vtp|gltf|[sm]tl|ply|abc|md|rtf|ttl|shp|shx|exr|cdf|glb|mtl|kmz|textFile)");
    public static final Pattern HTML_STRING_INDICATOR = Pattern.compile("^[\\s]*<(?:!doctype\\s)?html");
    public static final Pattern RESPONSE_BODY_UNWANTED_MATCH = Pattern.compile("^(?:[\\s]+|[\\s]*<(?:\\?xml|!--).*)");
    public static final Pattern SPACE_ONLY_LINE = Pattern.compile("^[\\s]+$");
    private static final Pattern NON_PROTOCOL_URL = Pattern.compile("^(?:[^:/]+://)(.*)");
    public static final int minPolitenessDelay = 3000;
    public static final int maxPolitenessDelay = 7000;
    public static final ConcurrentHashMap<String, Integer> timesDomainsReturned5XX = new ConcurrentHashMap();
    public static final ConcurrentHashMap<String, Integer> timesDomainsHadTimeoutEx = new ConcurrentHashMap();
    public static final ConcurrentHashMap<String, Integer> timesPathsReturned403 = new ConcurrentHashMap();
    public static final SetMultimap<String, String> domainsMultimapWithPaths403BlackListed = Multimaps.synchronizedSetMultimap(HashMultimap.create());
    private static final int timesToHave403errorCodeBeforePathBlocked = 10;
    private static final int numberOf403BlockedPathsBeforeDomainBlocked = 50;
    public static boolean shouldBlockMost5XXDomains = true;
    private static final int timesToHave5XXerrorCodeBeforeDomainBlocked = 10;
    private static final int timesToHaveTimeoutExBeforeDomainBlocked = 25;
    private static final int timesToReturnNoTypeBeforeDomainBlocked = 10;
    public static AtomicInteger reCrossedDocUrls = new AtomicInteger(0);
    public static final String alreadyDownloadedFromIDMessage = "This file is probably already downloaded by ID=";
    public static final String alreadyDownloadedFromSourceUrlContinuedMessage = " and SourceUrl=";
    public static final String alreadyDetectedFromIDMessage = "This url was already detected by ID=";
    public static final String alreadyDetectedFromSourceUrlContinuedMessage = " and SourceUrl=";
    public static final Set<String> knownDocMimeTypes = Collections.newSetFromMap(new ConcurrentHashMap());
    public static final Set<String> knownDatasetMimeTypes = Collections.newSetFromMap(new ConcurrentHashMap());
    public static final ConcurrentHashMap<String, DomainConnectionData> domainsWithConnectionData = new ConcurrentHashMap();
    public static String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0";
    public static String acceptLanguage = "en-US,en;q=0.5";
    private static final Pattern FILTER_COMMENT_FROM_MIMETYPE = Pattern.compile("([^/]+/[^/]+)(?:[\\s]*//.*)?");
    public static final ConcurrentHashMap<String, String> fileHashesWithLocations = new ConcurrentHashMap();
    public static final Set<String> domainsNotBlockableAfterTimes = Collections.newSetFromMap(new ConcurrentHashMap());
    public static ThreadLocal<StringBuilder> htmlStrBuilder;
    public static final AtomicLong numContentTypeExtractedFromPageContent;
    private static final int maxAllowedContentSizeMB;
    private static final ThreadLocalRandom threadLocalRandom;

    public static void setHttpHeaders(HttpURLConnection conn, String domainStr) {
        conn.setRequestProperty("User-Agent", userAgent);
        conn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8");
        conn.setRequestProperty("Accept-Encoding", "gzip, deflate, br, zstd");
        if (!HttpConnUtils.domainsWithUnsupportedAcceptLanguageParameter.contains(domainStr)) {
            conn.setRequestProperty("Accept-Language", acceptLanguage);
        }
        conn.setRequestProperty("DNT", "1");
        conn.setRequestProperty("Connection", "keep-alive");
        conn.setRequestProperty("Sec-Fetch-Dest", "document");
        conn.setRequestProperty("Sec-Fetch-Mode", "navigate");
        conn.setRequestProperty("Sec-Fetch-Site", "cross-site");
        conn.setRequestProperty("Upgrade-Insecure-Requests", "1");
        conn.setRequestProperty("Pragma", "no-cache");
        conn.setRequestProperty("Cache-Control", "no-cache");
        conn.setRequestProperty("Host", domainStr);
    }

    public static void setKnownMimeTypes() {
        if (ArgsUtils.retrieveDocuments) {
            ConnSupportUtils.setKnownDocMimeTypes();
            if (ArgsUtils.retrieveDatasets) {
                ConnSupportUtils.setKnownDatasetMimeTypes();
            }
        } else {
            ConnSupportUtils.setKnownDatasetMimeTypes();
        }
    }

    public static void setKnownDocMimeTypes() {
        logger.debug("Setting up the official document mime types. Currently there is support only for pdf documents.");
        knownDocMimeTypes.add("application/pdf");
        knownDocMimeTypes.add("application/x-pdf");
        knownDocMimeTypes.add("image/pdf");
        knownDocMimeTypes.add("image/x-pdf");
        knownDocMimeTypes.add("text/pdf");
        knownDocMimeTypes.add("text/x-pdf");
        knownDocMimeTypes.add("application/acrobat");
        knownDocMimeTypes.add("application/vnd.adobe.pdf");
        knownDocMimeTypes.add("application/vnd.adobe.portable-document-format");
        knownDocMimeTypes.add("application/vnd.pdf");
        knownDocMimeTypes.add("application/vnd.ms-pdf");
        knownDocMimeTypes.add("application/pdf-stream");
        knownDocMimeTypes.add("application/x-pdf-stream");
        if (!ArgsUtils.shouldDownloadDocFiles) {
            knownDocMimeTypes.add("application/postscript");
            knownDocMimeTypes.add("application/x-postscript");
            knownDocMimeTypes.add("application/vnd.cups-postscript");
            knownDocMimeTypes.add("application/eps");
            knownDocMimeTypes.add("application/ps");
            knownDocMimeTypes.add("application/x-ps");
            knownDocMimeTypes.add("application/x-postscript-not-eps");
            knownDocMimeTypes.add("text/postscript");
            knownDocMimeTypes.add("image/eps");
            knownDocMimeTypes.add("image/ps");
            knownDocMimeTypes.add("application/msword");
            knownDocMimeTypes.add("application/vnd.ms-word");
            knownDocMimeTypes.add("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            knownDocMimeTypes.add("application/vnd.openxmlformats-officedocument.presentationml.presentation");
            knownDocMimeTypes.add("application/vnd.openxmlformats-officedocument.spreadsheetml.template");
            knownDocMimeTypes.add("application/vnd.ms-powerpoint");
            knownDocMimeTypes.add("application/vnd.oasis.opendocument.presentation");
            knownDocMimeTypes.add("application/x-tex");
            knownDocMimeTypes.add("application/vnd.oasis.opendocument.text");
            knownDocMimeTypes.add("application/vnd.ms-xpsdocument");
            knownDocMimeTypes.add("application/epub+zip");
            knownDocMimeTypes.add("application/oxps");
            knownDocMimeTypes.add("application/rtf");
            knownDocMimeTypes.add("application/x-impress");
            knownDocMimeTypes.add("application/vnd.oasis.opendocument.formula");
            knownDocMimeTypes.add("application/vnd.oasis.opendocument.graphics");
            knownDocMimeTypes.add("application/vnd.oasis.opendocument.chart");
            knownDocMimeTypes.add("application/vnd.oasis.opendocument.image");
            knownDocMimeTypes.add("application/vnd.apple.pages");
            knownDocMimeTypes.add("application/vnd.apple.keynote");
            knownDocMimeTypes.add("application/vnd.wordperfect");
        }
    }

    public static void setKnownDatasetMimeTypes() {
        logger.debug("Setting up the official dataset mime-types.");
        String resourcePath = "dataset-mimetypes.txt";
        try (InputStream inputStream2 = ConnSupportUtils.class.getClassLoader().getResourceAsStream(resourcePath);){
            if (inputStream2 == null) {
                String errorMsg = "File not found in resources: " + resourcePath;
                logger.error(errorMsg);
                System.err.println(errorMsg);
                System.exit(77);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream2, StandardCharsets.UTF_8), 0x100000);){
                String line;
                while ((line = reader.readLine()) != null) {
                    Matcher matcher = FILTER_COMMENT_FROM_MIMETYPE.matcher(line);
                    if (matcher.matches()) {
                        String mimeType = matcher.group(1);
                        if (mimeType != null && !mimeType.isEmpty()) {
                            knownDatasetMimeTypes.add(mimeType.trim());
                            continue;
                        }
                        logger.error("Failed to extract the mimetype from line: " + line);
                        continue;
                    }
                    logger.error("Failed to match the line using the \"FILTER_COMMENT_FROM_MIMETYPE\"-regex: " + line);
                }
                if (logger.isTraceEnabled()) {
                    logger.trace(knownDatasetMimeTypes.toString());
                }
            }
        }
        catch (IOException ioe) {
            String errorMsg = "Could not read file:" + resourcePath;
            logger.error(errorMsg, ioe);
            System.err.println(errorMsg);
            System.exit(78);
        }
    }

    public static MimeTypeResult hasDocOrDatasetMimeType(String urlStr, String mimeType, String contentDisposition, HttpURLConnection conn, boolean calledForPageUrl, boolean calledForPossibleDocOrDatasetUrl) {
        MimeTypeResult mimeTypeResult = null;
        if (mimeType != null) {
            if (mimeType.contains("system.io.fileinfo")) {
                if (conn != null) {
                    contentDisposition = conn.getHeaderField("Content-Disposition");
                    if (contentDisposition != null) {
                        if (!(contentDisposition = contentDisposition.toLowerCase()).equals("attachment")) {
                            mimeTypeResult = contentDisposition.contains(".pdf") ? new MimeTypeResult("application/pdf", "document") : null;
                        }
                    } else {
                        mimeTypeResult = urlStr.toLowerCase().contains(".pdf") ? new MimeTypeResult("application/pdf", "document") : null;
                    }
                }
                return mimeTypeResult;
            }
            String plainMimeType = mimeType;
            if ((mimeType.contains("charset") || mimeType.contains("name") || mimeType.startsWith("(", 0)) && (plainMimeType = ConnSupportUtils.getPlainMimeType(mimeType)) == null) {
                logger.warn("Url with problematic mimeType (" + mimeType + ") was: " + urlStr);
                String lowerCaseUrl = urlStr.toLowerCase();
                if (lowerCaseUrl.contains("pdf")) {
                    mimeTypeResult = new MimeTypeResult("application/pdf", "document");
                } else if (LoaderAndChecker.DATASET_URL_FILTER.matcher(lowerCaseUrl).matches()) {
                    mimeTypeResult = new MimeTypeResult("unspecified", "dataset");
                }
                return mimeTypeResult;
            }
            plainMimeType = Strings.CS.replace(plainMimeType, "'", "", -1);
            plainMimeType = Strings.CS.replace(plainMimeType, "\"", "", -1);
            if (ArgsUtils.retrieveDocuments && knownDocMimeTypes.contains(plainMimeType)) {
                mimeTypeResult = new MimeTypeResult(plainMimeType, "document");
            } else if (ArgsUtils.retrieveDatasets && (knownDatasetMimeTypes.contains(plainMimeType) || DATASET_MIME_TYPE.matcher(plainMimeType).matches())) {
                mimeTypeResult = new MimeTypeResult(plainMimeType, "dataset");
            } else if (POSSIBLE_DOC_OR_DATASET_MIME_TYPE.matcher(plainMimeType).matches()) {
                contentDisposition = conn.getHeaderField("Content-Disposition");
                if (contentDisposition != null && !(contentDisposition = contentDisposition.toLowerCase()).equals("attachment")) {
                    if (ArgsUtils.retrieveDocuments && contentDisposition.contains(".pdf")) {
                        mimeTypeResult = new MimeTypeResult("application/pdf", "document");
                    } else {
                        String clearContentDisposition = Strings.CS.replace(contentDisposition, "\"", "", -1);
                        clearContentDisposition = Strings.CS.replace(clearContentDisposition, "'", "", -1);
                        if (ArgsUtils.retrieveDatasets && LoaderAndChecker.DATASET_URL_FILTER.matcher(clearContentDisposition).matches()) {
                            mimeTypeResult = new MimeTypeResult(plainMimeType, "dataset");
                        }
                    }
                    return mimeTypeResult;
                }
                String lowerCaseUrl = urlStr.toLowerCase();
                if (ArgsUtils.retrieveDocuments && lowerCaseUrl.contains("pdf")) {
                    mimeTypeResult = new MimeTypeResult("application/pdf", "document");
                } else if (ArgsUtils.retrieveDatasets && LoaderAndChecker.DATASET_URL_FILTER.matcher(lowerCaseUrl).matches()) {
                    mimeTypeResult = new MimeTypeResult(plainMimeType, "dataset");
                }
            } else if (conn != null && (contentDisposition = conn.getHeaderField("Content-Disposition")) != null) {
                if (ArgsUtils.retrieveDocuments && contentDisposition.toLowerCase().contains(".pdf")) {
                    mimeTypeResult = new MimeTypeResult("application/pdf", "document");
                }
                String clearContentDisposition = Strings.CS.replace(contentDisposition, "\"", "", -1);
                clearContentDisposition = Strings.CS.replace(clearContentDisposition, "'", "", -1);
                if (ArgsUtils.retrieveDatasets && LoaderAndChecker.DATASET_URL_FILTER.matcher(clearContentDisposition).matches()) {
                    mimeTypeResult = new MimeTypeResult(plainMimeType, "dataset");
                }
            }
            return mimeTypeResult;
        }
        if (contentDisposition != null && !contentDisposition.equals("attachment")) {
            if (ArgsUtils.retrieveDocuments && contentDisposition.contains(".pdf")) {
                mimeTypeResult = new MimeTypeResult("application/pdf", "document");
            } else {
                String clearContentDisposition = Strings.CS.replace(contentDisposition, "\"", "", -1);
                clearContentDisposition = Strings.CS.replace(clearContentDisposition, "'", "", -1);
                if (ArgsUtils.retrieveDatasets && LoaderAndChecker.DATASET_URL_FILTER.matcher(clearContentDisposition).matches()) {
                    mimeTypeResult = new MimeTypeResult("unspecified", "dataset");
                }
            }
            return mimeTypeResult;
        }
        if (calledForPageUrl || calledForPossibleDocOrDatasetUrl) {
            logger.warn("No mimeType, nor Content-Disposition, were able to be retrieved for url: " + urlStr);
        }
        return null;
    }

    public static void handleReCrossedTargetUrl(String urlId, String sourceUrl, String pageUrl, String docUrl, IdUrlMimeTypeTriple originalIdUrlMimeTypeTriple, boolean calledForPageUrl) {
        logger.info("re-crossed targetUrl found: < " + docUrl + " >");
        reCrossedDocUrls.incrementAndGet();
        String wasDirectLink = ConnSupportUtils.getWasDirectLink(sourceUrl, pageUrl, calledForPageUrl, docUrl);
        String filePath = (ArgsUtils.shouldDownloadDocFiles || ArgsUtils.shouldJustDownloadHtmlFiles ? alreadyDownloadedFromIDMessage + originalIdUrlMimeTypeTriple.id + " and SourceUrl=" : alreadyDetectedFromIDMessage + originalIdUrlMimeTypeTriple.id + " and SourceUrl=") + originalIdUrlMimeTypeTriple.url;
        UrlUtils.addOutputData(urlId, sourceUrl, pageUrl, docUrl, "null", filePath, null, false, "true", "true", "true", wasDirectLink, "true", null, "null", originalIdUrlMimeTypeTriple.mimeType);
    }

    public static String getPlainMimeType(String mimeType) {
        String plainMimeType;
        if (mimeType == null) {
            logger.warn("A null mimeType was given to \"getPlainMimeType()\".");
            return null;
        }
        if (mimeType.length() > 255) {
            logger.warn("A suspiciously large mimeType was given to \"getPlainMimeType()\", having length: " + mimeType.length());
            return null;
        }
        Matcher mimeMatcher = MIME_TYPE_FILTER.matcher(mimeType);
        if (mimeMatcher.matches()) {
            try {
                plainMimeType = mimeMatcher.group(1);
            }
            catch (Exception e) {
                logger.error("", e);
                return null;
            }
            if (plainMimeType == null || plainMimeType.isEmpty()) {
                logger.warn("Unexpected null or empty value returned by \"mimeMatcher.group(1)\" for mimeType: \"" + mimeType + "\".");
                return null;
            }
        } else {
            logger.warn("Unexpected MIME_TYPE_FILTER's (" + String.valueOf(mimeMatcher) + ") mismatch for mimeType: \"" + mimeType + "\"");
            return null;
        }
        return plainMimeType;
    }

    public static FileData checkAndHandleDuplicateHash(FileData fileData, String url) {
        String fileHash = fileData.getHash();
        String alreadyDownloadedFileLocation = fileHashesWithLocations.get(fileHash);
        if (alreadyDownloadedFileLocation != null) {
            logger.debug("The file of url \"" + url + "\" has been already downloaded in location: " + alreadyDownloadedFileLocation);
            File file = fileData.getFile();
            try {
                if (file.exists()) {
                    try {
                        FileDeleteStrategy.FORCE.delete(file);
                    }
                    catch (Exception e) {
                        logger.error("Error when deleting the duplicate file from url: " + url, e);
                    }
                }
            }
            catch (Exception e1) {
                logger.error("Error when checking if the duplicate file exists, from url: " + url, e1);
            }
            if (ArgsUtils.shouldDownloadDocFiles) {
                if (ArgsUtils.fileNameType.equals((Object)ArgsUtils.fileNameTypeEnum.numberName)) {
                    --FileUtils.numOfDocFile;
                } else {
                    FileUtils.numOfDocFiles.decrementAndGet();
                }
            } else if (ArgsUtils.fileNameType.equals((Object)ArgsUtils.fileNameTypeEnum.numberName)) {
                HtmlFileUtils.htmlFilesNum.decrementAndGet();
            }
            fileData.setLocation(alreadyDownloadedFileLocation);
            fileData.setFile(new File(alreadyDownloadedFileLocation));
            return fileData;
        }
        fileHashesWithLocations.put(fileData.getHash(), fileData.getLocation());
        return null;
    }

    public static HttpURLConnection checkForHEADConnectionAndReconnectIfNeededWithGET(HttpURLConnection conn, String url, String domainStr, boolean calledForPageUrl, boolean calledForPossibleDocUrl) throws Exception {
        int responseCode;
        if (conn.getRequestMethod().equals("HEAD") && (responseCode = (conn = HttpConnUtils.openHttpConnection(url, domainStr, calledForPageUrl, calledForPossibleDocUrl)).getResponseCode()) != 200) {
            String errorMessage = ConnSupportUtils.onErrorStatusCode(conn.getURL().toString(), domainStr, responseCode, calledForPageUrl, conn);
            throw new RuntimeException(errorMessage);
        }
        return conn;
    }

    public static FileData downloadAndStoreDocFile(HttpURLConnection conn, String id, String domainStr, String docUrl) throws FileNotRetrievedException {
        boolean reconnected = false;
        try {
            HttpURLConnection newConn = ConnSupportUtils.checkForHEADConnectionAndReconnectIfNeededWithGET(conn, docUrl, domainStr, false, true);
            if (!newConn.equals(conn)) {
                reconnected = true;
                conn = newConn;
            }
            int contentSize = 0;
            contentSize = ConnSupportUtils.getContentSize(conn, true, false);
            if (contentSize == -1) {
                throw new FileNotRetrievedException("The HTTP-reported size of this file was unacceptable!");
            }
            FileData fileData = null;
            fileData = ArgsUtils.fileNameType.equals((Object)ArgsUtils.fileNameTypeEnum.numberName) ? FileUtils.storeDocFileWithNumberName(conn, docUrl, contentSize) : FileUtils.storeDocFileWithIdOrOriginalFileName(conn, docUrl, id, contentSize);
            if (fileData == null) {
                String errMsg = "The file could not be " + (ArgsUtils.shouldUploadFilesToS3 ? "uploaded to S3" : "downloaded") + " from the docUrl " + docUrl;
                logger.warn(errMsg);
                throw new FileNotRetrievedException(errMsg);
            }
            FileData newFileData = ConnSupportUtils.checkAndHandleDuplicateHash(fileData, docUrl);
            if (newFileData != null) {
                FileData fileData2 = newFileData;
                return fileData2;
            }
            File docFile = fileData.getFile();
            if (ArgsUtils.shouldUploadFilesToS3) {
                try {
                    FileDeleteStrategy.FORCE.delete(docFile);
                }
                catch (Exception e) {
                    logger.warn("The file \"" + docFile.getName() + "\" could not be deleted after being uploaded to S3 ObjectStore!");
                }
            }
            FileData fileData3 = fileData;
            return fileData3;
        }
        catch (FileNotRetrievedException dfnre) {
            throw dfnre;
        }
        catch (Exception e) {
            logger.error("", e);
            throw new FileNotRetrievedException(e.getMessage());
        }
        finally {
            if (reconnected) {
                conn.disconnect();
            }
        }
    }

    public static void applyPolitenessDelay(String domainStr) {
        long elapsedTimeSinceLastConnection;
        DomainConnectionData domainConnectionData = domainsWithConnectionData.putIfAbsent(UrlUtils.getTopThreeLevelDomain(domainStr), new DomainConnectionData());
        if (domainConnectionData == null) {
            return;
        }
        domainConnectionData.lock.lock();
        Instant currentTime = Instant.now();
        try {
            elapsedTimeSinceLastConnection = Duration.between(domainConnectionData.lastTimeConnected, currentTime).toMillis();
        }
        catch (Exception e) {
            logger.warn("An exception was thrown when tried to obtain the time elapsed from the last time the domain connected: " + e.getMessage());
            domainConnectionData.updateAndUnlock(currentTime);
            return;
        }
        if (elapsedTimeSinceLastConnection < 3000L) {
            block10: {
                long finalPolitenessDelay = ConnSupportUtils.getRandomNumber(3000, 7000) - elapsedTimeSinceLastConnection;
                try {
                    Thread.sleep(finalPolitenessDelay);
                }
                catch (InterruptedException ie) {
                    Instant newCurrentTime = Instant.now();
                    try {
                        elapsedTimeSinceLastConnection = Duration.between(currentTime, newCurrentTime).toMillis();
                    }
                    catch (Exception e) {
                        logger.warn("An exception was thrown when tried to obtain the time elapsed from the last time the \"currentTime\" was updated: " + e.getMessage());
                        domainConnectionData.updateAndUnlock(newCurrentTime);
                        return;
                    }
                    if (elapsedTimeSinceLastConnection >= 3000L) break block10;
                    finalPolitenessDelay -= elapsedTimeSinceLastConnection;
                    try {
                        Thread.sleep(finalPolitenessDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            currentTime = Instant.now();
        }
        domainConnectionData.updateAndUnlock(currentTime);
    }

    public static String getInternalLinkFromHTTP300Page(String url, HttpURLConnection conn) {
        try {
            String html = ConnSupportUtils.getHtmlString(conn, url, null, false, null);
            if (html == null) {
                logger.warn("Could not retrieve the HTML-code for HTTP300PageUrl: " + url);
                return null;
            }
            HashMap<String, String> extractedLinksWithStructure = PageCrawler.extractInternalLinksFromHtml(html, url);
            if (extractedLinksWithStructure == null || extractedLinksWithStructure.isEmpty()) {
                return null;
            }
            return new ArrayList<String>(extractedLinksWithStructure.keySet()).getFirst();
        }
        catch (DocLinkFoundException dlfe) {
            return dlfe.getMessage();
        }
        catch (Exception e) {
            logger.error("", e);
            return null;
        }
    }

    public static String onErrorStatusCode(String urlStr, String domainStr, int errorStatusCode, boolean calledForPageUrl, HttpURLConnection conn) throws DomainBlockedException {
        String errorLogMessage;
        if (errorStatusCode == 500 && domainStr.contains("handle.net")) {
            errorStatusCode = 404;
        }
        if (errorStatusCode >= 400 && errorStatusCode <= 499) {
            String retryAfterTime;
            String errorText;
            errorLogMessage = "Url: \"" + urlStr + "\" seems to be unreachable. Received: HTTP " + errorStatusCode + " Client Error.";
            if (calledForPageUrl && errorStatusCode != 404 && errorStatusCode != 410 && (errorText = ConnSupportUtils.getErrorMessageFromResponseBody(conn, urlStr)) != null) {
                if (domainStr.contains("doi.org") && errorText.contains("Not a DOI")) {
                    logger.warn("Found a \"doi.org\" url with an invalid DOI: " + urlStr);
                }
                errorLogMessage = errorLogMessage + " Error-text: " + errorText;
            }
            if (errorStatusCode == 403) {
                ConnSupportUtils.on403ErrorCode(urlStr, domainStr, calledForPageUrl);
            } else if (errorStatusCode == 429 && (retryAfterTime = conn.getHeaderField("Retry-After")) != null) {
                errorLogMessage = errorLogMessage + " | Retry-After:" + retryAfterTime;
            }
        } else {
            if (domainStr == null || !urlStr.contains(domainStr)) {
                domainStr = UrlUtils.getDomainStr(urlStr, null);
            }
            if (errorStatusCode >= 500 && errorStatusCode <= 599) {
                errorLogMessage = "Url: \"" + urlStr + "\" seems to be unreachable. Received: HTTP " + errorStatusCode + " Server Error.";
                ConnSupportUtils.on5XXerrorCode(errorStatusCode, domainStr);
            } else {
                String errorText;
                errorLogMessage = "Url: \"" + urlStr + "\" seems to be unreachable. Received unexpected responseCode: " + errorStatusCode;
                if (calledForPageUrl && (errorText = ConnSupportUtils.getErrorMessageFromResponseBody(conn, urlStr)) != null) {
                    errorLogMessage = errorLogMessage + " Error-text: " + errorText;
                }
                logger.warn(errorLogMessage);
                if (domainStr != null) {
                    HttpConnUtils.blacklistedDomains.add(domainStr);
                    logger.warn("Domain: \"" + domainStr + "\" was blocked, after giving a " + errorStatusCode + " HTTP-status-code.");
                    throw new DomainBlockedException(domainStr);
                }
            }
        }
        return errorLogMessage;
    }

    public static InputStream checkEncodingAndGetInputStream(HttpURLConnection conn, boolean isForError) {
        InputStream inputStream2 = null;
        try {
            InputStream inputStream3 = inputStream2 = isForError ? conn.getErrorStream() : conn.getInputStream();
            if (isForError && inputStream2 == null) {
                logger.warn("The \"getErrorStream\" did not return a stream!");
                return null;
            }
        }
        catch (Exception e) {
            logger.error("Error when acquiring the " + (isForError ? "Error" : "") + "InputStream!", e);
            return null;
        }
        String encoding = conn.getHeaderField("content-encoding");
        if (encoding != null) {
            String url = conn.getURL().toString();
            InputStream compressedInputStream = ConnSupportUtils.getCompressedInputStream(inputStream2, encoding, url);
            if (compressedInputStream == null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            inputStream2 = compressedInputStream;
        }
        return inputStream2;
    }

    public static InputStream getCompressedInputStream(InputStream inputStream2, String encoding, String url) {
        CompressorInputStream compressedInputStream;
        try {
            switch (encoding.toLowerCase()) {
                case "gzip": {
                    compressedInputStream = new GzipCompressorInputStream(inputStream2);
                    break;
                }
                case "deflate": {
                    compressedInputStream = new DeflateCompressorInputStream(inputStream2);
                    break;
                }
                case "br": {
                    compressedInputStream = new BrotliCompressorInputStream(inputStream2);
                    break;
                }
                case "zstd": {
                    compressedInputStream = new ZstdCompressorInputStream(inputStream2);
                    break;
                }
                default: {
                    logger.warn("An unsupported \"content-encoding\" (" + encoding + ") was received from url: " + url);
                    return null;
                }
            }
        }
        catch (IOException ioe) {
            String exMsg = ioe.getMessage();
            if (exMsg.startsWith("Input is not in the")) {
                logger.warn(exMsg + " | http-published-encoding: " + encoding + " | url: " + url);
            } else {
                logger.error("Could not acquire the compressorInputStream for encoding: " + encoding + " | url: " + url, ioe);
            }
            return null;
        }
        return compressedInputStream;
    }

    public static String getErrorMessageFromResponseBody(HttpURLConnection conn, String url) {
        String html = ConnSupportUtils.getHtmlString(conn, url, null, true, null);
        if (html == null || html.length() > 10000) {
            return null;
        }
        String errorText = Jsoup.parse(html).text();
        return errorText.length() > 0 ? errorText : null;
    }

    public static void on403ErrorCode(String urlStr, String domainStr, boolean calledForPageUrl) throws DomainBlockedException {
        String pathStr;
        Matcher matcher = null;
        if (domainStr == null || !urlStr.contains(domainStr)) {
            matcher = UrlUtils.getUrlMatcher(urlStr);
            if (matcher == null) {
                return;
            }
            domainStr = UrlUtils.getDomainStr(urlStr, matcher);
            if (domainStr == null) {
                return;
            }
        }
        if ((pathStr = UrlUtils.getPathStr(urlStr, matcher)) == null) {
            return;
        }
        if (ConnSupportUtils.countAndBlockPathAfterTimes(domainsMultimapWithPaths403BlackListed, timesPathsReturned403, pathStr, domainStr, 10, calledForPageUrl)) {
            logger.warn("Path: \"" + pathStr + "\" of domain: \"" + domainStr + "\" was blocked after returning 403 Error Code more than 10 times.");
            if (domainsMultimapWithPaths403BlackListed.get((Object)domainStr).size() > 50 && !domainsNotBlockableAfterTimes.contains(domainStr)) {
                HttpConnUtils.blacklistedDomains.add(domainStr);
                logger.warn("Domain: \"" + domainStr + "\" was blocked, after having more than 50 of its paths 403blackListed.");
                domainsMultimapWithPaths403BlackListed.removeAll(domainStr);
                throw new DomainBlockedException(domainStr);
            }
        }
    }

    public static boolean countAndBlockPathAfterTimes(SetMultimap<String, String> domainsWithPaths, ConcurrentHashMap<String, Integer> pathsWithTimes, String pathStr, String domainStr, int timesBeforeBlocked, boolean calledForPageUrl) {
        if (ConnSupportUtils.countInsertAndGetTimes(pathsWithTimes, pathStr) > timesBeforeBlocked) {
            domainsWithPaths.put(domainStr, pathStr);
            pathsWithTimes.remove(pathStr);
            return true;
        }
        return false;
    }

    public static boolean checkIfPathIs403BlackListed(String urlStr, String domainStr) {
        if (domainsMultimapWithPaths403BlackListed.containsKey(domainStr)) {
            String pathStr = UrlUtils.getPathStr(urlStr, null);
            if (pathStr == null) {
                return false;
            }
            return domainsMultimapWithPaths403BlackListed.get((Object)domainStr).contains(pathStr);
        }
        return false;
    }

    public static void on5XXerrorCode(int http5xxErrorCode, String domainStr) throws DomainBlockedException {
        if (!shouldBlockMost5XXDomains && http5xxErrorCode != 511) {
            return;
        }
        if (http5xxErrorCode == 503 || domainStr == null) {
            return;
        }
        if (ConnSupportUtils.countAndBlockDomainAfterTimes(HttpConnUtils.blacklistedDomains, timesDomainsReturned5XX, domainStr, 10, true)) {
            logger.warn("Domain: \"" + domainStr + "\" was blocked after returning 5XX Error Code 10 times.");
            throw new DomainBlockedException(domainStr);
        }
    }

    public static void onTimeoutException(String domainStr) throws DomainBlockedException {
        if (ConnSupportUtils.countAndBlockDomainAfterTimes(HttpConnUtils.blacklistedDomains, timesDomainsHadTimeoutEx, domainStr, 25, true)) {
            logger.warn("Domain: \"" + domainStr + "\" was blocked after causing TimeoutException 25 times.");
            throw new DomainBlockedException(domainStr);
        }
    }

    public static boolean countAndBlockDomainAfterTimes(Set<String> blackList, ConcurrentHashMap<String, Integer> domainsWithTimes, String domainStr, int timesBeforeBlock, boolean checkAgainstDocUrlsHits) {
        if (domainsNotBlockableAfterTimes.contains(domainStr)) {
            return false;
        }
        int badTimes = ConnSupportUtils.countInsertAndGetTimes(domainsWithTimes, domainStr);
        if (badTimes > timesBeforeBlock) {
            Integer goodTimes;
            if (checkAgainstDocUrlsHits && (goodTimes = UrlUtils.domainsAndNumHits.get(domainStr)) != null && badTimes <= goodTimes + timesBeforeBlock) {
                return false;
            }
            blackList.add(domainStr);
            domainsWithTimes.remove(domainStr);
            return true;
        }
        return false;
    }

    public static int countInsertAndGetTimes(ConcurrentHashMap<String, Integer> itemsWithTimes, String itemToCount) {
        int curTimes = 1;
        Integer prevTimes = itemsWithTimes.get(itemToCount);
        if (prevTimes != null) {
            curTimes += prevTimes.intValue();
        }
        itemsWithTimes.put(itemToCount, curTimes);
        return curTimes;
    }

    public static List<String> blockSharedSiteSessionDomains(String targetUrl, String previousFromTargetUrl) {
        String beforeTargetUrlDomain;
        ArrayList<String> blockedDomainsToReturn = new ArrayList<String>(2);
        String targetUrlDomain = UrlUtils.getDomainStr(targetUrl, null);
        if (targetUrlDomain == null) {
            return null;
        }
        blockedDomainsToReturn.add(targetUrlDomain);
        if (HttpConnUtils.blacklistedDomains.add(targetUrlDomain)) {
            logger.warn("Domain: \"" + targetUrlDomain + "\" was blocked after trying to cause a \"sharedSiteSession-redirectionPack\" with url: \"" + targetUrl + "\"!");
        }
        if (previousFromTargetUrl != null && !previousFromTargetUrl.equals(targetUrl) && (beforeTargetUrlDomain = UrlUtils.getDomainStr(previousFromTargetUrl, null)) != null) {
            blockedDomainsToReturn.add(beforeTargetUrlDomain);
            if (HttpConnUtils.blacklistedDomains.add(beforeTargetUrlDomain)) {
                logger.warn("Domain: \"" + beforeTargetUrlDomain + "\" was blocked after its url : \"" + previousFromTargetUrl + "\" tried to redirect to targetUrl: \"" + targetUrl + "\" and cause a \"sharedSiteSession-redirectionPack\"!");
            }
        }
        return blockedDomainsToReturn;
    }

    /*
     * Exception decompiling
     */
    public static FileData downloadHtmlFile(HttpURLConnection conn, String urlId, String pageUrl, Matcher urlMatcher, String firstHTMLlineFromDetectedContentType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getHtmlString(HttpURLConnection conn, String pageUrl, BufferedReader bufferedReader, boolean isForError, String firstHTMLlineFromDetectedContentType) {
        String string;
        BufferedReader br;
        InputStream inputStream2;
        StringBuilder htmlStrB;
        block28: {
            String inputLine;
            int contentSize = ConnSupportUtils.getContentSize(conn, false, isForError);
            if (contentSize == -1) {
                if (!isForError) {
                    logger.warn("Aborting HTML-extraction for pageUrl: " + pageUrl);
                }
                ConnSupportUtils.closeBufferedReader(bufferedReader);
                return null;
            }
            htmlStrB = htmlStrBuilder.get();
            if (htmlStrB == null) {
                htmlStrB = new StringBuilder(ArgsUtils.shouldJustDownloadHtmlFiles ? 10000 : 100000);
                htmlStrBuilder.set(htmlStrB);
            }
            int bufferSize = 0;
            inputStream2 = null;
            if (bufferedReader == null) {
                inputStream2 = ConnSupportUtils.checkEncodingAndGetInputStream(conn, isForError);
                if (inputStream2 == null) {
                    return null;
                }
                bufferSize = contentSize != -2 && contentSize < 0x100000 ? contentSize : 0x100000;
            }
            br = bufferedReader != null ? bufferedReader : new BufferedReader(new InputStreamReader(inputStream2, StandardCharsets.UTF_8), bufferSize);
            String htmlSpaceChar = " ";
            if (firstHTMLlineFromDetectedContentType != null) {
                htmlStrB.append(firstHTMLlineFromDetectedContentType).append(" ");
            }
            while ((inputLine = br.readLine()) != null) {
                if (inputLine.isEmpty() || inputLine.length() == 1 || SPACE_ONLY_LINE.matcher(inputLine).matches()) continue;
                htmlStrB.append(inputLine).append(" ");
            }
            String string2 = string = !htmlStrB.isEmpty() ? htmlStrB.toString() : null;
            if (br == null) break block28;
            br.close();
        }
        htmlStrB.setLength(0);
        try {
            if (inputStream2 != null) {
                inputStream2.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        if (e instanceof IOException) {
                            logger.error("IOException when retrieving the HTML-code for pageUrl \"" + pageUrl + "\": " + e.getMessage());
                        } else {
                            logger.error("Could not retrieve the html-code for pageUrl \"" + pageUrl + "\"!", e);
                        }
                        String string3 = null;
                        return string3;
                    }
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    htmlStrB.setLength(0);
                    try {
                        if (inputStream2 != null) {
                            inputStream2.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static ArrayList<Object> detectContentTypeFromResponseBody(String finalUrlStr, String domainStr, HttpURLConnection conn, boolean calledForPageUrl) throws Exception {
        String warnMsg = "No ContentType nor ContentDisposition, were able to be retrieved from url: " + finalUrlStr;
        String mimeType = null;
        boolean foundDetectedContentType = false;
        String firstHtmlLine = null;
        BufferedReader bufferedReader = null;
        boolean calledForPossibleDocUrl = false;
        DetectedContentType detectedContentType = ConnSupportUtils.extractContentTypeFromResponseBody(conn = ConnSupportUtils.checkForHEADConnectionAndReconnectIfNeededWithGET(conn, finalUrlStr, domainStr, true, true));
        if (detectedContentType != null) {
            switch (detectedContentType.detectedContentType) {
                case "html": {
                    if (calledForPageUrl) {
                        logger.debug("The url with the undeclared content type < " + finalUrlStr + " >, was examined and found to have HTML contentType! Going to visit the page.");
                    }
                    mimeType = "text/html";
                    foundDetectedContentType = true;
                    firstHtmlLine = detectedContentType.firstHtmlLine;
                    bufferedReader = detectedContentType.bufferedReader;
                    numContentTypeExtractedFromPageContent.incrementAndGet();
                    break;
                }
                case "pdf": {
                    logger.debug("The url with the undeclared content type < " + finalUrlStr + " >, was examined and found to have PDF contentType!");
                    mimeType = "application/pdf";
                    calledForPossibleDocUrl = true;
                    foundDetectedContentType = true;
                    numContentTypeExtractedFromPageContent.incrementAndGet();
                    break;
                }
                case "undefined": {
                    logger.debug("The url with the undeclared content type < " + finalUrlStr + " >, was examined and found to have UNDEFINED contentType.");
                    break;
                }
                default: {
                    warnMsg = warnMsg + "\nUnspecified \"detectedContentType\": " + detectedContentType.detectedContentType;
                    break;
                }
            }
        } else {
            warnMsg = warnMsg + "\nCould not retrieve the response-body for url: " + finalUrlStr;
        }
        if (!foundDetectedContentType) {
            if (ConnSupportUtils.countAndBlockDomainAfterTimes(HttpConnUtils.blacklistedDomains, HttpConnUtils.timesDomainsReturnedNoType, domainStr, 10, true)) {
                logger.warn(warnMsg);
                logger.warn("Domain: \"" + domainStr + "\" was blocked after returning no Type-info more than 10 times.");
                throw new DomainBlockedException(domainStr);
            }
            throw new RuntimeException(warnMsg);
        }
        ArrayList<Object> detectionList = new ArrayList<Object>(5);
        detectionList.add(0, mimeType);
        detectionList.add(1, foundDetectedContentType);
        detectionList.add(2, firstHtmlLine);
        detectionList.add(3, bufferedReader);
        detectionList.add(4, calledForPossibleDocUrl);
        return detectionList;
    }

    public static DetectedContentType extractContentTypeFromResponseBody(HttpURLConnection conn) {
        int contentSize = 0;
        contentSize = ConnSupportUtils.getContentSize(conn, false, false);
        if (contentSize == -1) {
            logger.warn("Aborting content-extraction for pageUrl: " + conn.getURL().toString());
            return null;
        }
        InputStream inputStream2 = ConnSupportUtils.checkEncodingAndGetInputStream(conn, false);
        if (inputStream2 == null) {
            return null;
        }
        int bufferSize = contentSize != -2 && contentSize < 0x500000 ? contentSize : 0x500000;
        BufferedReader br = null;
        try {
            String inputLine;
            br = new BufferedReader(new InputStreamReader(inputStream2, StandardCharsets.UTF_8), bufferSize);
            while ((inputLine = br.readLine()) != null && (inputLine.isEmpty() || inputLine.length() == 1 || RESPONSE_BODY_UNWANTED_MATCH.matcher(inputLine).matches())) {
            }
            if (inputLine == null) {
                return null;
            }
            String lowerCaseInputLine = inputLine.toLowerCase();
            if (HTML_STRING_INDICATOR.matcher(lowerCaseInputLine).find()) {
                return new DetectedContentType("html", inputLine, br);
            }
            try {
                br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (lowerCaseInputLine.startsWith("%pdf-", 0)) {
                return new DetectedContentType("pdf", null, null);
            }
            return new DetectedContentType("undefined", inputLine, null);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                logger.error("IOException when retrieving the HTML-code: " + e.getMessage());
            } else {
                logger.error("", e);
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static int getContentSize(HttpURLConnection conn, boolean calledForFullTextDownload, boolean isForError) {
        try {
            int contentSize = Integer.parseInt(conn.getHeaderField("Content-Length"));
            long maxSize = calledForFullTextDownload ? HttpConnUtils.maxAllowedFulltextContentSize : HttpConnUtils.maxAllowedHtmlContentSize;
            if (contentSize <= 0 || (long)contentSize > maxSize) {
                if (!isForError) {
                    logger.warn((calledForFullTextDownload ? "DocUrl: \"" : "Url: \"") + conn.getURL().toString() + "\" had a non-acceptable contentSize: " + contentSize + ". The maxAllowed one is: " + maxAllowedContentSizeMB + " MB.");
                }
                return -1;
            }
            return contentSize;
        }
        catch (NumberFormatException nfe) {
            if (calledForFullTextDownload && logger.isTraceEnabled()) {
                logger.trace("No \"Content-Length\" was retrieved from docUrl: \"" + conn.getURL().toString() + "\"! We will store the docFile anyway..");
            }
            return -2;
        }
        catch (Exception e) {
            logger.error("", e);
            return -2;
        }
    }

    public static void closeBufferedReader(BufferedReader bufferedReader) {
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (IOException ioe) {
            logger.warn("Problem when closing \"BufferedReader\": " + ioe.getMessage());
        }
    }

    public static String getFullyFormedUrl(String pageUrl, String currentLink, URL urlBase) {
        try {
            if (urlBase == null) {
                if (pageUrl != null) {
                    urlBase = URI.create(pageUrl).toURL();
                } else {
                    logger.error("No urlBase to produce a fully-formedUrl for internal-link: " + currentLink);
                    return null;
                }
            }
            if ((currentLink = Strings.CS.replace(currentLink, "amp;", "&", -1)).startsWith("?")) {
                return String.valueOf(urlBase) + currentLink;
            }
            return new URL(urlBase, currentLink).toString();
        }
        catch (Exception e) {
            logger.error("Error when producing fully-formedUrl for internal-link: " + currentLink, (Object)e.getMessage());
            return null;
        }
    }

    public static boolean isJustAnHTTPSredirect(String currentUrl, String targetUrl) {
        return currentUrl.startsWith("http://", 0) && targetUrl.startsWith("https://", 0) && ConnSupportUtils.haveOnlyProtocolDifference(currentUrl, targetUrl);
    }

    public static boolean isJustASlashRedirect(String currentUrl, String targetUrl) {
        return !currentUrl.endsWith("/") && targetUrl.endsWith("/") && currentUrl.equals(targetUrl.substring(0, targetUrl.length() - 1));
    }

    public static boolean haveOnlyProtocolDifference(String url1, String url2) {
        String non_protocol_url2Url;
        String non_protocol_url1;
        Matcher url1NonProtocolMatcher = NON_PROTOCOL_URL.matcher(url1);
        if (!url1NonProtocolMatcher.matches()) {
            logger.warn("URL < " + url1 + " > failed to match with \"NON_PROTOCOL_URL\"-regex: " + String.valueOf(NON_PROTOCOL_URL));
            return false;
        }
        try {
            non_protocol_url1 = url1NonProtocolMatcher.group(1);
        }
        catch (Exception e) {
            logger.error("No match for url1: " + url1, e);
            return false;
        }
        if (non_protocol_url1 == null || non_protocol_url1.isEmpty()) {
            logger.warn("Unexpected null or empty value returned by \"url1NonProtocolMatcher.group(1)\" for url: \"" + url1 + "\"");
            return false;
        }
        Matcher url2UrlNonProtocolMatcher = NON_PROTOCOL_URL.matcher(url2);
        if (!url2UrlNonProtocolMatcher.matches()) {
            logger.warn("URL < " + url2 + " > failed to match with \"NON_PROTOCOL_URL\"-regex: " + String.valueOf(NON_PROTOCOL_URL));
            return false;
        }
        try {
            non_protocol_url2Url = url2UrlNonProtocolMatcher.group(1);
        }
        catch (Exception e) {
            logger.error("No match for url2: " + url2, e);
            return false;
        }
        if (non_protocol_url2Url == null || non_protocol_url2Url.isEmpty()) {
            logger.warn("Unexpected null or empty value returned by \"url2UrlNonProtocolMatcher.group(1)\" for url: \"" + url2 + "\"");
            return false;
        }
        return non_protocol_url1.equals(non_protocol_url2Url);
    }

    public static InputStream getInputStreamFromInputDataUrl() {
        if (ArgsUtils.inputDataUrl == null || ArgsUtils.inputDataUrl.isEmpty()) {
            String errorMessage = "The \"inputDataUrl\" was not given, even though";
            logger.error(errorMessage);
            System.err.println(errorMessage);
            PublicationsRetriever.executor.shutdownNow();
            System.exit(55);
        }
        InputStream inputStream2 = null;
        try {
            HttpURLConnection conn = HttpConnUtils.handleConnection(null, ArgsUtils.inputDataUrl, ArgsUtils.inputDataUrl, ArgsUtils.inputDataUrl, null, true, true);
            String mimeType = conn.getHeaderField("Content-Type");
            if (mimeType == null || !mimeType.toLowerCase().contains("json")) {
                String errorMessage = "The mimeType of the url was either null or a non-json: " + mimeType;
                logger.error(errorMessage);
                System.err.println(errorMessage);
                PublicationsRetriever.executor.shutdownNow();
                System.exit(56);
            }
            if ((inputStream2 = ConnSupportUtils.checkEncodingAndGetInputStream(conn, false)) == null) {
                throw new RuntimeException("Could not acquire the InputStream!");
            }
            int contentSize = ConnSupportUtils.getContentSize(conn, true, false);
            if (contentSize == -1) {
                throw new FileNotRetrievedException("The HTTP-reported size of this file was unacceptable!");
            }
            int bufferSize = contentSize != -2 && contentSize < 0x500000 ? contentSize : 0x500000;
            inputStream2 = new BufferedInputStream(inputStream2, bufferSize);
        }
        catch (Exception e) {
            String errorMessage = "Unexpected error when retrieving the input-stream from the inputDataUrl:\n" + e.getMessage();
            logger.error(errorMessage);
            System.err.println(errorMessage);
            PublicationsRetriever.executor.shutdownNow();
            System.exit(57);
        }
        try {
            System.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inputStream2;
    }

    public static long getRandomNumber(int min, int max) {
        return threadLocalRandom.nextLong(min, max + 1);
    }

    public static String getWasDirectLink(String sourceUrl, String pageUrl, boolean calledForPageUrl, String finalUrlStr) {
        String wasDirectLink;
        if (calledForPageUrl) {
            boolean isSpecialUrl = HttpConnUtils.isSpecialUrl.get();
            HttpConnUtils.isSpecialUrl.remove();
            wasDirectLink = !isSpecialUrl && (pageUrl.equals(finalUrlStr) || ConnSupportUtils.haveOnlyProtocolDifference(pageUrl, finalUrlStr)) || sourceUrl.equals(finalUrlStr) || ConnSupportUtils.haveOnlyProtocolDifference(sourceUrl, finalUrlStr) ? "true" : (isSpecialUrl ? "false" : "null");
        } else {
            wasDirectLink = "false";
        }
        return wasDirectLink;
    }

    public static void printEmbeddedExceptionMessage(Exception e, String resourceURL) {
        String exMsg = e.getMessage();
        if (exMsg != null) {
            StackTraceElement firstLineOfStackTrace = e.getStackTrace()[0];
            logger.warn("[" + firstLineOfStackTrace.getFileName() + "->" + firstLineOfStackTrace.getMethodName() + "(@" + firstLineOfStackTrace.getLineNumber() + ")] - " + exMsg);
        } else {
            logger.warn("Could not handle connection for \"" + resourceURL + "\"!");
        }
    }

    public static void printConnectionDebugInfo(HttpURLConnection conn, boolean shouldShowFullHeaders) {
        if (conn == null) {
            logger.warn("The given connection instance was null..");
            return;
        }
        logger.debug("Connection debug info:\nURL: < {} >,\nContentType: \"{}\". ContentDisposition: \"{}\", HTTP-method: \"{}\"", conn.getURL().toString(), conn.getContentType(), conn.getHeaderField("Content-Disposition"), conn.getRequestMethod());
        if (shouldShowFullHeaders) {
            StringBuilder sb = new StringBuilder(1000).append("Headers:\n");
            Map<String, List<String>> headers = conn.getHeaderFields();
            for (String headerKey : headers.keySet()) {
                for (String headerValue : headers.get(headerKey)) {
                    sb.append(headerKey).append(" : ").append(headerValue).append("\n");
                }
            }
            logger.debug(sb.toString());
        }
    }

    public static void printRedirectDebugInfo(String currentUrl, String location, String targetUrl, int responseCode, int curRedirectsNum) {
        if (currentUrl.contains("doi.org")) {
            logger.debug("\n");
            logger.debug("Redirect(s) num: " + curRedirectsNum);
            logger.debug("Redirect code: " + responseCode);
            logger.debug("Base: " + currentUrl);
            logger.debug("Location: " + location);
            logger.debug("Target: " + targetUrl + "\n");
        }
    }

    public static void printFinalRedirectDataForWantedUrlType(String initialUrl, String finalUrl, String wantedUrlType, int redirectsNum) {
        if (wantedUrlType != null && initialUrl.contains(wantedUrlType)) {
            logger.debug("\"" + initialUrl + "\" DID: " + redirectsNum + " redirect(s)!");
            logger.debug("Final link is: \"" + finalUrl + "\"");
        }
    }

    static {
        domainsNotBlockableAfterTimes.add("zenodo.org");
        domainsNotBlockableAfterTimes.add("doi.org");
        domainsNotBlockableAfterTimes.add("dx.doi.org");
        htmlStrBuilder = new ThreadLocal();
        numContentTypeExtractedFromPageContent = new AtomicLong(0L);
        maxAllowedContentSizeMB = HttpConnUtils.maxAllowedFulltextContentSize / 0x100000;
        threadLocalRandom = ThreadLocalRandom.current();
    }
}

