/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import io.minio.ObjectReadArgs;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class GetObjectAttributesArgs
extends ObjectReadArgs {
    private List<String> objectAttributes;
    private Integer maxParts;
    private Integer partNumberMarker;

    public List<String> objectAttributes() {
        return this.objectAttributes;
    }

    public Integer maxParts() {
        return this.maxParts;
    }

    public Integer partNumberMarker() {
        return this.partNumberMarker;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetObjectAttributesArgs)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GetObjectAttributesArgs that = (GetObjectAttributesArgs)o;
        return Objects.equals(this.objectAttributes, that.objectAttributes) && Objects.equals(this.maxParts, that.maxParts) && Objects.equals(this.partNumberMarker, that.partNumberMarker);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.objectAttributes, this.maxParts, this.partNumberMarker);
    }

    public static final class Builder
    extends ObjectReadArgs.Builder<Builder, GetObjectAttributesArgs> {
        @Override
        protected void validate(GetObjectAttributesArgs args2) {
            super.validate(args2);
            this.validateNotNull(args2.objectAttributes, "object attributes");
        }

        public Builder objectAttributes(String[] objectAttributes) {
            this.operations.add(args2 -> ((GetObjectAttributesArgs)args2).objectAttributes = objectAttributes == null ? null : Arrays.asList(objectAttributes));
            return this;
        }

        public Builder objectAttributes(List<String> objectAttributes) {
            this.operations.add(args2 -> ((GetObjectAttributesArgs)args2).objectAttributes = objectAttributes);
            return this;
        }

        public Builder maxParts(Integer maxParts) {
            this.operations.add(args2 -> ((GetObjectAttributesArgs)args2).maxParts = maxParts);
            return this;
        }

        public Builder partNumberMarker(Integer partNumberMarker) {
            this.operations.add(args2 -> ((GetObjectAttributesArgs)args2).partNumberMarker = partNumberMarker);
            return this;
        }
    }
}

