/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.publications_retriever.util.signal;

import eu.openaire.publications_retriever.PublicationsRetriever;
import eu.openaire.publications_retriever.util.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;

public class SignalUtils {
    private static final Logger logger = LoggerFactory.getLogger(SignalUtils.class);
    public static boolean receivedSIGINT = false;

    public static void setSignalHandlers() {
        Signal.handle(new Signal("INT"), sig -> {
            try {
                PublicationsRetriever.executor.shutdownNow();
                receivedSIGINT = true;
                String stopMessage = "The normal program execution was interrupted by a \"SIGINT\"-signal!";
                logger.warn(stopMessage);
                System.err.println(stopMessage);
                if (!FileUtils.dataForOutput.isEmpty()) {
                    logger.debug("Writing the remaining quadruples to the outputFile.");
                    FileUtils.writeResultsToFile();
                }
                if (PublicationsRetriever.startTime != null) {
                    PublicationsRetriever.showStatistics(PublicationsRetriever.startTime);
                }
                FileUtils.closeIO();
                System.exit(-12);
            }
            catch (Exception e) {
                String errMsg = "Unexpected exception in SIGNAL HANDLER! The program will terminate immediately, without any guarantees of data-flushing in the output!\n" + String.valueOf(e);
                System.err.println(errMsg);
                logger.error(errMsg);
                System.exit(-133);
            }
        });
    }
}

