/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.extension;

import crawlercommons.sitemaps.extension.ExtensionMetadata;
import crawlercommons.sitemaps.extension.PageMapDataObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PageMap
extends ExtensionMetadata {
    private List<PageMapDataObject> dataObjects = new ArrayList<PageMapDataObject>();

    public List<PageMapDataObject> getPageMapDataObjects() {
        return this.dataObjects;
    }

    public void addDataObject(PageMapDataObject d) {
        this.dataObjects.add(d);
    }

    @Override
    public Map<String, String[]> asMap() {
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>();
        for (PageMapDataObject dobj : this.dataObjects) {
            for (Map.Entry<String, String[]> e : dobj.asMap().entrySet()) {
                map.put(e.getKey(), e.getValue());
            }
        }
        return map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PageMap: [");
        if (!this.dataObjects.isEmpty()) {
            sb.append('\n');
        }
        for (PageMapDataObject dobj : this.dataObjects) {
            sb.append(dobj.toString()).append(",\n");
        }
        sb.append(']');
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.dataObjects);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageMap other = (PageMap)obj;
        return Objects.equals(this.dataObjects, other.dataObjects);
    }
}

