/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.sax;

import crawlercommons.sitemaps.AbstractSiteMap;
import crawlercommons.sitemaps.SiteMap;
import crawlercommons.sitemaps.SiteMapParser;
import crawlercommons.sitemaps.SiteMapURL;
import crawlercommons.sitemaps.sax.DelegatorHandler;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class RSSHandler
extends DelegatorHandler {
    private SiteMap sitemap;
    private URL locURL;
    private ZonedDateTime lastMod;
    boolean valid;

    RSSHandler(URL url, LinkedList<String> elementStack, boolean strict) {
        super(elementStack, strict);
        this.sitemap = new SiteMap(url);
        this.sitemap.setType(AbstractSiteMap.SitemapType.RSS);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("link".equals(localName)) {
            this.setLocURL();
        } else if ("guid".equals(localName)) {
            if (this.locURL == null) {
                this.setLocURL();
            }
            this.resetCharacterBuffer();
        } else if ("item".equals(localName)) {
            this.maybeAddSiteMapUrl();
        } else if ("rss".equals(localName)) {
            this.sitemap.setProcessed(true);
        } else if ("pubDate".equals(localName)) {
            String value = this.getAndResetCharacterBuffer();
            this.lastMod = AbstractSiteMap.parseRSSTimestamp(value);
            if (this.lastMod != null && "channel".equals(super.currentElementParent())) {
                this.sitemap.setLastModified(this.lastMod);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String localName = super.currentElement();
        if ("pubDate".equals(localName) || "link".equals(localName) || "guid".equals(localName)) {
            this.appendCharacterBuffer(ch, start, length);
        }
    }

    @Override
    public AbstractSiteMap getSiteMap() {
        return this.sitemap;
    }

    private void setLocURL() {
        String loc = this.getAndResetCharacterBuffer();
        if (loc == null) {
            return;
        }
        String value = RSSHandler.stripAllBlank(loc);
        if (value.isEmpty()) {
            return;
        }
        try {
            this.locURL = this.sitemap.getUrl().toURI().resolve(value).toURL();
            String urlFiltered = (String)this.urlFilter.apply(this.locURL.toString());
            if (urlFiltered == null) {
                SiteMapParser.LOG.debug("Filtered URL {}", (Object)value);
                return;
            }
            this.locURL = new URI(urlFiltered).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            SiteMapParser.LOG.debug("Bad url: [{}]", (Object)value);
            SiteMapParser.LOG.trace("Can't create an entry with a bad URL", e);
        }
    }

    private void maybeAddSiteMapUrl() {
        if (this.locURL != null) {
            boolean valid = SiteMapParser.urlIsValid(this.sitemap.getBaseUrl(), this.locURL.toString());
            if (!this.isStrict() || valid) {
                SiteMapURL sUrl = new SiteMapURL(this.locURL, valid);
                sUrl.setLastModified(this.lastMod);
                this.sitemap.addSiteMapUrl(sUrl);
            }
        }
        this.locURL = null;
        this.lastMod = null;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.maybeAddSiteMapUrl();
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.maybeAddSiteMapUrl();
    }
}

