/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.publications_retriever.util.file;

import ch.qos.logback.classic.LoggerContext;
import com.google.common.collect.HashMultimap;
import eu.openaire.publications_retriever.PublicationsRetriever;
import eu.openaire.publications_retriever.exceptions.FileNotRetrievedException;
import eu.openaire.publications_retriever.util.args.ArgsUtils;
import eu.openaire.publications_retriever.util.file.FileData;
import eu.openaire.publications_retriever.util.file.IdUrlTuple;
import eu.openaire.publications_retriever.util.file.S3ObjectStore;
import eu.openaire.publications_retriever.util.url.DataForOutput;
import eu.openaire.publications_retriever.util.url.LoaderAndChecker;
import eu.openaire.publications_retriever.util.url.UrlUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.lang3.Strings;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    private static Scanner inputScanner = null;
    private static PrintStream printStream = null;
    public static long numOfLines = 0L;
    public static int jsonBatchSize = 3000;
    private static StringBuilder stringToBeWritten = null;
    private static int fileIndex = 0;
    public static boolean skipFirstRow = false;
    public static final String endOfLine = System.lineSeparator();
    public static int unretrievableInputLines = 0;
    public static final List<DataForOutput> dataForOutput = Collections.synchronizedList(new ArrayList(jsonBatchSize));
    public static final HashMap<String, Integer> numbersOfDuplicateDocFileNames = new HashMap();
    public static final boolean shouldOutputFullPathName = true;
    public static int numOfDocFile = 0;
    public static final String workingDir = System.getProperty("user.dir") + File.separator;
    public static int unretrievableDocNamesNum = 0;
    public static final Pattern FILENAME_FROM_CONTENT_DISPOSITION_FILTER = Pattern.compile(".*filename[*]?=(?:.*[\"'])?([^\"^;]+)[\";]*.*");
    public static final int MAX_FILENAME_LENGTH = 250;
    public static String fullInputFilePath = null;
    public static int duplicateIdUrlEntries = 0;
    private static final String utf8Charset = StandardCharsets.UTF_8.toString();
    public static final Pattern EXTENSION_PATTERN = Pattern.compile("(\\.[^._-]+)$");
    private static final int expectedPathsPerID = 5;
    private static final int expectedIDsPerBatch = jsonBatchSize / 5;
    private static HashMultimap<String, String> idAndUrlMappedInput = null;
    public static final AtomicInteger numOfDocFiles = new AtomicInteger(0);
    private static final Lock fileNameLock = new ReentrantLock(true);
    public static final int mb = 0x100000;
    public static final int fiveMb = 0x500000;
    static final int fiftyMBInBytes = 0x3200000;
    static final int oneHundredMBInBytes = 0x6400000;
    static final int twoHundredMBInBytes = 0xC800000;
    static final int threeHundredMBInBytes = 314572800;

    public FileUtils(InputStream input, OutputStream output) {
        inputScanner = new Scanner(input, utf8Charset);
        FileUtils.setOutput(output);
        if (ArgsUtils.shouldUploadFilesToS3) {
            new S3ObjectStore();
        }
    }

    public static void setOutput(OutputStream output) {
        try {
            printStream = new PrintStream(output, false, utf8Charset);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            System.exit(20);
        }
        if (ArgsUtils.shouldJustDownloadHtmlFiles) {
            FileUtils.handleStoreFilesDirectory(ArgsUtils.storeHtmlFilesDir, ArgsUtils.shouldDeleteOlderHTMLFiles, false);
        } else if (ArgsUtils.shouldDownloadDocFiles) {
            FileUtils.handleStoreFilesDirectory(ArgsUtils.storeDocFilesDir, ArgsUtils.shouldDeleteOlderDocFiles, true);
        }
    }

    public static void handleStoreFilesDirectory(String storeFilesDir, boolean shouldDeleteOlderFiles, boolean calledForDocFiles) {
        File dir = new File(storeFilesDir);
        if (shouldDeleteOlderFiles) {
            logger.info("Deleting old " + (calledForDocFiles ? "doc" : "html") + "Files..");
            try {
                org.apache.commons.io.FileUtils.deleteDirectory(dir);
            }
            catch (IOException ioe) {
                logger.error("The following directory could not be deleted: " + storeFilesDir, ioe);
                if (calledForDocFiles) {
                    ArgsUtils.shouldDownloadDocFiles = false;
                }
                return;
            }
            catch (IllegalArgumentException iae) {
                logger.error("This directory does not exist: " + storeFilesDir + "\n" + iae.getMessage());
                return;
            }
        }
        try {
            if (!dir.exists() && !dir.mkdirs()) {
                String errorMessage = ArgsUtils.docFilesStorageGivenByUser ? "Problem when creating the \"storeDocFilesDir\": \"" + storeFilesDir + "\".\nPlease give a valid Directory-path." : "Problem when creating the default \"storeDocFilesDir\": \"" + storeFilesDir + "\".\nPlease verify you have the necessary privileges in the directory you are running the program from or specify the directory you want to save the files to.\nIf the above is not an option, then you can set to retrieve just the " + ArgsUtils.targetUrlType + "s and download the full-texts later (on your own).";
                System.err.println(errorMessage);
                logger.error(errorMessage);
                FileUtils.closeIO();
                System.exit(-3);
            }
        }
        catch (SecurityException se) {
            logger.error(se.getMessage(), se);
            logger.warn("There was an error creating the docFiles-storageDir! Continuing without downloading the docFiles, while creating the jsonOutput with the docUrls.");
            if (calledForDocFiles) {
                ArgsUtils.shouldDownloadDocFiles = false;
            }
            ArgsUtils.shouldJustDownloadHtmlFiles = false;
        }
    }

    public static long getInputNumOfLines() {
        long lineCount = 0L;
        String baseFileName = workingDir + "inputFile";
        String extension = LoaderAndChecker.useIdUrlPairs ? ".json" : ".csv";
        int fileNum = 1;
        fullInputFilePath = baseFileName + extension;
        File file = new File(fullInputFilePath);
        while (file.exists()) {
            fullInputFilePath = baseFileName + fileNum++ + extension;
            file = new File(fullInputFilePath);
        }
        try {
            printStream = new PrintStream(Files.newOutputStream(file.toPath(), new OpenOption[0]), false, utf8Charset);
            while (inputScanner.hasNextLine()) {
                printStream.print(inputScanner.nextLine());
                printStream.print(endOfLine);
                ++lineCount;
            }
            printStream.close();
            inputScanner.close();
            inputScanner = new Scanner(Files.newInputStream(Paths.get(fullInputFilePath, new String[0]), new OpenOption[0]));
        }
        catch (Exception e) {
            logger.error("", e);
            FileUtils.closeIO();
            System.exit(-10);
        }
        if (skipFirstRow && lineCount != 0L) {
            return lineCount - 1L;
        }
        return lineCount;
    }

    public static int getCurrentlyLoadedUrls() {
        if (skipFirstRow) {
            return fileIndex - unretrievableInputLines - 1;
        }
        return fileIndex - unretrievableInputLines;
    }

    public static HashMultimap<String, String> getNextIdUrlPairBatchFromJson() {
        if (idAndUrlMappedInput == null) {
            idAndUrlMappedInput = HashMultimap.create(expectedIDsPerBatch, 5);
        } else {
            idAndUrlMappedInput.clear();
        }
        int curBeginning = fileIndex;
        while (inputScanner.hasNextLine() && fileIndex < curBeginning + jsonBatchSize) {
            String retrievedLineStr = inputScanner.nextLine();
            ++fileIndex;
            if (retrievedLineStr.isEmpty()) {
                ++unretrievableInputLines;
                continue;
            }
            IdUrlTuple inputIdUrlTuple = FileUtils.getDecodedJson(retrievedLineStr);
            if (inputIdUrlTuple == null) {
                logger.warn("A problematic inputLine found: \t" + retrievedLineStr);
                ++unretrievableInputLines;
                continue;
            }
            if (idAndUrlMappedInput.put((Object)inputIdUrlTuple.id, (Object)inputIdUrlTuple.url)) continue;
            ++duplicateIdUrlEntries;
            UrlUtils.addOutputData(inputIdUrlTuple.id, inputIdUrlTuple.url, null, "duplicate", "Discarded in FileUtils.getNextIdUrlPairBatchFromJson(), as it is a duplicate.", "null", null, false, "false", "null", "null", "null", "true", null, "null", "null");
        }
        return idAndUrlMappedInput;
    }

    public static IdUrlTuple getDecodedJson(String jsonLine) {
        String urlStr;
        String idStr;
        try {
            JSONObject jObj = new JSONObject(jsonLine);
            idStr = jObj.get("id").toString();
            urlStr = jObj.get("url").toString();
        }
        catch (JSONException je) {
            logger.warn("JSONException caught when tried to parse and extract values from jsonLine: \t" + jsonLine, je);
            return null;
        }
        if (urlStr.isEmpty()) {
            if (!idStr.isEmpty()) {
                UrlUtils.addOutputData(idStr, urlStr, null, "unreachable", "Discarded in FileUtils.jsonDecoder(), as the url was not found.", "null", null, true, "true", "false", "false", "false", "false", null, "null", "null");
            }
            return null;
        }
        return new IdUrlTuple(idStr, urlStr);
    }

    public static void writeResultsToFile() {
        if (stringToBeWritten == null) {
            stringToBeWritten = new StringBuilder(jsonBatchSize * 900);
        }
        for (DataForOutput data : dataForOutput) {
            stringToBeWritten.append(data.toJsonString()).append(endOfLine);
        }
        printStream.print(stringToBeWritten);
        printStream.flush();
        stringToBeWritten.setLength(0);
        logger.debug("Finished writing " + dataForOutput.size() + " quadruples to the outputFile.");
        dataForOutput.clear();
    }

    /*
     * Exception decompiling
     */
    public static FileData storeDocFileWithIdOrOriginalFileName(HttpResponse<InputStream> response, String docUrl, String id, int contentSize) throws FileNotRetrievedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static long downloadFile(String fileFullPath, int contentSize, String docUrl, MessageDigest md, BufferedInputStream inStream, BufferedOutputStream outStream) throws IOException, FileNotRetrievedException {
        int maxStoringWaitingTime = FileUtils.getMaxStoringWaitingTime(contentSize);
        int bytesRead = -1;
        byte[] buffer = new byte[65536];
        long bytesCount = 0L;
        long startTime = System.nanoTime();
        while ((bytesRead = inStream.read(buffer)) != -1) {
            long elapsedTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
            if (elapsedTime > (long)maxStoringWaitingTime || elapsedTime == Long.MIN_VALUE) {
                String errMsg = "Storing docFile from docUrl: \"" + docUrl + "\" is taking over " + TimeUnit.MILLISECONDS.toSeconds(maxStoringWaitingTime) + " seconds (for contentSize: " + PublicationsRetriever.df.format((double)contentSize / 1048576.0) + " MB)! Aborting..";
                logger.warn(errMsg);
                throw new FileNotRetrievedException(errMsg);
            }
            outStream.write(buffer, 0, bytesRead);
            md.update(buffer, 0, bytesRead);
            bytesCount += (long)bytesRead;
        }
        if (bytesCount == 0L) {
            String errMsg = "InputStream was empty when trying to download file: " + fileFullPath;
            logger.warn(errMsg);
            throw new FileNotRetrievedException(errMsg);
        }
        return bytesCount;
    }

    /*
     * Exception decompiling
     */
    public static synchronized FileData storeDocFileWithNumberName(HttpResponse<InputStream> response, String docUrl, int contentSize) throws FileNotRetrievedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static FileData checkAndThrowDocFileException(String docUrl, int contentSize, File docFile, Exception e) throws FileNotRetrievedException {
        try {
            if (docFile.exists()) {
                try {
                    FileDeleteStrategy.FORCE.delete(docFile);
                }
                catch (Exception e1) {
                    logger.error("Error when deleting the half-created file from docUrl: " + docUrl, e1);
                }
            }
        }
        catch (Exception e2) {
            logger.error("Error when checking if there is a half-created file from docUrl: " + docUrl, e2);
        }
        if (e instanceof FileNotRetrievedException) {
            throw (FileNotRetrievedException)e;
        }
        if (!(e instanceof IOException)) {
            logger.error("", e);
        }
        throw new FileNotRetrievedException(e.getMessage());
    }

    public static FileData getDocFileWithOriginalFileName(String docUrl, String contentDisposition, int contentSize) throws FileNotRetrievedException {
        Object docFileName = null;
        boolean hasUnretrievableDocName = false;
        String dotFileExtension = ".pdf";
        if (contentDisposition != null) {
            Matcher fileNameMatcher = FILENAME_FROM_CONTENT_DISPOSITION_FILTER.matcher(contentDisposition);
            if (fileNameMatcher.matches()) {
                try {
                    docFileName = fileNameMatcher.group(1);
                }
                catch (Exception e) {
                    logger.error("", e);
                }
                if (docFileName == null || ((String)docFileName).isEmpty()) {
                    docFileName = null;
                }
            } else {
                logger.warn("Unmatched file-content-Disposition: " + contentDisposition);
            }
        }
        if (docFileName == null) {
            docFileName = UrlUtils.getDocIdStr(docUrl, null);
        }
        if (docFileName != null && !((String)docFileName).isEmpty()) {
            String fullDocName;
            int docFullNameLength;
            if (File.separator.equals("\\")) {
                docFileName = Strings.CS.replace((String)docFileName, File.separator, "_");
            }
            if (!((String)docFileName).endsWith(dotFileExtension)) {
                docFileName = (String)docFileName + dotFileExtension;
            }
            if ((docFullNameLength = (fullDocName = ArgsUtils.storeDocFilesDir + (String)docFileName).length()) > 250) {
                logger.warn("Too long docFullName found (" + docFullNameLength + " chars), it would cause file-creation to fail, so we mark the file-name as \"unretrievable\".\nThe long docName is: \"" + fullDocName + "\".");
                hasUnretrievableDocName = true;
            }
        } else {
            hasUnretrievableDocName = true;
        }
        if (hasUnretrievableDocName) {
            docFileName = unretrievableDocNamesNum == 0 ? "unretrievableDocName" + dotFileExtension : "unretrievableDocName(" + unretrievableDocNamesNum + ")" + dotFileExtension;
            ++unretrievableDocNamesNum;
        }
        return FileUtils.getFileAndHandleExisting((String)docFileName, dotFileExtension, hasUnretrievableDocName, contentSize, ArgsUtils.storeDocFilesDir, numbersOfDuplicateDocFileNames);
    }

    public static FileData getFileAndHandleExisting(String fileName, String dotFileExtension, boolean hasUnretrievableDocName, int contentSize, String storeFilesDir, HashMap<String, Integer> numbersOfDuplicateFileNames) throws FileNotRetrievedException {
        String saveFileFullPath = storeFilesDir + (String)fileName;
        if (!((String)fileName).endsWith(dotFileExtension)) {
            saveFileFullPath = saveFileFullPath + dotFileExtension;
        }
        File file = new File(saveFileFullPath);
        FileOutputStream fileOutputStream = null;
        Integer curDuplicateNum = 0;
        String initialFileName = fileName;
        fileNameLock.lock();
        try {
            if (!hasUnretrievableDocName && (curDuplicateNum = (curDuplicateNum = numbersOfDuplicateFileNames.get(fileName)) != null ? Integer.valueOf(curDuplicateNum + 1) : (file.exists() ? Integer.valueOf(1) : Integer.valueOf(0))) > 0) {
                String preExtensionFileName = fileName;
                int lastIndexOfDot = ((String)fileName).lastIndexOf(".");
                if (lastIndexOfDot != -1) {
                    preExtensionFileName = ((String)fileName).substring(0, lastIndexOfDot);
                }
                fileName = preExtensionFileName + "(" + curDuplicateNum + ")" + dotFileExtension;
                saveFileFullPath = storeFilesDir + (String)fileName;
                file = new File(saveFileFullPath);
            }
            if (!dotFileExtension.equals(".html")) {
                fileOutputStream = new FileOutputStream(file);
            }
            if (curDuplicateNum > 0) {
                numbersOfDuplicateFileNames.put(initialFileName, curDuplicateNum);
            }
        }
        catch (FileNotFoundException fnfe) {
            String msg = fnfe.getMessage();
            if (msg != null && msg.contains("(No space left on device)")) {
                try {
                    if (file.exists()) {
                        FileDeleteStrategy.FORCE.delete(file);
                    }
                }
                catch (Exception e) {
                    logger.error("Error when deleting the half-created file: " + (String)fileName);
                }
            }
            logger.error("", fnfe);
            throw new FileNotRetrievedException(fnfe.getMessage());
        }
        catch (Exception e) {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception msg) {
                    // empty catch block
                }
            }
            String errMsg = "Error when handling the fileName = \"" + (String)fileName + "\" and dotFileExtension = \"" + dotFileExtension + "\"!";
            logger.error(errMsg, e);
            throw new FileNotRetrievedException(errMsg);
        }
        finally {
            fileNameLock.unlock();
        }
        return new FileData(file, saveFileFullPath, fileOutputStream);
    }

    private static int getMaxStoringWaitingTime(int contentSize) {
        if (contentSize == -2) {
            return 45000;
        }
        if (contentSize <= 0x3200000) {
            return 45000;
        }
        if (contentSize <= 0x6400000) {
            return 70000;
        }
        if (contentSize <= 0xC800000) {
            return 140000;
        }
        if (contentSize <= 314572800) {
            return 210000;
        }
        return 330000;
    }

    public static void closeIO() {
        if (inputScanner != null) {
            inputScanner.close();
        }
        if (printStream != null) {
            printStream.close();
        }
        if (fullInputFilePath != null) {
            try {
                org.apache.commons.io.FileUtils.forceDelete(new File(fullInputFilePath));
            }
            catch (Exception e) {
                logger.error("", e);
                FileUtils.closeLogger();
                PublicationsRetriever.executor.shutdownNow();
                System.exit(-11);
            }
        }
        FileUtils.closeLogger();
    }

    private static void closeLogger() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.stop();
    }

    public static Collection<String> getNextUrlBatchTest() {
        HashSet<String> urlGroup = new HashSet<String>(jsonBatchSize);
        int curBeginning = fileIndex;
        while (inputScanner.hasNextLine() && fileIndex < curBeginning + jsonBatchSize) {
            String retrievedLineStr = inputScanner.nextLine();
            if (++fileIndex == 1 && skipFirstRow) continue;
            if (retrievedLineStr.isEmpty()) {
                ++unretrievableInputLines;
                continue;
            }
            if (urlGroup.add(retrievedLineStr = Strings.CS.remove(retrievedLineStr, "\""))) continue;
            UrlUtils.addOutputData(null, retrievedLineStr, null, "duplicate", "Discarded in FileUtils.getNextUrlGroupTest(), as it is a duplicate.", "null", null, false, "false", "null", "null", "null", "true", null, "null", "null");
        }
        return urlGroup;
    }

    public static String printHexBinary(byte[] hashBytes) {
        StringBuilder hexString = new StringBuilder(hashBytes.length);
        for (byte b : hashBytes) {
            hexString.append(String.format("%02x", b));
        }
        return hexString.toString();
    }
}

