/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.publications_retriever.util.http;

import eu.openaire.publications_retriever.crawler.SpecialUrlsHandler;
import eu.openaire.publications_retriever.exceptions.AlreadyFoundDocUrlException;
import eu.openaire.publications_retriever.exceptions.ConnTimeoutException;
import eu.openaire.publications_retriever.exceptions.DomainBlockedException;
import eu.openaire.publications_retriever.exceptions.DomainWithUnsupportedHEADmethodException;
import eu.openaire.publications_retriever.exceptions.FileNotRetrievedException;
import eu.openaire.publications_retriever.models.IdUrlMimeTypeTriple;
import eu.openaire.publications_retriever.util.args.ArgsUtils;
import eu.openaire.publications_retriever.util.http.ConnSupportUtils;
import eu.openaire.publications_retriever.util.http.HttpClientUtils;
import eu.openaire.publications_retriever.util.url.LoaderAndChecker;
import eu.openaire.publications_retriever.util.url.UrlTypeChecker;
import eu.openaire.publications_retriever.util.url.UrlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpConnUtils.class);
    public static final Set<String> domainsWithUnsupportedHeadMethod = Collections.newSetFromMap(new ConcurrentHashMap());
    public static final Set<String> domainsWithUnsupportedAcceptLanguageParameter;
    public static final Set<String> domainsWithUnsupportedNewerHTTPVersion;
    public static final Set<String> blacklistedDomains;
    public static final ConcurrentHashMap<String, Integer> timesDomainsHadInputNotBeingDocNorPage;
    public static final ConcurrentHashMap<String, Integer> timesDomainsReturnedNoType;
    public static AtomicInteger numOfDomainsBlockedDueToSSLException;
    public static final Duration maxConnHEADWaitingTime;
    public static final Duration maxConnGETWaitingTime;
    private static final int maxRedirectsForPageUrls = 7;
    private static final int maxRedirectsForInternalLinks = 2;
    private static final int timesToHaveNoDocNorPageInputBeforeBlocked = 10;
    public static int maxAllowedFulltextContentSize;
    public static int maxAllowedHtmlContentSize;
    private static final boolean shouldNOTacceptGETmethodForUncategorizedInternalLinks = true;
    public static final Set<String> domainsSupportingHTTPS;
    public static final Set<String> domainsWithSlashRedirect;
    public static final Pattern ENDING_WITH_SLASH_OR_EXTENSION_FILTER;
    public static final Pattern PAGE_MIMETYPE_RULES;
    public static AtomicInteger timesDidOfflineHTTPSredirect;
    public static AtomicInteger timesDidOfflineSlashRedirect;
    public static ThreadLocal<Boolean> isSpecialUrl;
    public static final String docFileNotRetrievedMessage;

    /*
     * Exception decompiling
     */
    public static boolean connectAndCheckMimeType(String urlId, String sourceUrl, String pageUrl, String resourceURL, String domainStr, boolean calledForPageUrl, boolean calledForPossibleDocOrDatasetUrl) throws RuntimeException, ConnTimeoutException, DomainBlockedException, DomainWithUnsupportedHEADmethodException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static HttpResponse<InputStream> handleConnection(String urlId, String sourceUrl, String pageUrl, String resourceURL, String domainStr, boolean calledForPageUrl, boolean calledForPossibleDocUrl) throws AlreadyFoundDocUrlException, RuntimeException, ConnTimeoutException, DomainBlockedException, DomainWithUnsupportedHEADmethodException, IOException, InterruptedException {
        if (domainStr == null && (domainStr = UrlUtils.getDomainStr(resourceURL, null)) == null) {
            throw new RuntimeException("Unable to obtain the domain!");
        }
        HttpResponse<InputStream> response = HttpConnUtils.openHttpConnection(resourceURL, domainStr, calledForPageUrl, calledForPossibleDocUrl);
        int responseCode = response.statusCode();
        if (responseCode >= 300 && responseCode <= 399 && responseCode != 304) {
            response = HttpConnUtils.handleRedirects(urlId, sourceUrl, pageUrl, resourceURL, response, responseCode, domainStr, calledForPageUrl, calledForPossibleDocUrl);
        } else if (responseCode < 200 || responseCode >= 400) {
            String errorMessage = ConnSupportUtils.onErrorStatusCode(response.uri().toString(), domainStr, responseCode, calledForPageUrl, response);
            throw new RuntimeException(errorMessage);
        }
        return response;
    }

    public static HttpResponse<InputStream> openHttpConnection(String resourceURL, String domainStr, boolean calledForPageUrl, boolean calledForPossibleDocUrl) throws RuntimeException, ConnTimeoutException, DomainBlockedException, DomainWithUnsupportedHEADmethodException, IOException, InterruptedException {
        HttpResponse<InputStream> response;
        try {
            boolean useHttpGetMethod;
            String changedUrl;
            if (blacklistedDomains.contains(domainStr)) {
                throw new RuntimeException("Avoid connecting to blacklisted domain: \"" + domainStr + "\" with url: " + (String)resourceURL);
            }
            if (!calledForPageUrl && !calledForPossibleDocUrl && domainsWithUnsupportedHeadMethod.contains(domainStr)) {
                throw new DomainWithUnsupportedHEADmethodException();
            }
            if (ConnSupportUtils.checkIfPathIs403BlackListed((String)resourceURL, domainStr)) {
                throw new RuntimeException("Avoid reaching 403ErrorCode with url: \"" + (String)resourceURL + "\"!");
            }
            if (!((String)resourceURL).startsWith("https:", 0) && domainsSupportingHTTPS.contains(domainStr)) {
                resourceURL = Strings.CS.replace((String)resourceURL, "http:", "https:", 1);
                timesDidOfflineHTTPSredirect.incrementAndGet();
            }
            if (!ENDING_WITH_SLASH_OR_EXTENSION_FILTER.matcher((CharSequence)resourceURL).matches() && domainsWithSlashRedirect.contains(domainStr)) {
                resourceURL = (String)resourceURL + "/";
                timesDidOfflineSlashRedirect.incrementAndGet();
            }
            boolean weirdMetaDocUrlWhichNeedsGET = false;
            if (calledForPossibleDocUrl && ((String)resourceURL).contains("amp%3B")) {
                resourceURL = Strings.CS.replace((String)resourceURL, "amp%3B", "", -1);
                weirdMetaDocUrlWhichNeedsGET = true;
            }
            isSpecialUrl.set(false);
            if ((calledForPageUrl || calledForPossibleDocUrl) && !(changedUrl = SpecialUrlsHandler.checkAndHandleSpecialUrls((String)resourceURL)).equals(resourceURL)) {
                isSpecialUrl.set(true);
                resourceURL = changedUrl;
            }
            URL url = new URL((String)resourceURL);
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            resourceURL = uri.toASCIIString();
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(URI.create((String)resourceURL));
            ConnSupportUtils.setHttpHeaders(requestBuilder, domainStr);
            boolean bl = useHttpGetMethod = calledForPageUrl && !calledForPossibleDocUrl || calledForPossibleDocUrl && ArgsUtils.shouldDownloadDocFiles || weirdMetaDocUrlWhichNeedsGET || domainsWithUnsupportedHeadMethod.contains(domainStr) || domainStr.contains("meetingorganizer.copernicus.org");
            if (useHttpGetMethod) {
                requestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
                requestBuilder.timeout(maxConnGETWaitingTime);
            } else {
                requestBuilder.method("HEAD", HttpRequest.BodyPublishers.noBody());
                requestBuilder.timeout(maxConnHEADWaitingTime);
            }
            ConnSupportUtils.applyPolitenessDelay(domainStr);
            HttpClient client = HttpClientUtils.getHttpClient();
            boolean useHttp1_1 = domainsWithUnsupportedNewerHTTPVersion.contains(domainStr);
            HttpRequest request = useHttp1_1 ? requestBuilder.version(HttpClient.Version.HTTP_1_1).build() : requestBuilder.build();
            try {
                response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            }
            catch (ProtocolException pe) {
                String prohibitedUpgradeError = "Prohibited header name 'upgrade'";
                String exMsg = pe.getMessage();
                if (exMsg != null && exMsg.contains("Prohibited header name 'upgrade'")) {
                    logger.warn("Received 'Prohibited header name 'upgrade'' error for domain '" + domainStr + "'. Retrying with HTTP/1.1 for url: " + (String)resourceURL);
                    useHttp1_1 = true;
                    domainsWithUnsupportedNewerHTTPVersion.add(domainStr);
                    request = requestBuilder.version(HttpClient.Version.HTTP_1_1).build();
                    response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
                }
                throw pe;
            }
            int responseCode = response.statusCode();
            if (responseCode == 406) {
                logger.warn("The server \"" + domainStr + "\" probably does not support the \"Accept-Language\" parameter. Going to reconnect without it");
                domainsWithUnsupportedAcceptLanguageParameter.add(domainStr);
                requestBuilder = HttpRequest.newBuilder(URI.create((String)resourceURL));
                if (useHttp1_1) {
                    requestBuilder.version(HttpClient.Version.HTTP_1_1);
                }
                ConnSupportUtils.setHttpHeaders(requestBuilder, domainStr);
                if (useHttpGetMethod) {
                    requestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
                    requestBuilder.timeout(maxConnGETWaitingTime);
                } else {
                    requestBuilder.method("HEAD", HttpRequest.BodyPublishers.noBody());
                    requestBuilder.timeout(maxConnHEADWaitingTime);
                }
                ConnSupportUtils.applyPolitenessDelay(domainStr);
                request = requestBuilder.build();
                response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            } else if ((responseCode == 405 || responseCode == 501) && request.method().equals("HEAD")) {
                domainsWithUnsupportedHeadMethod.add(domainStr);
                if (!calledForPageUrl && !calledForPossibleDocUrl) {
                    throw new DomainWithUnsupportedHEADmethodException();
                }
                requestBuilder = HttpRequest.newBuilder(URI.create((String)resourceURL));
                if (useHttp1_1) {
                    requestBuilder.version(HttpClient.Version.HTTP_1_1);
                }
                ConnSupportUtils.setHttpHeaders(requestBuilder, domainStr);
                requestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
                requestBuilder.timeout(maxConnGETWaitingTime);
                ConnSupportUtils.applyPolitenessDelay(domainStr);
                request = requestBuilder.build();
                response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
                responseCode = response.statusCode();
                if (responseCode == 406) {
                    logger.warn("The server \"" + domainStr + "\" probably does not support the \"Accept-Language\" parameter. Going to reconnect without it");
                    domainsWithUnsupportedAcceptLanguageParameter.add(domainStr);
                    requestBuilder = HttpRequest.newBuilder(URI.create((String)resourceURL));
                    if (useHttp1_1) {
                        requestBuilder.version(HttpClient.Version.HTTP_1_1);
                    }
                    ConnSupportUtils.setHttpHeaders(requestBuilder, domainStr);
                    requestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
                    requestBuilder.timeout(maxConnGETWaitingTime);
                    ConnSupportUtils.applyPolitenessDelay(domainStr);
                    request = requestBuilder.build();
                    response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
                }
            }
        }
        catch (DomainWithUnsupportedHEADmethodException | RuntimeException redwuhme) {
            throw redwuhme;
        }
        catch (Exception e) {
            Exception exception = e;
            Objects.requireNonNull(exception);
            Exception exception2 = exception;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UnknownHostException.class, HttpTimeoutException.class, ConnectException.class, SSLException.class, SocketException.class}, (Exception)exception2, n)) {
                case 0: {
                    logger.warn("A new \"Unknown Network\" Host was found and blacklisted: \"" + domainStr + "\"");
                    blacklistedDomains.add(domainStr);
                    throw new DomainBlockedException(domainStr);
                }
                case 1: {
                    logger.warn("Url: \"" + (String)resourceURL + "\" failed to respond on time!");
                    ConnSupportUtils.onTimeoutException(domainStr);
                    throw new ConnTimeoutException();
                }
                case 2: {
                    String eMsg = e.getMessage();
                    if (eMsg != null && eMsg.toLowerCase().contains("timeout")) {
                        ConnSupportUtils.onTimeoutException(domainStr);
                        throw new ConnTimeoutException();
                    }
                    throw new RuntimeException(eMsg);
                }
                case 3: {
                    blacklistedDomains.add(domainStr);
                    numOfDomainsBlockedDueToSSLException.incrementAndGet();
                    logger.warn("No Secure connection was able to be negotiated with the domain: \"" + domainStr + "\", so it was blocked. Exception message: " + e.getMessage());
                    throw new DomainBlockedException(domainStr);
                }
                case 4: {
                    Object errorMsg = e.getMessage();
                    if (errorMsg != null) {
                        errorMsg = "\"" + (String)errorMsg + "\". This SocketException was received after trying to connect with the domain: \"" + domainStr + "\"";
                    }
                    throw new RuntimeException((String)errorMsg);
                }
            }
            String errorMsg = "Error when connecting with url: " + (String)resourceURL;
            logger.error(errorMsg, e);
            throw new RuntimeException(errorMsg + "\n" + e.getMessage());
        }
        return response;
    }

    public static HttpResponse<InputStream> handleRedirects(String urlId, String sourceUrl, String pageUrl, String internalLink, HttpResponse<InputStream> response, int responseCode, String domainStr, boolean calledForPageUrl, boolean calledForPossibleDocUrl) throws AlreadyFoundDocUrlException, RuntimeException, ConnTimeoutException, DomainBlockedException, DomainWithUnsupportedHEADmethodException, IOException, InterruptedException {
        String urlType;
        String initialUrl;
        int curRedirectsNum = 0;
        int maxRedirects = 0;
        if (calledForPageUrl) {
            maxRedirects = 7;
            initialUrl = sourceUrl;
            urlType = "pageUrl";
        } else {
            maxRedirects = 2;
            initialUrl = internalLink;
            urlType = "internalLink";
        }
        try {
            String targetDomainStr;
            String currentUrl;
            do {
                String targetUrl;
                if (++curRedirectsNum > maxRedirects) {
                    throw new RuntimeException("Redirects exceeded their limit (" + maxRedirects + ") for " + urlType + ": \"" + initialUrl + "\"");
                }
                URI currentUrlObject = response.uri();
                currentUrl = currentUrlObject.toString();
                String location = response.headers().firstValue("Location").orElse(null);
                if (location == null) {
                    if (responseCode == 300) {
                        location = ConnSupportUtils.getInternalLinkFromHTTP300Page(currentUrl, response);
                        if (location == null) {
                            throw new RuntimeException("No \"link\" was retrieved from the HTTP-300-page: \"" + currentUrl + "\".");
                        }
                    } else {
                        throw new RuntimeException("No \"Location\" field was found in the HTTP Header of \"" + currentUrl + "\", after receiving an \"HTTP " + responseCode + "\" Redirect Code.");
                    }
                }
                if ((targetUrl = ConnSupportUtils.getFullyFormedUrl(pageUrl, location, currentUrlObject.toURL())) == null) {
                    throw new RuntimeException("Could not create target url for resourceUrl: " + currentUrl + " having location: " + location);
                }
                String lowerCaseTargetUrl = targetUrl.toLowerCase();
                if (calledForPageUrl && UrlTypeChecker.shouldNotAcceptPageUrl(urlId, sourceUrl, targetUrl, lowerCaseTargetUrl, calledForPageUrl) || !calledForPageUrl && UrlTypeChecker.shouldNotAcceptInternalLink(targetUrl, lowerCaseTargetUrl)) {
                    throw new RuntimeException("Url: \"" + initialUrl + "\" was prevented to redirect to the unwanted location: \"" + targetUrl + "\", after receiving an \"HTTP " + responseCode + "\" Redirect Code, in redirection-number: " + curRedirectsNum + (calledForPageUrl ? " | __LOGGED__" : ""));
                }
                if (lowerCaseTargetUrl.contains("sharedsitesession")) {
                    logger.warn("Initial-url: \"" + initialUrl + "\" tried to cause a \"sharedSiteSession-redirectionPack\" by redirecting to \"" + targetUrl + "\"!");
                    List<String> blockedDomains = ConnSupportUtils.blockSharedSiteSessionDomains(targetUrl, currentUrl);
                    throw new DomainBlockedException(blockedDomains);
                }
                String tempTargetUrl = targetUrl;
                if ((targetUrl = LoaderAndChecker.basicURLNormalizer.filter(targetUrl)) == null) {
                    throw new RuntimeException("Could not normalize target url: " + tempTargetUrl);
                }
                IdUrlMimeTypeTriple originalIdUrlMimeTypeTriple = UrlUtils.resultUrlsWithIDs.get(targetUrl);
                if (originalIdUrlMimeTypeTriple != null) {
                    ConnSupportUtils.handleReCrossedTargetUrl(urlId, sourceUrl, pageUrl, targetUrl, originalIdUrlMimeTypeTriple, calledForPageUrl);
                    throw new AlreadyFoundDocUrlException();
                }
                targetDomainStr = UrlUtils.getDomainStr(targetUrl, null);
                if (targetDomainStr == null) {
                    throw new RuntimeException("Unable to obtain the domain!");
                }
                if (ConnSupportUtils.isJustAnHTTPSredirect(currentUrl, targetUrl)) {
                    domainsSupportingHTTPS.add(targetDomainStr);
                }
                if (ConnSupportUtils.isJustASlashRedirect(currentUrl, targetUrl)) {
                    domainsWithSlashRedirect.add(targetDomainStr);
                }
                try {
                    InputStream inputStream2 = response.body();
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                response = HttpConnUtils.openHttpConnection(targetUrl, targetDomainStr, calledForPageUrl, calledForPossibleDocUrl);
                responseCode = response.statusCode();
                if ((responseCode < 200 || responseCode > 299) && responseCode != 304) continue;
                return response;
            } while (responseCode >= 300 && responseCode <= 399);
            String errorMessage = ConnSupportUtils.onErrorStatusCode(currentUrl, targetDomainStr, responseCode, calledForPageUrl, response);
            throw new RuntimeException(errorMessage);
        }
        catch (AlreadyFoundDocUrlException | ConnTimeoutException | DomainBlockedException | DomainWithUnsupportedHEADmethodException | RuntimeException e) {
            if (response != null) {
                try {
                    InputStream inputStream3 = response.body();
                    if (inputStream3 != null) {
                        inputStream3.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
        catch (Exception e) {
            logger.warn("", e);
            if (response != null) {
                try {
                    InputStream inputStream4 = response.body();
                    if (inputStream4 != null) {
                        inputStream4.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    static {
        domainsWithUnsupportedHeadMethod.add("os.zhdk.cloud.switch.ch");
        domainsWithUnsupportedAcceptLanguageParameter = Collections.newSetFromMap(new ConcurrentHashMap());
        domainsWithUnsupportedNewerHTTPVersion = Collections.newSetFromMap(new ConcurrentHashMap());
        blacklistedDomains = Collections.newSetFromMap(new ConcurrentHashMap());
        timesDomainsHadInputNotBeingDocNorPage = new ConcurrentHashMap();
        timesDomainsReturnedNoType = new ConcurrentHashMap();
        numOfDomainsBlockedDueToSSLException = new AtomicInteger(0);
        maxConnHEADWaitingTime = Duration.ofSeconds(8L);
        maxConnGETWaitingTime = Duration.ofSeconds(15L);
        maxAllowedFulltextContentSize = 0x20000000;
        maxAllowedHtmlContentSize = 0x500000;
        domainsSupportingHTTPS = Collections.newSetFromMap(new ConcurrentHashMap());
        domainsWithSlashRedirect = Collections.newSetFromMap(new ConcurrentHashMap());
        ENDING_WITH_SLASH_OR_EXTENSION_FILTER = Pattern.compile(".*(?:(?:/|\\.[^.?&/_-]{1,7})(?:\\?.+)?|\\?.+)$");
        PAGE_MIMETYPE_RULES = Pattern.compile(".*(?:htm|text(?!.*(?:xls[xbm]?|xlt[x]?|[ct]sv|tab|(?:(?:geo)?j|b)son|(?:x|k|g|nmr|sb|wiley|y[a]?)ml|xsd|o[dt]s|ddi|rdf|[g]?zip|zipx|[rt]ar|[7x]z|[t]?gz|[gb]z[\\d]*|smi[l]?|por|ascii|dta|sav|dat|txt|ti[f]{1,2}|tfw|dwg|nt|fits|feather|svg|sas7b(?:dat|ve)|spss|sas|stata|(?:my|postgre)?sql(?:ite)?|bigquery|sh[px]|sb[xn]|prj|dbf|(?:m|acc)db|mif|mat|pcd|bt|n[sc]?[\\d]*|h[\\d]+|hdf[\\d]*|trs|opj|jcamp|fcs|fas(?:ta)?|keys|values|las|rdata|parquet|avro|sql|dcm|gr[i]?b]|rds|[p]?cap|dmp|vcf|cbor|biosample|hic|warc|ig[e]?s|sla|dxf|pdb|[sc]df|cif|f(?:ast)?[qa]|apng|sra|vtp|gltf|[sm]tl|ply|abc|md|rtf|ttl|shp|shx|exr|cdf|glb|mtl|kmz|textFile))).*");
        timesDidOfflineHTTPSredirect = new AtomicInteger(0);
        timesDidOfflineSlashRedirect = new AtomicInteger(0);
        isSpecialUrl = ThreadLocal.withInitial(() -> false);
        docFileNotRetrievedMessage = FileNotRetrievedException.class.getSimpleName() + " was thrown before the docFile could be stored. ";
    }
}

