package eu.dnetlib.index.feed;

/**
 * FeedResult helps verifying feeding operations
 *
 * @author claudio
 */
public class FeedResult {

	/**
	 * counter of added documents.
	 */
	private Integer added = null;

	/**
	 * counter of skipped documents
	 */
	private Integer skipped = null;

	/**
	 * counter of marked-for-deletion documents.
	 */
	private Integer marked = null;

	/**
	 * marks the start of feed process.
	 */
	private long timeStart;

	/**
	 * time elapsed to complete the feeding.
	 */
	private long timeElapsed;

	/**
	 * builds a new FeedResult
	 *
	 * @param timeStart the start time of feed process.
	 */
	public FeedResult(final long timeStart) {
		this.added = 0;
		this.skipped = 0;
		this.marked = 0;
		this.timeStart = timeElapsed = timeStart;
	}

	/**
	 * increments added counter.
	 */
	public void add() {
		added++;
	}

	/**
	 * increments marked counter.
	 */
	public void mark() {
		marked++;
	}

	/**
	 * increments skipped counter.
	 */
	public void skip() {
		skipped++;
	}

	public int getAdded() {
		return added;
	}

	public int getSkipped() {
		return skipped;
	}

	public int getMarked() {
		return marked;
	}

	/**
	 * method calculates the time elapsed since the feed process has started.
	 *
	 * @return the time elapsed since the feed process has started.
	 */
	public long getTime() {
		if (timeElapsed > 0) return timeElapsed - timeStart;
		return System.currentTimeMillis() - timeStart;
	}

	public FeedResult setTimeElapsed(final long timeElapsed) {
		this.timeElapsed = timeElapsed;
		return this;
	}

	@Override
	public String toString() {
		return "[added: " + getAdded() + " skipped: " + getSkipped() + " marked: " + getMarked() + " time: " + (getTime() / 1000) + " sec]";
	}

}
