package eu.dnetlib.oai.actions;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.oai.mongo.MongoPublisherStore;
import eu.dnetlib.oai.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.oai.utils.OAIParameterNames;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EnsureIndexesAction extends AbstractOAIStoreAction {

	private static final Log log = LogFactory.getLog(EnsureIndexesAction.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Autowired
	private MongoPublisherStoreDAO mongoPublisherStoreDAO;

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		try {
			String storeId = job.getParameters().get(OAIParameterNames.OAI_COLLECTON);
			String dbName = job.getParameters().get(OAIParameterNames.OAI_DB);
			if (StringUtils.isBlank(storeId)) {
				log.info("Ensuring index on all OAI store");
				this.mongoPublisherStoreDAO.ensureIndex(dbName);
			} else {
				log.info("Ensuring index on " + storeId + " only");
				MongoPublisherStore store = this.mongoPublisherStoreDAO.getStore(storeId, dbName);
				store.ensureIndices();
			}
			handler.done(job);
		} catch (final Exception e) {
			handler.failed(job, e);
		}
	}

	public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
		return this.mongoPublisherStoreDAO;
	}

	public void setMongoPublisherStoreDAO(final MongoPublisherStoreDAO mongoPublisherStoreDAO) {
		this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
	}

}
