/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.core;

import eu.dnetlib.oai.CannotDisseminateFormatException;
import eu.dnetlib.oai.conf.OAIConfigurationExistReader;
import eu.dnetlib.oai.info.ListDocumentsInfo;
import eu.dnetlib.oai.info.ListRecordsInfo;
import eu.dnetlib.oai.info.RecordInfo;
import eu.dnetlib.oai.info.ResumptionToken;
import eu.dnetlib.oai.info.SetInfo;
import eu.dnetlib.oai.sets.SetCollection;
import eu.dnetlib.oai.utils.OAIISLookUpClient;
import eu.dnetlib.rmi.provision.MDFInfo;
import eu.dnetlib.rmi.provision.OaiPublisherException;
import java.io.Serializable;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractOAICore {
    private static final Log log = LogFactory.getLog(AbstractOAICore.class);
    protected int pageSize = 100;
    private String currentDBName;
    @Autowired
    private SetCollection setCollection;
    @Autowired
    private OAIConfigurationExistReader oaiConfigurationExistReader;
    @Autowired
    private OAIISLookUpClient lookupClient;
    private Cache mdFormatsCache;

    public RecordInfo getInfoRecord(String identifier, String prefix) throws OaiPublisherException {
        MDFInfo mdf = this.obtainMDFInfo(prefix);
        return this.getRecordById(mdf, identifier);
    }

    public ListRecordsInfo listRecords(boolean onlyIdentifiers, String metadataPrefix, String set, String from, String until) throws OaiPublisherException {
        ListRecordsInfo res = new ListRecordsInfo();
        if (from != null) {
            res.setFrom(from);
            res.setWithSize(false);
        }
        if (until != null) {
            res.setUntil(until);
            res.setWithSize(false);
        }
        if (metadataPrefix != null) {
            res.setMetadataprefix(metadataPrefix);
        }
        if (set != null) {
            res.setSet(set);
        }
        ListDocumentsInfo documents = this.getDocuments(onlyIdentifiers, set, metadataPrefix, from, until);
        ResumptionToken resumptionToken = documents.getResumptionToken();
        int cursor = documents.getCursor();
        int nMaxElements = documents.getnMaxElements();
        if (onlyIdentifiers) {
            res.setIdentifiers(documents.getDocs());
        } else {
            res.setDocuments(documents.getDocs());
        }
        if (resumptionToken != null) {
            res.setResumptiontoken(resumptionToken.serialize());
            res.setCursor(cursor);
            res.setSize(nMaxElements);
        }
        return res;
    }

    public ListRecordsInfo listRecords(boolean onlyIdentifiers, String resumptionToken) throws OaiPublisherException {
        ListDocumentsInfo docs = this.getDocuments(onlyIdentifiers, resumptionToken);
        ListRecordsInfo res = new ListRecordsInfo();
        if (docs.getMetadataPrefix() != null) {
            res.setMetadataprefix(docs.getMetadataPrefix());
        }
        if (onlyIdentifiers) {
            res.setIdentifiers(docs.getDocs());
        } else {
            res.setDocuments(docs.getDocs());
        }
        ResumptionToken newResumptionToken = docs.getResumptionToken();
        if (newResumptionToken != null) {
            res.setResumptiontoken(newResumptionToken.serialize());
            res.setCursor(docs.getCursor());
            res.setSize(docs.getnMaxElements());
            res.setWithSize(!newResumptionToken.hasDateRange());
        }
        return res;
    }

    public List<? extends SetInfo> listSets() throws OaiPublisherException {
        return this.setCollection.getAllSets(true, this.getCurrentDBName());
    }

    public List<MDFInfo> listMetadataFormats() throws OaiPublisherException {
        return this.oaiConfigurationExistReader.getMetadataFormatInfo(true);
    }

    public boolean existSet(String setSpec) {
        return this.setCollection.containEnabledSet(setSpec, this.getCurrentDBName());
    }

    protected MDFInfo obtainMDFInfo(String metadataPrefix) throws OaiPublisherException {
        MDFInfo mdf = null;
        Element element = this.mdFormatsCache.get((Serializable)((Object)metadataPrefix));
        if (element == null) {
            log.fatal((Object)("Not using cache for " + metadataPrefix));
            mdf = this.oaiConfigurationExistReader.getMetadataFormatInfo(metadataPrefix);
            if (mdf == null) {
                throw new CannotDisseminateFormatException("Invalid metadataPrefix " + metadataPrefix);
            }
            this.mdFormatsCache.put(new Element((Object)metadataPrefix, (Object)mdf));
        } else {
            mdf = (MDFInfo)element.getObjectValue();
        }
        return mdf;
    }

    public void setCurrentDBFromIS() throws OaiPublisherException {
        try {
            this.currentDBName = this.getLookupClient().getCurrentDB();
        }
        catch (Exception e) {
            throw new OaiPublisherException((Throwable)e);
        }
    }

    protected abstract RecordInfo getRecordById(MDFInfo var1, String var2) throws OaiPublisherException;

    protected abstract ListDocumentsInfo getDocuments(boolean var1, String var2, String var3, String var4, String var5) throws OaiPublisherException;

    protected abstract ListDocumentsInfo getDocuments(boolean var1, String var2) throws OaiPublisherException;

    public String getCurrentDBName() {
        return this.currentDBName;
    }

    public void setCurrentDBName(String currentDBName) {
        this.currentDBName = currentDBName;
    }

    public SetCollection getSetCollection() {
        return this.setCollection;
    }

    public void setSetCollection(SetCollection setCollection) {
        this.setCollection = setCollection;
    }

    public OAIConfigurationExistReader getOaiConfigurationExistReader() {
        return this.oaiConfigurationExistReader;
    }

    public void setOaiConfigurationExistReader(OAIConfigurationExistReader oaiConfigurationExistReader) {
        this.oaiConfigurationExistReader = oaiConfigurationExistReader;
    }

    public OAIISLookUpClient getLookupClient() {
        return this.lookupClient;
    }

    public void setLookupClient(OAIISLookUpClient lookupClient) {
        this.lookupClient = lookupClient;
    }

    public Cache getMdFormatsCache() {
        return this.mdFormatsCache;
    }

    @Required
    public void setMdFormatsCache(Cache mdFormatsCache) {
        this.mdFormatsCache = mdFormatsCache;
    }
}

