package eu.dnetlib.oai;

import javax.annotation.Resource;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import eu.dnetlib.oai.mongo.MongoPublisherStore;
import eu.dnetlib.oai.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.oai.sets.OAISetsCounter;
import eu.dnetlib.oai.sync.OAIStoreSynchronizer;
import eu.dnetlib.oai.utils.OAIHelper;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.provision.MDFInfo;
import eu.dnetlib.rmi.provision.OAIStoreService;
import eu.dnetlib.utils.MetadataReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class OAIStoreServiceImpl extends AbstractBaseService implements OAIStoreService {

	/**
	 * notification handler.
	 */
	private NotificationHandler notificationHandler;

	@Autowired
	private MongoPublisherStoreDAO mongoPublisherStoreDAO;
	@Autowired
	private OAIStoreSynchronizer synchronizer;
	@Resource(name = "oaiSetsCounter")
	private OAISetsCounter setsCounter;
	@Autowired
	private OAIHelper oaiHelper;
	@Autowired
	private ResultSetClient resultSetClient;

	@Override
	public void feed(final ResultSet<String> recordsEpr, final MetadataReference mdfInfo, final String dbName) {
		this.feed(recordsEpr, mdfInfo, "", dbName);
	}

	@Override
	public void feed(final ResultSet<String> recordsEpr, final MetadataReference mdfInfo, final String recordSource, final String dbName) {
		final Iterable<String> iter = this.resultSetClient.iter(recordsEpr, String.class);
		this.synchronizer.synchronize(iter, mdfInfo, recordSource, dbName, false, null, null);
	}

	@Override
	public void updateSetCounts(final String dbName) {
		this.setsCounter.updateCounts("", dbName, null, null);
	}

	@Override
	public void updateSetCounts(final MDFInfo mdfInfo, final String dbName) {
		this.setsCounter.updateCounts(mdfInfo, dbName, null, null);
	}

	@Override
	public void refreshConfiguration(final String dbName) {
		this.oaiHelper.loadConfiguration(dbName);
	}

	@Override
	public void ensureIndexes(final String dbName) {
		this.mongoPublisherStoreDAO.ensureIndex(dbName);
	}

	@Override
	public void ensureIndexes(final MDFInfo mdfInfo, final String dbName) {
		final MongoPublisherStore s = this.mongoPublisherStoreDAO.getStore(mdfInfo.getSourceFormat(), mdfInfo.getSourceInterpretation(),
				mdfInfo.getSourceLayout(), dbName);
		s.ensureIndices();
	}

	@Override
	public void notify(final String subscriptionId, final String topic, final String isId, final String message) {
		getNotificationHandler().notified(subscriptionId, topic, isId, message);
	}

	public NotificationHandler getNotificationHandler() {
		return this.notificationHandler;
	}

	@Required
	public void setNotificationHandler(final NotificationHandler notificationHandler) {
		this.notificationHandler = notificationHandler;
	}

	public OAIStoreSynchronizer getSynchronizer() {
		return this.synchronizer;
	}

	public void setSynchronizer(final OAIStoreSynchronizer synchronizer) {
		this.synchronizer = synchronizer;
	}

	public OAISetsCounter getSetsCounter() {
		return this.setsCounter;
	}

	public void setSetsCounter(final OAISetsCounter setsCounter) {
		this.setsCounter = setsCounter;
	}

	public OAIHelper getOaiSetHelper() {
		return this.oaiHelper;
	}

	public void setOaiSetHelper(final OAIHelper oaiHelper) {
		this.oaiHelper = oaiHelper;
	}

	public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
		return this.mongoPublisherStoreDAO;
	}

	public void setMongoPublisherStoreDAO(final MongoPublisherStoreDAO mongoPublisherStoreDAO) {
		this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
	}

}
