package eu.dnetlib.oai.conf;

import java.util.*;
import java.util.stream.Collectors;

import com.google.common.base.Joiner;
import eu.dnetlib.oai.PublisherField;
import eu.dnetlib.oai.info.SetInfo;
import eu.dnetlib.rmi.provision.MDFInfo;
import eu.dnetlib.utils.MetadataReference;

/**
 * An instance of this class represents an OAI Configuration profile.
 *
 * @author alessia
 */
public class OAIConfiguration {

	/**
	 * Map for OAI sets. Keys: setSpec, values: SetInfo instances.
	 */
	private Map<String, SetInfo> setsMap;

	/**
	 * Map for metadata formats. Keys: metadata prefix, values: MDFInfo instances.
	 */
	private Map<String, MDFInfo> mdFormatsMap;

	private List<PublisherField> fields;

	private List<String> fieldNames;

	/**
	 * Used to generate the OAI identifiers compliant to the protocol. See
	 * http://www.openarchives.org/OAI/openarchivesprotocol.html#UniqueIdentifier. See property services.oai.publisher.id.scheme.
	 */
	private String idScheme;
	/**
	 * Used to generate the OAI identifiers compliant to the protocol. See
	 * http://www.openarchives.org/OAI/openarchivesprotocol.html#UniqueIdentifier. See property services.oai.publisher.id.namespace.
	 */
	private String idNamespace;

	private Set<MetadataReference> sourcesMDF = new HashSet<>();

	public Collection<PublisherField> getFieldsFor(final String format, final String layout, final String interpretation) {
		final String mdRef = Joiner.on("-").join(format, layout, interpretation);

		return this.getFields().stream().filter(theField -> {
			if (theField.getSources() == null) return false;
			return theField.getSources().containsKey(mdRef);
		}).collect(Collectors.toList());
	}

	public Map<String, SetInfo> getSetsMap() {
		return setsMap;
	}

	public void setSetsMap(final Map<String, SetInfo> setsMap) {
		this.setsMap = setsMap;
	}

	public Map<String, MDFInfo> getMdFormatsMap() {
		return mdFormatsMap;
	}

	public void setMdFormatsMap(final Map<String, MDFInfo> mdFormatsMap) {
		this.mdFormatsMap = mdFormatsMap;
	}

	public List<PublisherField> getFields() {
		return fields;
	}

	public void setFields(final List<PublisherField> fields) {
		this.fields = fields;
	}

	public List<String> getFieldNames() {
		return fieldNames;
	}

	public void setFieldNames(final List<String> fieldNames) {
		this.fieldNames = fieldNames;
	}

	public Set<MetadataReference> getSourcesMDF() {
		return sourcesMDF;
	}

	public void setSourcesMDF(final Set<MetadataReference> sourcesMDF) {
		this.sourcesMDF = sourcesMDF;
	}

	public String getIdScheme() {
		return idScheme;
	}

	public void setIdScheme(final String idScheme) {
		this.idScheme = idScheme;
	}

	public String getIdNamespace() {
		return idNamespace;
	}

	public void setIdNamespace(final String idNamespace) {
		this.idNamespace = idNamespace;
	}

}
