/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.action;

import eu.dnetlib.clients.index.utils.ServiceTools;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.index.feed.FeedMode;
import eu.dnetlib.rmi.provision.IndexServiceException;
import eu.dnetlib.utils.MetadataReference;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractIndexAction {
    @Autowired
    protected ServiceTools serviceTools;

    public String getServiceAddress(String backendId) {
        return this.serviceTools.getServiceAddress(backendId);
    }

    protected String getMDFormatFields(MetadataReference mdRef) {
        return this.serviceTools.getIndexFields(mdRef);
    }

    protected String getEpr(BlackboardJob job) {
        return (String)job.getParameters().get("resultset_epr");
    }

    protected String getIndexDSId(BlackboardJob job) {
        return (String)job.getParameters().get("id");
    }

    protected FeedMode getFeedMode(BlackboardJob job) {
        return FeedMode.valueOf((String)job.getParameters().get("feeding_type"));
    }

    protected MetadataReference getMetadataReference(String indexDSId) throws IndexServiceException {
        return this.serviceTools.getMetadataRef(indexDSId);
    }

    protected MetadataReference getMetadataReference(BlackboardJob job) {
        String format = (String)job.getParameters().get("format");
        String layout = (String)job.getParameters().get("layout");
        String interpretation = (String)job.getParameters().get("interpretation");
        return new MetadataReference(format, layout, interpretation);
    }

    protected String getBackend(BlackboardJob job) {
        return (String)job.getParameters().get("backend_Id");
    }

    protected String getQuery(BlackboardJob job) {
        return (String)job.getParameters().get("query");
    }
}

