/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.info;

import eu.dnetlib.oai.BadResumptionTokenException;
import eu.dnetlib.oai.info.ResumptionToken;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class ResumptionTokenImpl
implements ResumptionToken {
    private int nMaxElements;
    private String metadataPrefix;
    private String query;
    private int nRead;
    private String lastObjIdentifier;
    private String requestedSet = "";
    private boolean hasDateRange = false;

    @Override
    public String serialize() {
        String escapedQuery = StringEscapeUtils.escapeXml11((String)this.query);
        List<String> info = Arrays.asList("" + this.nMaxElements, this.metadataPrefix, escapedQuery, "" + this.nRead, this.lastObjIdentifier, "" + this.hasDateRange, this.requestedSet);
        return StringUtils.join(info, (String)"|");
    }

    @Override
    public void deserialize(String token) throws BadResumptionTokenException {
        String unescapedQuery;
        String[] info = token.split("\\|");
        if (info.length < 6) {
            throw new BadResumptionTokenException(token);
        }
        this.nMaxElements = Integer.parseInt(info[0]);
        this.metadataPrefix = info[1];
        this.query = unescapedQuery = StringEscapeUtils.unescapeXml((String)info[2]);
        this.nRead = Integer.parseInt(info[3]);
        this.lastObjIdentifier = info[4];
        this.hasDateRange = Boolean.valueOf(info[5]);
        if (info.length == 7) {
            this.requestedSet = info[6];
        }
    }

    @Override
    public int getnMaxElements() {
        return this.nMaxElements;
    }

    @Override
    public void setnMaxElements(int nMaxElements) {
        this.nMaxElements = nMaxElements;
    }

    @Override
    public String getMetadataPrefix() {
        return this.metadataPrefix;
    }

    @Override
    public void setMetadataPrefix(String metadataPrefix) {
        this.metadataPrefix = metadataPrefix;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public int getnRead() {
        return this.nRead;
    }

    @Override
    public void setnRead(int nRead) {
        this.nRead = nRead;
    }

    @Override
    public String getLastObjIdentifier() {
        return this.lastObjIdentifier;
    }

    @Override
    public void setLastObjIdentifier(String lastObjIdentifier) {
        this.lastObjIdentifier = lastObjIdentifier;
    }

    @Override
    public String getRequestedSet() {
        return this.requestedSet;
    }

    @Override
    public void setRequestedSet(String requestedSet) {
        this.requestedSet = requestedSet;
    }

    @Override
    public boolean hasDateRange() {
        return this.hasDateRange;
    }

    @Override
    public void setDateRange(boolean hasDateRange) {
        this.hasDateRange = hasDateRange;
    }

    public String toString() {
        return "ResumptionTokenImpl [nMaxElements=" + this.nMaxElements + ", metadataPrefix=" + this.metadataPrefix + ", query=" + this.query + ", nRead=" + this.nRead + ", lastObjIdentifier=" + this.lastObjIdentifier + ", hasDateRange=" + this.hasDateRange + ", requestedSet=" + this.requestedSet + "]";
    }
}

