/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.mongo;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import eu.dnetlib.cql.CqlTranslator;
import eu.dnetlib.enabling.tools.DnetStreamSupport;
import eu.dnetlib.oai.PublisherStoreDAO;
import eu.dnetlib.oai.RecordChangeDetector;
import eu.dnetlib.oai.conf.OAIConfigurationReader;
import eu.dnetlib.oai.mongo.DNetOAIMongoCursor;
import eu.dnetlib.oai.mongo.MetadataExtractor;
import eu.dnetlib.oai.mongo.MongoPublisherStore;
import eu.dnetlib.oai.mongo.RecordInfoGenerator;
import eu.dnetlib.oai.sets.MongoSetCollection;
import eu.dnetlib.rmi.provision.MDFInfo;
import eu.dnetlib.rmi.provision.OaiPublisherException;
import eu.dnetlib.rmi.provision.OaiPublisherRuntimeException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class MongoPublisherStoreDAO
implements PublisherStoreDAO<MongoPublisherStore, DNetOAIMongoCursor> {
    private static final Log log = LogFactory.getLog(MongoPublisherStoreDAO.class);
    @Autowired
    private MongoClient publisherMongoClient;
    private String metadataCollection;
    @Autowired
    private RecordInfoGenerator recordInfoGenerator;
    @Autowired
    private MetadataExtractor metadataExtractor;
    @Autowired
    private CqlTranslator cqlTranslator;
    @Resource(name="oaiConfigurationExistReader")
    private OAIConfigurationReader configuration;
    @Autowired
    private RecordChangeDetector recordChangeDetector;
    @Autowired
    private MongoSetCollection mongoSetCollection;
    private Cache mongoOaistoreCache;
    private Cache mongoOaistoreCacheByMdPrefix;
    private boolean alwaysNewRecord;

    protected MongoDatabase getDB(String dbName) {
        return this.publisherMongoClient.getDatabase(dbName);
    }

    @Override
    public List<MongoPublisherStore> listPublisherStores(String dbName) {
        MongoDatabase db = this.getDB(dbName);
        FindIterable stores = db.getCollection(this.metadataCollection, DBObject.class).find();
        return DnetStreamSupport.generateStreamFromIterator((Iterator)stores.iterator()).map(storeInfo -> this.createFromDBObject((DBObject)storeInfo, db)).collect(Collectors.toList());
    }

    @Override
    public MongoPublisherStore getStore(String storeId, String dbName) {
        DBObject storeInfo = (DBObject)this.getDB(dbName).getCollection(this.metadataCollection, DBObject.class).find(Filters.eq((String)"id", (Object)storeId)).first();
        return this.createFromDBObject(storeInfo, this.getDB(dbName));
    }

    @Override
    public MongoPublisherStore getStore(String mdfName, String mdfInterpretation, String mdfLayout, String dbName) {
        return this.getStore(this.generateStoreId(mdfName, mdfInterpretation, mdfLayout), dbName);
    }

    @Override
    public MongoPublisherStore getStoreFor(String targetMetadataPrefix, String dbName) {
        Element elem = this.mongoOaistoreCacheByMdPrefix.get((Serializable)((Object)targetMetadataPrefix));
        if (elem != null) {
            return (MongoPublisherStore)elem.getObjectValue();
        }
        MDFInfo info = this.configuration.getMetadataFormatInfo(targetMetadataPrefix);
        MongoPublisherStore store = this.getStore(info.getSourceFormat(), info.getSourceInterpretation(), info.getSourceLayout(), dbName);
        this.mongoOaistoreCacheByMdPrefix.put(new Element((Object)targetMetadataPrefix, (Object)store));
        return store;
    }

    @Override
    public MongoPublisherStore createStore(String mdfName, String mdfInterpretation, String mdfLayout, String dbName) throws OaiPublisherException {
        MongoDatabase db = this.getDB(dbName);
        DBObject store = this.createMetadataEntry(mdfName, mdfInterpretation, mdfLayout);
        MongoCollection metadata = db.getCollection(this.metadataCollection, DBObject.class);
        metadata.insertOne((Object)store);
        MongoPublisherStore theStore = this.createFromDBObject(store, db);
        return theStore;
    }

    @Override
    public boolean deleteStore(String storeId, String dbName) {
        MongoDatabase db = this.getDB(dbName);
        MongoCollection metadata = db.getCollection(this.metadataCollection, DBObject.class);
        DBObject storeDeleted = (DBObject)metadata.findOneAndDelete(Filters.eq((String)"id", (Object)storeId));
        if (storeDeleted == null) {
            return false;
        }
        db.getCollection(storeId).drop();
        this.mongoSetCollection.dropOAISets(dbName);
        log.debug((Object)("Deleted oaistore " + storeId + ", db: " + dbName));
        return true;
    }

    @Override
    public boolean deleteFromStore(String storeId, String dbName, String set) {
        MongoDatabase db = this.getDB(dbName);
        MongoCollection metadata = db.getCollection(this.metadataCollection, DBObject.class);
        DBObject storeInfo = (DBObject)metadata.find(Filters.eq((String)"id", (Object)storeId)).first();
        if (storeInfo == null) {
            return false;
        }
        db.getCollection(storeId).deleteMany(Filters.eq((String)"set", (Object)this.mongoSetCollection.normalizeSetSpec(set)));
        this.mongoSetCollection.dropSet(dbName, set);
        log.debug((Object)("Deleted set " + set + " from oaistore " + storeId + ", db: " + dbName));
        return true;
    }

    @Override
    public boolean deleteFromStore(String mdfName, String mdfInterpretation, String mdfLayout, String dbName, String set) {
        return this.deleteFromStore(this.generateStoreId(mdfName, mdfInterpretation, mdfLayout), dbName, set);
    }

    @Override
    public boolean deleteStore(String mdfName, String mdfInterpretation, String mdfLayout, String dbName) {
        return this.deleteStore(this.generateStoreId(mdfName, mdfInterpretation, mdfLayout), dbName);
    }

    public void ensureIndex(final MongoPublisherStore store) {
        if (store == null) {
            throw new OaiPublisherRuntimeException("Can't ensure index on null store");
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                store.ensureIndices();
            }
        };
        t.start();
    }

    public void ensureIndex(String dbName) {
        List<MongoPublisherStore> stores = this.listPublisherStores(dbName);
        for (MongoPublisherStore s : stores) {
            s.ensureIndices();
        }
    }

    private MongoPublisherStore createFromDBObject(DBObject storeInfo, MongoDatabase db) {
        if (storeInfo == null) {
            return null;
        }
        String storeId = (String)storeInfo.get("id");
        String mdFormat = (String)storeInfo.get("metadataFormat");
        String mdInterpreation = (String)storeInfo.get("interpretation");
        String mdLayout = (String)storeInfo.get("layout");
        String k = db.getName() + "-" + storeId;
        Element elem = this.mongoOaistoreCache.get((Serializable)((Object)k));
        if (elem != null) {
            log.debug((Object)("Store retrieved from cache and alwaysNewRecord is" + this.alwaysNewRecord));
            MongoPublisherStore store = (MongoPublisherStore)elem.getObjectValue();
            store.setAlwaysNewRecord(this.alwaysNewRecord);
            log.debug((Object)store);
            return store;
        }
        log.debug((Object)("Store retrieved, cache miss,  alwaysNewRecord is" + this.alwaysNewRecord));
        log.fatal((Object)("Not using cache to create oaistore from dbObject: " + k));
        MongoPublisherStore store = new MongoPublisherStore(storeId, mdFormat, mdInterpreation, mdLayout, (MongoCollection<DBObject>)db.getCollection(storeId, DBObject.class), this.configuration.getFields(mdFormat, mdInterpreation, mdLayout), this.cqlTranslator, this.recordInfoGenerator, this.configuration.getIdScheme(), this.configuration.getIdNamespace(), this.metadataExtractor, this.recordChangeDetector, this.alwaysNewRecord, db);
        store.setMongoSetCollection(this.mongoSetCollection);
        this.mongoOaistoreCache.put(new Element((Object)k, (Object)store));
        return store;
    }

    private DBObject createMetadataEntry(String mdfName, String mdfInterpretation, String mdfLayout) {
        DBObject info = BasicDBObjectBuilder.start((String)"id", (Object)this.generateStoreId(mdfName, mdfInterpretation, mdfLayout)).append("metadataFormat", (Object)mdfName).append("interpretation", (Object)mdfInterpretation).append("layout", (Object)mdfLayout).get();
        return info;
    }

    private String generateStoreId(String mdfName, String mdfInterpretation, String mdfLayout) {
        return mdfName + "-" + mdfLayout + "-" + mdfInterpretation;
    }

    public String getMetadataCollection() {
        return this.metadataCollection;
    }

    @Required
    public void setMetadataCollection(String metadataCollection) {
        this.metadataCollection = metadataCollection;
    }

    public OAIConfigurationReader getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OAIConfigurationReader configuration) {
        this.configuration = configuration;
    }

    public RecordInfoGenerator getRecordInfoGenerator() {
        return this.recordInfoGenerator;
    }

    public void setRecordInfoGenerator(RecordInfoGenerator recordInfoGenerator) {
        this.recordInfoGenerator = recordInfoGenerator;
    }

    public MetadataExtractor getMetadataExtractor() {
        return this.metadataExtractor;
    }

    public void setMetadataExtractor(MetadataExtractor metadataExtractor) {
        this.metadataExtractor = metadataExtractor;
    }

    public RecordChangeDetector getRecordChangeDetector() {
        return this.recordChangeDetector;
    }

    public void setRecordChangeDetector(RecordChangeDetector recordChangeDetector) {
        this.recordChangeDetector = recordChangeDetector;
    }

    public MongoSetCollection getMongoSetCollection() {
        return this.mongoSetCollection;
    }

    public void setMongoSetCollection(MongoSetCollection mongoSetCollection) {
        this.mongoSetCollection = mongoSetCollection;
    }

    public boolean isAlwaysNewRecord() {
        return this.alwaysNewRecord;
    }

    public void setAlwaysNewRecord(boolean alwaysNewRecord) {
        this.alwaysNewRecord = alwaysNewRecord;
    }

    public Cache getMongoOaistoreCache() {
        return this.mongoOaistoreCache;
    }

    @Required
    public void setMongoOaistoreCache(Cache mongoOaistoreCache) {
        this.mongoOaistoreCache = mongoOaistoreCache;
    }

    public Cache getMongoOaistoreCacheByMdPrefix() {
        return this.mongoOaistoreCacheByMdPrefix;
    }

    @Required
    public void setMongoOaistoreCacheByMdPrefix(Cache mongoOaistoreCacheByMdPrefix) {
        this.mongoOaistoreCacheByMdPrefix = mongoOaistoreCacheByMdPrefix;
    }

    public CqlTranslator getCqlTranslator() {
        return this.cqlTranslator;
    }

    public void setCqlTranslator(CqlTranslator cqlTranslator) {
        this.cqlTranslator = cqlTranslator;
    }
}

