package eu.dnetlib.index.actors;

import java.util.Map;

import com.google.common.collect.Maps;
import eu.dnetlib.rmi.provision.IndexServiceException;

// TODO: Auto-generated Javadoc

/**
 * The Class ActorMap.
 */
public class ActorMap {

	/**
	 * Map of Index actors.
	 */
	private transient Map<String, IndexFeedActor> actorMap = Maps.newConcurrentMap();

	/**
	 * Checks for actor.
	 *
	 * @param backendId the backend Identifier
	 * @return true, if successful
	 */
	public boolean hasActor(final String backendId) {
		return actorMap.containsKey(backendId);
	}

	/**
	 * Gets the actor.
	 *
	 * @param backendId the backend Identifier
	 * @return the actor
	 * @throws IndexServiceException the index service exception
	 */
	public IndexFeedActor getActor(final String backendId) throws IndexServiceException {
		if (!hasActor(backendId)) throw new IndexServiceException("Actor not found for protocol ID " + backendId);
		return actorMap.get(backendId);
	}

	/**
	 * Adds the actor.
	 *
	 * @param backendId the backend Identifier
	 * @param actor     the actor
	 */
	public void addActor(final String backendId, final IndexFeedActor actor) {
		actorMap.put(backendId, actor);
	}

}
