package eu.dnetlib.index.query;

import eu.dnetlib.clients.index.client.IndexClientException;
import eu.dnetlib.clients.index.query.IndexQueryResponse;
import eu.dnetlib.clients.index.query.QueryResponseFactory;
import eu.dnetlib.clients.index.query.QueryResponseParser;
import eu.dnetlib.utils.MetadataReference;
import org.apache.solr.client.solrj.response.QueryResponse;

/**
 * The Class SolrIndexQueryResponseFactory.
 */
public class SolrIndexQueryResponseFactory extends QueryResponseFactory<QueryResponse> {

	/**
	 * {@inheritDoc}
	 *
	 * @throws IndexClientException
	 */
	@Override
	public QueryResponseParser getQueryResponseParser(final IndexQueryResponse<QueryResponse> queryRsp, final MetadataReference mdRef)
			throws IndexClientException {

		QueryResponse response = queryRsp.getContextualQueryResponse();
		return new SolrResponseParser(highlightUtils, browseAliases.get(mdRef), returnEmptyFields, includeRanking, response);
	}

}
