/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.query;

import eu.dnetlib.clients.index.query.IndexQuery;
import eu.dnetlib.cql.lucene.QueryOptions;
import eu.dnetlib.cql.lucene.TranslatedQuery;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class SolrIndexQuery
extends SolrQuery
implements IndexQuery {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SolrIndexQuery.class);

    public SolrIndexQuery(TranslatedQuery query, Map<String, List<String>> options) {
        this(query.asLucene(), options);
        this.setCqlParams(query.getOptions());
        log.debug((Object)("internal solr query: " + this.toString()));
    }

    public SolrIndexQuery(String query, Map<String, List<String>> options) {
        this(query);
        super.add(this.getQueryParams(options));
    }

    public SolrIndexQuery(String query) {
        super(query);
    }

    public IndexQuery setQueryOffset(int offset) {
        super.setStart(Integer.valueOf(offset));
        return this;
    }

    public IndexQuery setQueryLimit(int limit) {
        super.setRows(Integer.valueOf(limit));
        return this;
    }

    public IndexQuery setQueryFacetLimit(int limit) {
        super.setFacetLimit(limit);
        return this;
    }

    public IndexQuery setQueryFacetOffset(int offset) {
        super.set("facet.offset", offset);
        return this;
    }

    public IndexQuery setDSIdFilters(List<String> dsIds) {
        if (!this.isAll(dsIds)) {
            for (String id : dsIds) {
                this.addFilterQuery(new String[]{"__dsid:\"" + id + "\""});
            }
        }
        return this;
    }

    protected boolean isAll(List<String> dsIds) {
        return dsIds != null && !dsIds.isEmpty() && dsIds.size() == 1 && dsIds.get(0).equalsIgnoreCase("ALL");
    }

    private SolrParams getQueryParams(Map<String, List<String>> options) {
        ModifiableSolrParams params = new ModifiableSolrParams();
        String[] typeTag = new String[]{};
        for (Map.Entry<String, List<String>> entry : options.entrySet()) {
            params.add(entry.getKey(), entry.getValue().toArray(typeTag));
        }
        return params;
    }

    private void setCqlParams(QueryOptions options) {
        if (options != null && options.getSort() != null) {
            super.addSort(options.getSort().getField(), SolrQuery.ORDER.valueOf((String)options.getSort().getMode().name()));
        }
    }
}

