/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.core;

import eu.dnetlib.oai.BadResumptionTokenException;
import eu.dnetlib.oai.Cursor;
import eu.dnetlib.oai.NoRecordsMatchException;
import eu.dnetlib.oai.OAIError;
import eu.dnetlib.oai.PublisherStore;
import eu.dnetlib.oai.PublisherStoreDAO;
import eu.dnetlib.oai.core.AbstractOAICore;
import eu.dnetlib.oai.info.ListDocumentsInfo;
import eu.dnetlib.oai.info.RecordInfo;
import eu.dnetlib.oai.info.ResumptionTokenImpl;
import eu.dnetlib.rmi.provision.MDFInfo;
import eu.dnetlib.rmi.provision.OaiPublisherException;
import eu.dnetlib.rmi.provision.OaiPublisherRuntimeException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DNetOAICore
extends AbstractOAICore {
    private static final Log log = LogFactory.getLog(DNetOAICore.class);
    @Resource(name="mongodbPublisherStoreDao")
    private PublisherStoreDAO<PublisherStore<Cursor>, Cursor> publisherStoreDAO;
    private String defaultDate = "2008-01-01T12:00:00Z";

    @Override
    protected RecordInfo getRecordById(MDFInfo mdf, String id) throws OaiPublisherException {
        PublisherStore<Cursor> store = this.publisherStoreDAO.getStoreFor(mdf.getPrefix(), this.getCurrentDBName());
        if (store == null) {
            throw new OaiPublisherRuntimeException("Missing store for metadata prefix " + mdf.getPrefix() + ". Please check OAI publisher configuration.");
        }
        RecordInfo record = null;
        if (StringUtils.isBlank((CharSequence)mdf.getTransformationRuleID())) {
            record = store.getRecord(id);
        } else {
            Function<String, String> function = this.getLookupClient().getUnaryFunctionFromTDSRule(mdf.getTransformationRuleID());
            record = store.getRecord(id, function);
        }
        if (record != null) {
            record.setPrefix(mdf.getPrefix());
        }
        return record;
    }

    @Override
    protected ListDocumentsInfo getDocuments(boolean onlyIdentifiers, String set, String metadataPrefix, String from, String until) throws OaiPublisherException {
        MDFInfo mdf = this.obtainMDFInfo(metadataPrefix);
        boolean hasDateRange = StringUtils.isNotBlank((CharSequence)from) || StringUtils.isNotBlank((CharSequence)until);
        String query = this.generateQuery(mdf, set, from, until, hasDateRange);
        int total = this.countTotal(hasDateRange, query, set, mdf);
        log.debug((Object)("Total number of records: " + total));
        Cursor results = this.getCursor(query, onlyIdentifiers, mdf);
        ListDocumentsInfo res = this.prepareListDocumentsInfo(results, mdf, query, set, 0, total, hasDateRange);
        log.debug((Object)("Delivering " + res.getDocs().size() + " in a page"));
        return res;
    }

    @Override
    protected ListDocumentsInfo getDocuments(boolean onlyIdentifiers, String resumptionToken) throws OaiPublisherException {
        ResumptionTokenImpl resToken = new ResumptionTokenImpl();
        resToken.deserialize(resumptionToken);
        log.debug((Object)resToken.toString());
        MDFInfo mdf = this.obtainMDFInfo(resToken.getMetadataPrefix());
        String lastID = resToken.getLastObjIdentifier();
        String query = resToken.getQuery();
        String newQuery = "";
        if (StringUtils.isNotBlank((CharSequence)query)) {
            newQuery = query + " AND ";
        }
        newQuery = newQuery + " _id > \"" + lastID + "\"";
        log.debug((Object)("NEW QUERY BECAUSE of resumptionToken: " + newQuery));
        int total = this.countTotal(resToken.hasDateRange(), query, resToken.getRequestedSet(), mdf);
        Cursor results = this.getCursor(newQuery, onlyIdentifiers, mdf);
        int oldCount = resToken.getnMaxElements();
        if (total != -1 && oldCount != total) {
            throw new BadResumptionTokenException(resumptionToken);
        }
        ListDocumentsInfo res = this.prepareListDocumentsInfo(results, mdf, query, resToken.getRequestedSet(), resToken.getnRead(), resToken.getnMaxElements(), resToken.hasDateRange());
        res.setCursor(resToken.getnRead());
        return res;
    }

    protected ListDocumentsInfo prepareListDocumentsInfo(Cursor results, MDFInfo mdf, String query, String requestedSet, int read, int totalNumber, boolean hasDateRange) throws OaiPublisherException {
        ListDocumentsInfo documentList = new ListDocumentsInfo();
        documentList.setnMaxElements(totalNumber);
        documentList.setMetadataPrefix(mdf.getPrefix());
        documentList.setCursor(0);
        if (documentList.getnMaxElements() == 0) {
            throw new NoRecordsMatchException(OAIError.noRecordsMatch.getMessage());
        }
        List<RecordInfo> theRecords = this.generateOAIRecords(mdf, requestedSet, results);
        documentList.setDocs(theRecords);
        if (theRecords == null || theRecords.isEmpty()) {
            throw new NoRecordsMatchException("noRecordsMatch: 'documents' is null or empty");
        }
        if (documentList.getnMaxElements() > read + theRecords.size() || documentList.getnMaxElements() == -1) {
            String lastID = theRecords.get(theRecords.size() - 1).getInternalId();
            ResumptionTokenImpl nextToken = new ResumptionTokenImpl();
            nextToken.setDateRange(hasDateRange);
            nextToken.setLastObjIdentifier(lastID);
            nextToken.setMetadataPrefix(mdf.getPrefix());
            nextToken.setnMaxElements(totalNumber);
            nextToken.setnRead(read + theRecords.size());
            nextToken.setQuery(query);
            nextToken.setRequestedSet(requestedSet);
            documentList.setResumptionToken(nextToken);
        }
        return documentList;
    }

    protected Cursor getCursor(String query, boolean onlyIdentifiers, MDFInfo mdfInfo) {
        PublisherStore<Cursor> store = this.publisherStoreDAO.getStore(mdfInfo.getSourceFormat(), mdfInfo.getSourceInterpretation(), mdfInfo.getSourceLayout(), this.getCurrentDBName());
        if (store == null) {
            throw new OaiPublisherRuntimeException("Missing store for metadata prefix " + mdfInfo.getPrefix() + ". Please check OAI publisher configuration.");
        }
        Cursor results = null;
        if (StringUtils.isBlank((CharSequence)mdfInfo.getTransformationRuleID())) {
            results = store.getRecords(query, !onlyIdentifiers, this.pageSize);
        } else {
            Function<String, String> function = this.getLookupClient().getUnaryFunctionFromTDSRule(mdfInfo.getTransformationRuleID());
            results = store.getRecords(query, function, !onlyIdentifiers, this.pageSize);
        }
        return results;
    }

    protected List<RecordInfo> generateOAIRecords(MDFInfo mdf, String requestedSet, Cursor cursor) {
        ArrayList<RecordInfo> documents = new ArrayList<RecordInfo>();
        for (RecordInfo current : cursor) {
            current.addSetspec(requestedSet);
            current.setPrefix(mdf.getPrefix());
            documents.add(current);
        }
        return documents;
    }

    protected String generateQuery(MDFInfo mdf, String set, String from, String until, boolean hasDateRange) {
        String datestampIndexName = "datestamp";
        String query = mdf.getBaseQuery();
        if (!StringUtils.isBlank((CharSequence)set)) {
            if (!StringUtils.isBlank((CharSequence)query)) {
                query = query + " AND ";
            }
            query = query + this.getSetCollection().getSetQuery(set, this.getCurrentDBName());
        }
        if (hasDateRange) {
            if (!StringUtils.isBlank((CharSequence)query)) {
                query = query + " AND ";
            }
            if (from != null && until != null) {
                query = query + "datestamp >= " + from + " AND " + "datestamp" + " <= " + until;
            } else if (from != null) {
                query = query + "datestamp >= " + from;
            } else if (until != null) {
                query = query + "datestamp <= " + until;
            }
        }
        log.info((Object)("QUERY GENERATED: \n" + query));
        return query;
    }

    private int countTotal(boolean hasDateRange, String query, String set, MDFInfo mdFormat) {
        int total = 0;
        if (hasDateRange) {
            total = -1;
        } else {
            String theSet = set;
            if (StringUtils.isBlank((CharSequence)set)) {
                theSet = "ALL";
            }
            log.debug((Object)("SET::: " + theSet));
            total = this.getSetCollection().count(theSet, mdFormat.getPrefix(), this.getCurrentDBName());
        }
        return total;
    }

    public String getDefaultDate() {
        return this.defaultDate;
    }

    public void setDefaultDate(String defaultDate) {
        this.defaultDate = defaultDate;
    }

    public PublisherStoreDAO<PublisherStore<Cursor>, Cursor> getPublisherStoreDAO() {
        return this.publisherStoreDAO;
    }

    public void setPublisherStoreDAO(PublisherStoreDAO<PublisherStore<Cursor>, Cursor> publisherStoreDAO) {
        this.publisherStoreDAO = publisherStoreDAO;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

