/*
 *
 */
package eu.dnetlib.index;

import java.util.Map;

import eu.dnetlib.clients.index.model.Any.ValueType;
import eu.dnetlib.clients.index.query.IndexQueryFactory;
import eu.dnetlib.utils.MetadataReference;
import eu.dnetlib.cql.CqlValueTransformerMap;
import eu.dnetlib.index.feed.DocumentMapperFactory;
import eu.dnetlib.rmi.provision.IndexServiceException;
import org.dom4j.Document;

/**
 * The Interface IndexServerDAO.
 */
public interface IndexServerDAO extends IndexBackendDescriptor {

	/**
	 * Creates the index collection.
	 *
	 * @param mdref  the mdref
	 * @param fields the fields
	 * @return the index collection
	 * @throws IndexServiceException the index service exception
	 */
	void createIndexCollection(final MetadataReference mdref, final String fields) throws IndexServiceException;

	/**
	 * Update index collection.
	 *
	 * @param mdRef  the md ref
	 * @param fields the fields
	 * @throws IndexServiceException the index service exception
	 */
	void updateIndexCollection(final MetadataReference mdRef, final Document fields) throws IndexServiceException;

	/**
	 * Gets the index collection.
	 *
	 * @param mdRef the md ref
	 * @return the index collection
	 * @throws IndexServiceException the index service exception
	 */
	IndexCollection getIndexCollection(final MetadataReference mdRef) throws IndexServiceException;

	/**
	 * Gets the schema.
	 *
	 * @param mdRef the md ref
	 * @return the schema
	 * @throws IndexServiceException the index service exception
	 */
	Map<String, ValueType> getSchema(final MetadataReference mdRef) throws IndexServiceException;

	/**
	 * Gets the cql value transformer map.
	 *
	 * @param mdRef the md ref
	 * @return the cql value transformer map
	 * @throws IndexServiceException the index service exception
	 */
	CqlValueTransformerMap getCqlValueTransformerMap(final MetadataReference mdRef) throws IndexServiceException;

	/**
	 * Gets the document mapper factory.
	 *
	 * @return the document mapper factory
	 * @throws IndexServiceException the index service exception
	 */
	DocumentMapperFactory getDocumentMapperFactory() throws IndexServiceException;

	/**
	 * Gets the index query factory.
	 *
	 * @return the index query factory
	 */
	IndexQueryFactory getIndexQueryFactory();

	/**
	 * Shutdown the index server.
	 *
	 * @param mdRef the md ref
	 * @throws IndexServiceException the index service exception
	 */
	void shutdown(final MetadataReference mdRef) throws IndexServiceException;

}
