/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.query;

import com.google.common.collect.BiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.clients.index.query.QueryResponseParser;
import eu.dnetlib.rmi.provision.BrowsingRow;
import eu.dnetlib.rmi.provision.GroupResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;

public class SolrResponseParser
extends QueryResponseParser {
    private static final Log log = LogFactory.getLog(SolrResponseParser.class);
    protected final Function<SolrDocument, String> wrapperRank = doc -> this.addRanking(this.getSingleField((SolrDocument)doc, "__result"), this.getSingleField((SolrDocument)doc, "score"));
    protected final Function<SolrDocument, String> wrapperNoRank = doc -> this.wrap(this.getSingleField((SolrDocument)doc, "__result"));
    private QueryResponse queryRsp = null;

    public SolrResponseParser(Function<String, String> highlightUtils, BiMap<String, String> aliases, boolean returnEmptyFields, boolean includeRanking, QueryResponse response) {
        super(highlightUtils, aliases, returnEmptyFields, includeRanking);
        this.queryRsp = response;
    }

    public long getNumFound() {
        return this.queryRsp.getResults().getNumFound();
    }

    public int getQueryTime() {
        return this.queryRsp.getQTime();
    }

    public long getElapsedTime() {
        return this.queryRsp.getElapsedTime();
    }

    public String getStatus() {
        return String.valueOf(this.queryRsp.getStatus());
    }

    public int getCurrentSize() {
        return this.queryRsp.getResults().size();
    }

    public QueryResponse getQueryResponse() {
        return this.queryRsp;
    }

    public List<String> getResults() {
        return this.asRankedList(this.queryRsp.getResults());
    }

    public Long getNumberOfBrowsingResults() {
        List ffList = this.queryRsp.getFacetFields();
        Long maxCount = 0L;
        if (ffList != null) {
            for (FacetField ff : ffList) {
                Long countFacets;
                if (ff == null || (countFacets = this.countFacets(ff.getValues())) <= maxCount) continue;
                maxCount = countFacets;
            }
        }
        return maxCount;
    }

    public List<BrowsingRow> getBrowsingResults() {
        ArrayList<BrowsingRow> bresList = new ArrayList<BrowsingRow>();
        ArrayList<GroupResult> facets = new ArrayList<GroupResult>();
        List ffList = this.queryRsp.getFacetFields();
        Long numberOfBrowsingResults = this.getNumberOfBrowsingResults();
        int i = 0;
        while (ffList != null && (long)i < numberOfBrowsingResults) {
            for (FacetField ff : ffList) {
                FacetField.Count facet;
                String name = null;
                if (this.aliases != null) {
                    name = (String)this.aliases.inverse().get((Object)ff.getName());
                }
                if (name == null) {
                    name = ff.getName();
                }
                if ((facet = this.getFacet(ff, i)) == null || facet.getCount() <= 0L) continue;
                String value = facet.getName();
                int count = (int)facet.getCount();
                if (!this.returnEmptyFields && value.isEmpty()) continue;
                facets.add(new GroupResult(name, value, count));
            }
            if (facets.size() > 0) {
                bresList.add(new BrowsingRow((List)Lists.newArrayList(facets)));
                facets.clear();
            }
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("BrowsingResult size: " + bresList.size()));
        }
        return bresList;
    }

    private FacetField.Count getFacet(FacetField ff, int pos) {
        if (ff.getValues() == null || pos >= ff.getValues().size()) {
            return null;
        }
        return (FacetField.Count)ff.getValues().get(pos);
    }

    private List<String> asRankedList(SolrDocumentList documentList) {
        Function<SolrDocument, String> wrapper;
        Function<SolrDocument, String> function = wrapper = this.includeRanking ? this.wrapperRank : this.wrapperNoRank;
        if (this.queryRsp.getHighlighting() != null) {
            return documentList.stream().map(doc -> {
                String score = this.getSingleField((SolrDocument)doc, "score");
                String hl = this.getHighlighting(this.getSingleField((SolrDocument)doc, "__indexrecordidentifier"));
                String res = hl != null ? hl : this.getSingleField((SolrDocument)doc, "__result");
                return this.includeRanking ? this.addRanking(res, score) : this.wrap(res);
            }).map(this.highlightUtils).collect(Collectors.toList());
        }
        return documentList.stream().map(wrapper).collect(Collectors.toList());
    }

    private String addRanking(String doc, String score) {
        return new String("<record rank=\"" + score + "\">" + doc + "</record>");
    }

    private String wrap(String doc) {
        return new String("<record>" + doc + "</record>");
    }

    protected String getSingleField(SolrDocument doc, String fieldName) {
        Object value = doc.getFieldValue(fieldName);
        if (value instanceof Collection) {
            return (String)Iterables.getOnlyElement((Iterable)((Iterable)value));
        }
        return String.valueOf(value);
    }

    private String getHighlighting(String docId) {
        Map highlight = (Map)this.queryRsp.getHighlighting().get(docId);
        String result = new String();
        if (highlight != null && highlight.get("__result") != null) {
            for (String s : (List)highlight.get("__result")) {
                result = result.concat(s);
            }
            return result;
        }
        return null;
    }

    private Long countFacets(List<FacetField.Count> facets) {
        if (facets == null) {
            return 0L;
        }
        return facets.stream().filter(c -> c != null && c.getName() != null && !c.getName().isEmpty() && c.getCount() > 0L).count();
    }

    public long getStart() {
        return this.queryRsp.getResults().getStart();
    }
}

