package eu.dnetlib.index.solr.cql;

import java.util.function.Function;

/**
 * Simply and not very roboust normalizer for solr dates. Basically it handles well yyyy-mm-dd and
 * yyyy-mm-ddThh:mm:ssZ
 *
 * @author marko
 */
public class SimpleDateValueTransformer implements Function<String, String> {

	@Override
	public String apply(final String value) {
		if (!value.endsWith("Z"))
			return value + "T00:00:00Z";
		return value;
	}
}