/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.action;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.index.IndexCollection;
import eu.dnetlib.index.IndexServerDAOMap;
import eu.dnetlib.index.action.AbstractIndexAction;
import eu.dnetlib.index.action.IndexAction;
import eu.dnetlib.rmi.provision.IndexServiceException;
import eu.dnetlib.utils.MetadataReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteByQueryAction
extends AbstractIndexAction
implements BlackboardServerAction<IndexAction> {
    private static final Log log = LogFactory.getLog(DeleteByQueryAction.class);
    @Autowired
    private IndexServerDAOMap indexServerDAOMap;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws IndexServiceException {
        String dsId = this.getIndexDSId(job);
        if (dsId == null) {
            throw new IndexServiceException("dsId Blackboard parameter is missing in DELETE BY QUERY message");
        }
        MetadataReference mdRef = this.getMetadataReference(dsId);
        String backendId = this.getBackend(job);
        if (backendId == null) {
            throw new IndexServiceException("No backend identifier information in DELETE BY QUERY message");
        }
        IndexCollection indexCollection = this.indexServerDAOMap.getIndexServerDAO(backendId).getIndexCollection(mdRef);
        String query = this.getQuery(job);
        log.info((Object)("DELETE BY QUERY: '" + query + "' on index '" + mdRef + "'"));
        if (!indexCollection.deleteByQuery(query, null)) {
            throw new IndexServiceException(String.format("Error to delete on index '%s', query '%s'", mdRef, query));
        }
        if (!indexCollection.commit()) {
            throw new IndexServiceException(String.format("Error to commit on index '%s'", mdRef));
        }
        log.info((Object)"DELETE BY QUERY done");
        indexCollection.shutdown();
        handler.done(job);
    }
}

