package eu.dnetlib.index;

import java.util.Map;

/**
 * The Interface IndexBackendDescriptor.
 */
public interface IndexBackendDescriptor {

	/**
	 * The id.
	 */
	public static String ID = "id";

	/**
	 * The address.
	 */
	public static String ADDRESS = "address";

	/**
	 * The address.
	 */
	public static String PORT = "port";

	/**
	 * Gets the backend id.
	 *
	 * @return the backend id
	 */
	public String getBackendId();

	/**
	 * Gets the endpoint.
	 *
	 * @return the endpoint
	 */
	public Map<String, String> getEndpoint();

	/**
	 * Gets the service properties.
	 *
	 * @return the service properties
	 */
	public Map<String, String> getServiceProperties();

}
