package eu.dnetlib.index;

import org.springframework.beans.factory.annotation.Required;

/**
 * The Class IndexServerDAOMapImpl.
 */
public class IndexServerDAOMapImpl implements IndexServerDAOMap {

	/**
	 * The index enumerator.
	 */
	private IndexBackendEnumerator indexEnumerator;

	/**
	 * {@inheritDoc}
	 *
	 * @see eu.dnetlib.functionality.index.IndexServerDAOMap#getIndexServerDAO(String)
	 */
	@Override
	public IndexServerDAO getIndexServerDAO(final String backendIdentifier) {
		return indexEnumerator.getDescriptor(backendIdentifier);
	}

	/**
	 * Gets the index enumerator.
	 *
	 * @return the indexEnumerator
	 */
	public IndexBackendEnumerator getIndexEnumerator() {
		return indexEnumerator;
	}

	/**
	 * Sets the index enumerator.
	 *
	 * @param indexEnumerator the indexEnumerator to set
	 */
	@Required
	public void setIndexEnumerator(final IndexBackendEnumerator indexEnumerator) {
		this.indexEnumerator = indexEnumerator;
	}

}
