package eu.dnetlib.oai.actions;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.oai.mongo.MongoPublisherStore;
import eu.dnetlib.oai.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.oai.utils.OAIParameterNames;
import eu.dnetlib.rmi.provision.OaiPublisherException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateStoreAction extends AbstractOAIStoreAction {

	private static final Log log = LogFactory.getLog(CreateStoreAction.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Autowired
	private MongoPublisherStoreDAO mongoPublisherStoreDAO;

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		String mdformat = job.getParameters().get(OAIParameterNames.OAI_FORMAT_NAME);
		String layout = job.getParameters().get(OAIParameterNames.OAI_FORMAT_LAYOUT);
		String interp = job.getParameters().get(OAIParameterNames.OAI_FORMAT_INTERPRETATION);
		String dbName = job.getParameters().get(OAIParameterNames.OAI_DB);
		String collection = job.getParameters().get(OAIParameterNames.OAI_COLLECTON);
		if (this.mongoPublisherStoreDAO.getStore(mdformat, interp, layout, dbName) == null) {
			MongoPublisherStore store = this.mongoPublisherStoreDAO.createStore(mdformat, interp, layout, dbName);
			if (store == null) {
				log.error("Cannot create MongoPublisherStore");
				handler.failed(job,
						new OaiPublisherException(String.format("Cannot create OAI store for %s, %s, %s on db %s", mdformat, interp, layout, dbName)));
			}
			log.info("Created store with id: " + store.getId() + "on db " + dbName + ": \n" + store.toString());
		} else {
			log.info("Store " + collection + " already exists on db " + dbName);
		}
		handler.done(job);
	}

}
