package eu.dnetlib.oai.actions;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.oai.utils.OAIHelper;
import eu.dnetlib.oai.utils.OAIParameterNames;
import org.springframework.beans.factory.annotation.Autowired;

public class RefreshConfigAction extends AbstractOAIStoreAction {

	@Autowired
	private OAIHelper oaiHelper;

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		String dbName = job.getParameters().get(OAIParameterNames.OAI_DB);
		oaiHelper.loadConfiguration(dbName);
		handler.done(job);
	}

	public OAIHelper getOaiSetHelper() {
		return this.oaiHelper;
	}

	public void setOaiHelper(final OAIHelper oaiSetHelper) {
		this.oaiHelper = oaiSetHelper;
	}

}
