package eu.dnetlib.oai.mongo;

import java.util.function.Function;

import org.dom4j.Document;
import org.dom4j.Node;

/**
 * Function to skip the header of the record and deliver only its metadata content as XML String.
 */
public class MetadataExtractor implements Function<Document, String> {

	@Override
	public String apply(final Document xmlDoc) {
		final Node metadataNode = xmlDoc.selectSingleNode("//*[local-name() = 'metadata']/*");
		// Node metadataNode = xmlDoc.selectSingleNode("/*[local-name()='record']/*[local-name() = 'metadata']/*");
		return metadataNode.asXML();
	}
}
