package eu.dnetlib.oai.mongo;

import java.util.function.Function;

import org.dom4j.Document;
import org.dom4j.Node;

/**
 * Function to deliver only the about/provenance content of a record as XML String.
 */
public class ProvenanceExtractor implements Function<Document, String> {

	@Override
	public String apply(final Document xmlDoc) {
		// Node provenanceNode = xmlDoc.selectSingleNode("//*[local-name() = 'about']/*[local-name() = 'provenance']");
		final Node provenanceNode = xmlDoc.selectSingleNode("/*[local-name()='record']/*[local-name() = 'about']/*[local-name() = 'provenance']");
		if (provenanceNode != null) {
			return provenanceNode.asXML();
		} else {
			return null;
		}
	}
}
