/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.action;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.index.IndexBackendEnumerator;
import eu.dnetlib.index.IndexServerDAOMap;
import eu.dnetlib.index.action.AbstractIndexAction;
import eu.dnetlib.index.action.IndexAction;
import eu.dnetlib.rmi.provision.IndexServiceException;
import eu.dnetlib.utils.MetadataReference;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class CreateIndexAction
extends AbstractIndexAction
implements BlackboardServerAction<IndexAction> {
    private static final Log log = LogFactory.getLog(CreateIndexAction.class);
    @Autowired
    private IndexServerDAOMap indexServerDAOMap;
    @Autowired
    private IndexBackendEnumerator backendEnumerator;
    private transient StringTemplate indexDsTemplate;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws IndexServiceException {
        MetadataReference mdRef = this.getMetadataReference(job);
        if (mdRef.getFormat() == null || mdRef.getLayout() == null) {
            throw new IndexServiceException("some Blackboard parameter is missing in CREATE message");
        }
        String fields = this.getMDFormatFields(mdRef);
        if (fields.isEmpty()) {
            throw new IndexServiceException("No result getting index layout informations");
        }
        String backendId = this.getBackend(job);
        if (backendId == null) {
            throw new IndexServiceException("No backend identifier information in CREATE message");
        }
        String dataStructure = this.getDataStructure(mdRef, backendId);
        String newId = this.serviceTools.registerProfile(dataStructure);
        log.info((Object)("registered DsId: " + newId + "\n" + dataStructure));
        this.indexServerDAOMap.getIndexServerDAO(backendId).createIndexCollection(mdRef, fields);
        this.serviceTools.incrementHandledDataStructures(backendId);
        job.getParameters().put("id", newId);
        handler.done(job);
    }

    private String getDataStructure(MetadataReference mdRef, String backendIdentifier) throws IndexServiceException {
        StringTemplate ds = new StringTemplate(this.indexDsTemplate.getTemplate());
        Object backendDescriptor = this.backendEnumerator.getDescriptor(backendIdentifier);
        if (backendDescriptor == null) {
            throw new IndexServiceException("No backend identifier found id:" + backendIdentifier);
        }
        String backendName = backendDescriptor.getEndpoint().get("id");
        if (backendName == null) {
            throw new IndexServiceException("No backend name associtated to the  identifier with id:" + backendIdentifier);
        }
        ds.setAttribute("serviceUri", (Object)this.getServiceAddress(backendIdentifier));
        ds.setAttribute("format", (Object)mdRef.getFormat());
        ds.setAttribute("layout", (Object)mdRef.getLayout());
        ds.setAttribute("interpretation", (Object)mdRef.getInterpretation());
        ds.setAttribute("backendID", (Object)backendIdentifier);
        ds.setAttribute("backendNAME", (Object)backendName);
        return ds.toString();
    }

    @Required
    public void setIndexDsTemplate(StringTemplate indexDsTemplate) {
        this.indexDsTemplate = indexDsTemplate;
    }
}

