/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.actors;

import com.google.common.collect.Maps;
import eu.dnetlib.index.actors.IndexFeedActor;
import eu.dnetlib.rmi.provision.IndexServiceException;
import java.util.Map;

public class ActorMap {
    private transient Map<String, IndexFeedActor> actorMap = Maps.newConcurrentMap();

    public boolean hasActor(String backendId) {
        return this.actorMap.containsKey(backendId);
    }

    public IndexFeedActor getActor(String backendId) throws IndexServiceException {
        if (!this.hasActor(backendId)) {
            throw new IndexServiceException("Actor not found for protocol ID " + backendId);
        }
        return this.actorMap.get(backendId);
    }

    public void addActor(String backendId, IndexFeedActor actor) {
        this.actorMap.put(backendId, actor);
    }
}

